/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a private IPv4 address for a Scheduled Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ScheduledInstancesPrivateIpAddressConfig implements
        ToCopyableBuilder<ScheduledInstancesPrivateIpAddressConfig.Builder, ScheduledInstancesPrivateIpAddressConfig> {
    private final Boolean primary;

    private final String privateIpAddress;

    private ScheduledInstancesPrivateIpAddressConfig(BuilderImpl builder) {
        this.primary = builder.primary;
        this.privateIpAddress = builder.privateIpAddress;
    }

    /**
     * <p>
     * Indicates whether this is a primary IPv4 address. Otherwise, this is a secondary IPv4 address.
     * </p>
     * 
     * @return Indicates whether this is a primary IPv4 address. Otherwise, this is a secondary IPv4 address.
     */
    public Boolean primary() {
        return primary;
    }

    /**
     * <p>
     * The IPv4 address.
     * </p>
     * 
     * @return The IPv4 address.
     */
    public String privateIpAddress() {
        return privateIpAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(primary());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstancesPrivateIpAddressConfig)) {
            return false;
        }
        ScheduledInstancesPrivateIpAddressConfig other = (ScheduledInstancesPrivateIpAddressConfig) obj;
        return Objects.equals(primary(), other.primary()) && Objects.equals(privateIpAddress(), other.privateIpAddress());
    }

    @Override
    public String toString() {
        return ToString.builder("ScheduledInstancesPrivateIpAddressConfig").add("Primary", primary())
                .add("PrivateIpAddress", privateIpAddress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Primary":
            return Optional.of(clazz.cast(primary()));
        case "PrivateIpAddress":
            return Optional.of(clazz.cast(privateIpAddress()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ScheduledInstancesPrivateIpAddressConfig> {
        /**
         * <p>
         * Indicates whether this is a primary IPv4 address. Otherwise, this is a secondary IPv4 address.
         * </p>
         * 
         * @param primary
         *        Indicates whether this is a primary IPv4 address. Otherwise, this is a secondary IPv4 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primary(Boolean primary);

        /**
         * <p>
         * The IPv4 address.
         * </p>
         * 
         * @param privateIpAddress
         *        The IPv4 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);
    }

    static final class BuilderImpl implements Builder {
        private Boolean primary;

        private String privateIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstancesPrivateIpAddressConfig model) {
            primary(model.primary);
            privateIpAddress(model.privateIpAddress);
        }

        public final Boolean getPrimary() {
            return primary;
        }

        @Override
        public final Builder primary(Boolean primary) {
            this.primary = primary;
            return this;
        }

        public final void setPrimary(Boolean primary) {
            this.primary = primary;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public ScheduledInstancesPrivateIpAddressConfig build() {
            return new ScheduledInstancesPrivateIpAddressConfig(this);
        }
    }
}
