/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a state change.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StateReason implements ToCopyableBuilder<StateReason.Builder, StateReason> {
    private final String code;

    private final String message;

    private StateReason(BuilderImpl builder) {
        this.code = builder.code;
        this.message = builder.message;
    }

    /**
     * <p>
     * The reason code for the state change.
     * </p>
     * 
     * @return The reason code for the state change.
     */
    public String code() {
        return code;
    }

    /**
     * <p>
     * The message for the state change.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Server.InsufficientInstanceCapacity</code>: There was insufficient instance capacity to satisfy the launch
     * request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Server.InternalError</code>: An internal error occurred during instance launch, resulting in termination.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Server.ScheduledStop</code>: The instance was stopped due to a scheduled retirement.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Server.SpotInstanceTermination</code>: A Spot Instance was terminated due to an increase in the market
     * price.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Client.InternalError</code>: A client error caused the instance to terminate on launch.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Client.InstanceInitiatedShutdown</code>: The instance was shut down using the <code>shutdown -h</code>
     * command from the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Client.InstanceTerminated</code>: The instance was terminated or rebooted during AMI creation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Client.UserInitiatedShutdown</code>: The instance was shut down using the Amazon EC2 API.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Client.VolumeLimitExceeded</code>: The limit on the number of EBS volumes or total storage was exceeded.
     * Decrease usage or request an increase in your limits.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Client.InvalidSnapshot.NotFound</code>: The specified snapshot was not found.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The message for the state change.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Server.InsufficientInstanceCapacity</code>: There was insufficient instance capacity to satisfy the
     *         launch request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Server.InternalError</code>: An internal error occurred during instance launch, resulting in
     *         termination.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Server.ScheduledStop</code>: The instance was stopped due to a scheduled retirement.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Server.SpotInstanceTermination</code>: A Spot Instance was terminated due to an increase in the
     *         market price.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Client.InternalError</code>: A client error caused the instance to terminate on launch.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Client.InstanceInitiatedShutdown</code>: The instance was shut down using the
     *         <code>shutdown -h</code> command from the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Client.InstanceTerminated</code>: The instance was terminated or rebooted during AMI creation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Client.UserInitiatedShutdown</code>: The instance was shut down using the Amazon EC2 API.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Client.VolumeLimitExceeded</code>: The limit on the number of EBS volumes or total storage was
     *         exceeded. Decrease usage or request an increase in your limits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Client.InvalidSnapshot.NotFound</code>: The specified snapshot was not found.
     *         </p>
     *         </li>
     */
    public String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StateReason)) {
            return false;
        }
        StateReason other = (StateReason) obj;
        return Objects.equals(code(), other.code()) && Objects.equals(message(), other.message());
    }

    @Override
    public String toString() {
        return ToString.builder("StateReason").add("Code", code()).add("Message", message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.of(clazz.cast(code()));
        case "Message":
            return Optional.of(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, StateReason> {
        /**
         * <p>
         * The reason code for the state change.
         * </p>
         * 
         * @param code
         *        The reason code for the state change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * The message for the state change.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Server.InsufficientInstanceCapacity</code>: There was insufficient instance capacity to satisfy the
         * launch request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Server.InternalError</code>: An internal error occurred during instance launch, resulting in
         * termination.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Server.ScheduledStop</code>: The instance was stopped due to a scheduled retirement.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Server.SpotInstanceTermination</code>: A Spot Instance was terminated due to an increase in the market
         * price.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Client.InternalError</code>: A client error caused the instance to terminate on launch.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Client.InstanceInitiatedShutdown</code>: The instance was shut down using the <code>shutdown -h</code>
         * command from the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Client.InstanceTerminated</code>: The instance was terminated or rebooted during AMI creation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Client.UserInitiatedShutdown</code>: The instance was shut down using the Amazon EC2 API.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Client.VolumeLimitExceeded</code>: The limit on the number of EBS volumes or total storage was
         * exceeded. Decrease usage or request an increase in your limits.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Client.InvalidSnapshot.NotFound</code>: The specified snapshot was not found.
         * </p>
         * </li>
         * </ul>
         * 
         * @param message
         *        The message for the state change.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Server.InsufficientInstanceCapacity</code>: There was insufficient instance capacity to satisfy
         *        the launch request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Server.InternalError</code>: An internal error occurred during instance launch, resulting in
         *        termination.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Server.ScheduledStop</code>: The instance was stopped due to a scheduled retirement.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Server.SpotInstanceTermination</code>: A Spot Instance was terminated due to an increase in the
         *        market price.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Client.InternalError</code>: A client error caused the instance to terminate on launch.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Client.InstanceInitiatedShutdown</code>: The instance was shut down using the
         *        <code>shutdown -h</code> command from the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Client.InstanceTerminated</code>: The instance was terminated or rebooted during AMI creation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Client.UserInitiatedShutdown</code>: The instance was shut down using the Amazon EC2 API.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Client.VolumeLimitExceeded</code>: The limit on the number of EBS volumes or total storage was
         *        exceeded. Decrease usage or request an increase in your limits.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Client.InvalidSnapshot.NotFound</code>: The specified snapshot was not found.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(StateReason model) {
            code(model.code);
            message(model.message);
        }

        public final String getCode() {
            return code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public StateReason build() {
            return new StateReason(this);
        }
    }
}
