/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a subnet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Subnet implements ToCopyableBuilder<Subnet.Builder, Subnet> {
    private final String availabilityZone;

    private final Integer availableIpAddressCount;

    private final String cidrBlock;

    private final Boolean defaultForAz;

    private final Boolean mapPublicIpOnLaunch;

    private final String state;

    private final String subnetId;

    private final String vpcId;

    private final Boolean assignIpv6AddressOnCreation;

    private final List<SubnetIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet;

    private final List<Tag> tags;

    private Subnet(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.availableIpAddressCount = builder.availableIpAddressCount;
        this.cidrBlock = builder.cidrBlock;
        this.defaultForAz = builder.defaultForAz;
        this.mapPublicIpOnLaunch = builder.mapPublicIpOnLaunch;
        this.state = builder.state;
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
        this.assignIpv6AddressOnCreation = builder.assignIpv6AddressOnCreation;
        this.ipv6CidrBlockAssociationSet = builder.ipv6CidrBlockAssociationSet;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Availability Zone of the subnet.
     * </p>
     * 
     * @return The Availability Zone of the subnet.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The number of unused private IPv4 addresses in the subnet. Note that the IPv4 addresses for any stopped instances
     * are considered unavailable.
     * </p>
     * 
     * @return The number of unused private IPv4 addresses in the subnet. Note that the IPv4 addresses for any stopped
     *         instances are considered unavailable.
     */
    public Integer availableIpAddressCount() {
        return availableIpAddressCount;
    }

    /**
     * <p>
     * The IPv4 CIDR block assigned to the subnet.
     * </p>
     * 
     * @return The IPv4 CIDR block assigned to the subnet.
     */
    public String cidrBlock() {
        return cidrBlock;
    }

    /**
     * <p>
     * Indicates whether this is the default subnet for the Availability Zone.
     * </p>
     * 
     * @return Indicates whether this is the default subnet for the Availability Zone.
     */
    public Boolean defaultForAz() {
        return defaultForAz;
    }

    /**
     * <p>
     * Indicates whether instances launched in this subnet receive a public IPv4 address.
     * </p>
     * 
     * @return Indicates whether instances launched in this subnet receive a public IPv4 address.
     */
    public Boolean mapPublicIpOnLaunch() {
        return mapPublicIpOnLaunch;
    }

    /**
     * <p>
     * The current state of the subnet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SubnetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The current state of the subnet.
     * @see SubnetState
     */
    public SubnetState state() {
        return SubnetState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the subnet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SubnetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The current state of the subnet.
     * @see SubnetState
     */
    public String stateString() {
        return state;
    }

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     * 
     * @return The ID of the subnet.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The ID of the VPC the subnet is in.
     * </p>
     * 
     * @return The ID of the VPC the subnet is in.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * Indicates whether a network interface created in this subnet (including a network interface created by
     * <a>RunInstances</a>) receives an IPv6 address.
     * </p>
     * 
     * @return Indicates whether a network interface created in this subnet (including a network interface created by
     *         <a>RunInstances</a>) receives an IPv6 address.
     */
    public Boolean assignIpv6AddressOnCreation() {
        return assignIpv6AddressOnCreation;
    }

    /**
     * <p>
     * Information about the IPv6 CIDR blocks associated with the subnet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the IPv6 CIDR blocks associated with the subnet.
     */
    public List<SubnetIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet() {
        return ipv6CidrBlockAssociationSet;
    }

    /**
     * <p>
     * Any tags assigned to the subnet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the subnet.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(availableIpAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(defaultForAz());
        hashCode = 31 * hashCode + Objects.hashCode(mapPublicIpOnLaunch());
        hashCode = 31 * hashCode + Objects.hashCode(stateString());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(assignIpv6AddressOnCreation());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6CidrBlockAssociationSet());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subnet)) {
            return false;
        }
        Subnet other = (Subnet) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(availableIpAddressCount(), other.availableIpAddressCount())
                && Objects.equals(cidrBlock(), other.cidrBlock()) && Objects.equals(defaultForAz(), other.defaultForAz())
                && Objects.equals(mapPublicIpOnLaunch(), other.mapPublicIpOnLaunch())
                && Objects.equals(stateString(), other.stateString()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(assignIpv6AddressOnCreation(), other.assignIpv6AddressOnCreation())
                && Objects.equals(ipv6CidrBlockAssociationSet(), other.ipv6CidrBlockAssociationSet())
                && Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        return ToString.builder("Subnet").add("AvailabilityZone", availabilityZone())
                .add("AvailableIpAddressCount", availableIpAddressCount()).add("CidrBlock", cidrBlock())
                .add("DefaultForAz", defaultForAz()).add("MapPublicIpOnLaunch", mapPublicIpOnLaunch())
                .add("State", stateString()).add("SubnetId", subnetId()).add("VpcId", vpcId())
                .add("AssignIpv6AddressOnCreation", assignIpv6AddressOnCreation())
                .add("Ipv6CidrBlockAssociationSet", ipv6CidrBlockAssociationSet()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.of(clazz.cast(availabilityZone()));
        case "AvailableIpAddressCount":
            return Optional.of(clazz.cast(availableIpAddressCount()));
        case "CidrBlock":
            return Optional.of(clazz.cast(cidrBlock()));
        case "DefaultForAz":
            return Optional.of(clazz.cast(defaultForAz()));
        case "MapPublicIpOnLaunch":
            return Optional.of(clazz.cast(mapPublicIpOnLaunch()));
        case "State":
            return Optional.of(clazz.cast(stateString()));
        case "SubnetId":
            return Optional.of(clazz.cast(subnetId()));
        case "VpcId":
            return Optional.of(clazz.cast(vpcId()));
        case "AssignIpv6AddressOnCreation":
            return Optional.of(clazz.cast(assignIpv6AddressOnCreation()));
        case "Ipv6CidrBlockAssociationSet":
            return Optional.of(clazz.cast(ipv6CidrBlockAssociationSet()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Subnet> {
        /**
         * <p>
         * The Availability Zone of the subnet.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The number of unused private IPv4 addresses in the subnet. Note that the IPv4 addresses for any stopped
         * instances are considered unavailable.
         * </p>
         * 
         * @param availableIpAddressCount
         *        The number of unused private IPv4 addresses in the subnet. Note that the IPv4 addresses for any
         *        stopped instances are considered unavailable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableIpAddressCount(Integer availableIpAddressCount);

        /**
         * <p>
         * The IPv4 CIDR block assigned to the subnet.
         * </p>
         * 
         * @param cidrBlock
         *        The IPv4 CIDR block assigned to the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);

        /**
         * <p>
         * Indicates whether this is the default subnet for the Availability Zone.
         * </p>
         * 
         * @param defaultForAz
         *        Indicates whether this is the default subnet for the Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultForAz(Boolean defaultForAz);

        /**
         * <p>
         * Indicates whether instances launched in this subnet receive a public IPv4 address.
         * </p>
         * 
         * @param mapPublicIpOnLaunch
         *        Indicates whether instances launched in this subnet receive a public IPv4 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch);

        /**
         * <p>
         * The current state of the subnet.
         * </p>
         * 
         * @param state
         *        The current state of the subnet.
         * @see SubnetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubnetState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the subnet.
         * </p>
         * 
         * @param state
         *        The current state of the subnet.
         * @see SubnetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubnetState
         */
        Builder state(SubnetState state);

        /**
         * <p>
         * The ID of the subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The ID of the VPC the subnet is in.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC the subnet is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * Indicates whether a network interface created in this subnet (including a network interface created by
         * <a>RunInstances</a>) receives an IPv6 address.
         * </p>
         * 
         * @param assignIpv6AddressOnCreation
         *        Indicates whether a network interface created in this subnet (including a network interface created by
         *        <a>RunInstances</a>) receives an IPv6 address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignIpv6AddressOnCreation(Boolean assignIpv6AddressOnCreation);

        /**
         * <p>
         * Information about the IPv6 CIDR blocks associated with the subnet.
         * </p>
         * 
         * @param ipv6CidrBlockAssociationSet
         *        Information about the IPv6 CIDR blocks associated with the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockAssociationSet(Collection<SubnetIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet);

        /**
         * <p>
         * Information about the IPv6 CIDR blocks associated with the subnet.
         * </p>
         * 
         * @param ipv6CidrBlockAssociationSet
         *        Information about the IPv6 CIDR blocks associated with the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockAssociationSet(SubnetIpv6CidrBlockAssociation... ipv6CidrBlockAssociationSet);

        /**
         * <p>
         * Any tags assigned to the subnet.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the subnet.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private Integer availableIpAddressCount;

        private String cidrBlock;

        private Boolean defaultForAz;

        private Boolean mapPublicIpOnLaunch;

        private String state;

        private String subnetId;

        private String vpcId;

        private Boolean assignIpv6AddressOnCreation;

        private List<SubnetIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(Subnet model) {
            availabilityZone(model.availabilityZone);
            availableIpAddressCount(model.availableIpAddressCount);
            cidrBlock(model.cidrBlock);
            defaultForAz(model.defaultForAz);
            mapPublicIpOnLaunch(model.mapPublicIpOnLaunch);
            state(model.state);
            subnetId(model.subnetId);
            vpcId(model.vpcId);
            assignIpv6AddressOnCreation(model.assignIpv6AddressOnCreation);
            ipv6CidrBlockAssociationSet(model.ipv6CidrBlockAssociationSet);
            tags(model.tags);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Integer getAvailableIpAddressCount() {
            return availableIpAddressCount;
        }

        @Override
        public final Builder availableIpAddressCount(Integer availableIpAddressCount) {
            this.availableIpAddressCount = availableIpAddressCount;
            return this;
        }

        public final void setAvailableIpAddressCount(Integer availableIpAddressCount) {
            this.availableIpAddressCount = availableIpAddressCount;
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final Boolean getDefaultForAz() {
            return defaultForAz;
        }

        @Override
        public final Builder defaultForAz(Boolean defaultForAz) {
            this.defaultForAz = defaultForAz;
            return this;
        }

        public final void setDefaultForAz(Boolean defaultForAz) {
            this.defaultForAz = defaultForAz;
        }

        public final Boolean getMapPublicIpOnLaunch() {
            return mapPublicIpOnLaunch;
        }

        @Override
        public final Builder mapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
            return this;
        }

        public final void setMapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SubnetState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Boolean getAssignIpv6AddressOnCreation() {
            return assignIpv6AddressOnCreation;
        }

        @Override
        public final Builder assignIpv6AddressOnCreation(Boolean assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation;
            return this;
        }

        public final void setAssignIpv6AddressOnCreation(Boolean assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation;
        }

        public final Collection<SubnetIpv6CidrBlockAssociation.Builder> getIpv6CidrBlockAssociationSet() {
            return ipv6CidrBlockAssociationSet != null ? ipv6CidrBlockAssociationSet.stream()
                    .map(SubnetIpv6CidrBlockAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv6CidrBlockAssociationSet(Collection<SubnetIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = SubnetIpv6CidrBlockAssociationSetCopier.copy(ipv6CidrBlockAssociationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockAssociationSet(SubnetIpv6CidrBlockAssociation... ipv6CidrBlockAssociationSet) {
            ipv6CidrBlockAssociationSet(Arrays.asList(ipv6CidrBlockAssociationSet));
            return this;
        }

        public final void setIpv6CidrBlockAssociationSet(
                Collection<SubnetIpv6CidrBlockAssociation.BuilderImpl> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = SubnetIpv6CidrBlockAssociationSetCopier
                    .copyFromBuilder(ipv6CidrBlockAssociationSet);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Subnet build() {
            return new Subnet(this);
        }
    }
}
