/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes whether a VPC is enabled for ClassicLink.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VpcClassicLink implements ToCopyableBuilder<VpcClassicLink.Builder, VpcClassicLink> {
    private final Boolean classicLinkEnabled;

    private final List<Tag> tags;

    private final String vpcId;

    private VpcClassicLink(BuilderImpl builder) {
        this.classicLinkEnabled = builder.classicLinkEnabled;
        this.tags = builder.tags;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * Indicates whether the VPC is enabled for ClassicLink.
     * </p>
     * 
     * @return Indicates whether the VPC is enabled for ClassicLink.
     */
    public Boolean classicLinkEnabled() {
        return classicLinkEnabled;
    }

    /**
     * <p>
     * Any tags assigned to the VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the VPC.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(classicLinkEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcClassicLink)) {
            return false;
        }
        VpcClassicLink other = (VpcClassicLink) obj;
        return Objects.equals(classicLinkEnabled(), other.classicLinkEnabled()) && Objects.equals(tags(), other.tags())
                && Objects.equals(vpcId(), other.vpcId());
    }

    @Override
    public String toString() {
        return ToString.builder("VpcClassicLink").add("ClassicLinkEnabled", classicLinkEnabled()).add("Tags", tags())
                .add("VpcId", vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClassicLinkEnabled":
            return Optional.of(clazz.cast(classicLinkEnabled()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        case "VpcId":
            return Optional.of(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, VpcClassicLink> {
        /**
         * <p>
         * Indicates whether the VPC is enabled for ClassicLink.
         * </p>
         * 
         * @param classicLinkEnabled
         *        Indicates whether the VPC is enabled for ClassicLink.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLinkEnabled(Boolean classicLinkEnabled);

        /**
         * <p>
         * Any tags assigned to the VPC.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the VPC.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private Boolean classicLinkEnabled;

        private List<Tag> tags;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcClassicLink model) {
            classicLinkEnabled(model.classicLinkEnabled);
            tags(model.tags);
            vpcId(model.vpcId);
        }

        public final Boolean getClassicLinkEnabled() {
            return classicLinkEnabled;
        }

        @Override
        public final Builder classicLinkEnabled(Boolean classicLinkEnabled) {
            this.classicLinkEnabled = classicLinkEnabled;
            return this;
        }

        public final void setClassicLinkEnabled(Boolean classicLinkEnabled) {
            this.classicLinkEnabled = classicLinkEnabled;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public VpcClassicLink build() {
            return new VpcClassicLink(this);
        }
    }
}
