/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a VPC peering connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VpcPeeringConnection implements ToCopyableBuilder<VpcPeeringConnection.Builder, VpcPeeringConnection> {
    private final VpcPeeringConnectionVpcInfo accepterVpcInfo;

    private final Instant expirationTime;

    private final VpcPeeringConnectionVpcInfo requesterVpcInfo;

    private final VpcPeeringConnectionStateReason status;

    private final List<Tag> tags;

    private final String vpcPeeringConnectionId;

    private VpcPeeringConnection(BuilderImpl builder) {
        this.accepterVpcInfo = builder.accepterVpcInfo;
        this.expirationTime = builder.expirationTime;
        this.requesterVpcInfo = builder.requesterVpcInfo;
        this.status = builder.status;
        this.tags = builder.tags;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    /**
     * <p>
     * Information about the accepter VPC. CIDR block information is only returned when describing an active VPC peering
     * connection.
     * </p>
     * 
     * @return Information about the accepter VPC. CIDR block information is only returned when describing an active VPC
     *         peering connection.
     */
    public VpcPeeringConnectionVpcInfo accepterVpcInfo() {
        return accepterVpcInfo;
    }

    /**
     * <p>
     * The time that an unaccepted VPC peering connection will expire.
     * </p>
     * 
     * @return The time that an unaccepted VPC peering connection will expire.
     */
    public Instant expirationTime() {
        return expirationTime;
    }

    /**
     * <p>
     * Information about the requester VPC. CIDR block information is only returned when describing an active VPC
     * peering connection.
     * </p>
     * 
     * @return Information about the requester VPC. CIDR block information is only returned when describing an active
     *         VPC peering connection.
     */
    public VpcPeeringConnectionVpcInfo requesterVpcInfo() {
        return requesterVpcInfo;
    }

    /**
     * <p>
     * The status of the VPC peering connection.
     * </p>
     * 
     * @return The status of the VPC peering connection.
     */
    public VpcPeeringConnectionStateReason status() {
        return status;
    }

    /**
     * <p>
     * Any tags assigned to the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the resource.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the VPC peering connection.
     * </p>
     * 
     * @return The ID of the VPC peering connection.
     */
    public String vpcPeeringConnectionId() {
        return vpcPeeringConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accepterVpcInfo());
        hashCode = 31 * hashCode + Objects.hashCode(expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(requesterVpcInfo());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(vpcPeeringConnectionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcPeeringConnection)) {
            return false;
        }
        VpcPeeringConnection other = (VpcPeeringConnection) obj;
        return Objects.equals(accepterVpcInfo(), other.accepterVpcInfo())
                && Objects.equals(expirationTime(), other.expirationTime())
                && Objects.equals(requesterVpcInfo(), other.requesterVpcInfo()) && Objects.equals(status(), other.status())
                && Objects.equals(tags(), other.tags())
                && Objects.equals(vpcPeeringConnectionId(), other.vpcPeeringConnectionId());
    }

    @Override
    public String toString() {
        return ToString.builder("VpcPeeringConnection").add("AccepterVpcInfo", accepterVpcInfo())
                .add("ExpirationTime", expirationTime()).add("RequesterVpcInfo", requesterVpcInfo()).add("Status", status())
                .add("Tags", tags()).add("VpcPeeringConnectionId", vpcPeeringConnectionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccepterVpcInfo":
            return Optional.of(clazz.cast(accepterVpcInfo()));
        case "ExpirationTime":
            return Optional.of(clazz.cast(expirationTime()));
        case "RequesterVpcInfo":
            return Optional.of(clazz.cast(requesterVpcInfo()));
        case "Status":
            return Optional.of(clazz.cast(status()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        case "VpcPeeringConnectionId":
            return Optional.of(clazz.cast(vpcPeeringConnectionId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, VpcPeeringConnection> {
        /**
         * <p>
         * Information about the accepter VPC. CIDR block information is only returned when describing an active VPC
         * peering connection.
         * </p>
         * 
         * @param accepterVpcInfo
         *        Information about the accepter VPC. CIDR block information is only returned when describing an active
         *        VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accepterVpcInfo(VpcPeeringConnectionVpcInfo accepterVpcInfo);

        /**
         * <p>
         * Information about the accepter VPC. CIDR block information is only returned when describing an active VPC
         * peering connection.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcPeeringConnectionVpcInfo.Builder} avoiding
         * the need to create one manually via {@link VpcPeeringConnectionVpcInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcPeeringConnectionVpcInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #accepterVpcInfo(VpcPeeringConnectionVpcInfo)}.
         * 
         * @param accepterVpcInfo
         *        a consumer that will call methods on {@link VpcPeeringConnectionVpcInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accepterVpcInfo(VpcPeeringConnectionVpcInfo)
         */
        default Builder accepterVpcInfo(Consumer<VpcPeeringConnectionVpcInfo.Builder> accepterVpcInfo) {
            return accepterVpcInfo(VpcPeeringConnectionVpcInfo.builder().apply(accepterVpcInfo).build());
        }

        /**
         * <p>
         * The time that an unaccepted VPC peering connection will expire.
         * </p>
         * 
         * @param expirationTime
         *        The time that an unaccepted VPC peering connection will expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationTime(Instant expirationTime);

        /**
         * <p>
         * Information about the requester VPC. CIDR block information is only returned when describing an active VPC
         * peering connection.
         * </p>
         * 
         * @param requesterVpcInfo
         *        Information about the requester VPC. CIDR block information is only returned when describing an active
         *        VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterVpcInfo(VpcPeeringConnectionVpcInfo requesterVpcInfo);

        /**
         * <p>
         * Information about the requester VPC. CIDR block information is only returned when describing an active VPC
         * peering connection.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcPeeringConnectionVpcInfo.Builder} avoiding
         * the need to create one manually via {@link VpcPeeringConnectionVpcInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcPeeringConnectionVpcInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #requesterVpcInfo(VpcPeeringConnectionVpcInfo)}.
         * 
         * @param requesterVpcInfo
         *        a consumer that will call methods on {@link VpcPeeringConnectionVpcInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requesterVpcInfo(VpcPeeringConnectionVpcInfo)
         */
        default Builder requesterVpcInfo(Consumer<VpcPeeringConnectionVpcInfo.Builder> requesterVpcInfo) {
            return requesterVpcInfo(VpcPeeringConnectionVpcInfo.builder().apply(requesterVpcInfo).build());
        }

        /**
         * <p>
         * The status of the VPC peering connection.
         * </p>
         * 
         * @param status
         *        The status of the VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(VpcPeeringConnectionStateReason status);

        /**
         * <p>
         * The status of the VPC peering connection.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcPeeringConnectionStateReason.Builder}
         * avoiding the need to create one manually via {@link VpcPeeringConnectionStateReason#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcPeeringConnectionStateReason.Builder#build()} is called
         * immediately and its result is passed to {@link #status(VpcPeeringConnectionStateReason)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link VpcPeeringConnectionStateReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(VpcPeeringConnectionStateReason)
         */
        default Builder status(Consumer<VpcPeeringConnectionStateReason.Builder> status) {
            return status(VpcPeeringConnectionStateReason.builder().apply(status).build());
        }

        /**
         * <p>
         * Any tags assigned to the resource.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the resource.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The ID of the VPC peering connection.
         * </p>
         * 
         * @param vpcPeeringConnectionId
         *        The ID of the VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnectionId(String vpcPeeringConnectionId);
    }

    static final class BuilderImpl implements Builder {
        private VpcPeeringConnectionVpcInfo accepterVpcInfo;

        private Instant expirationTime;

        private VpcPeeringConnectionVpcInfo requesterVpcInfo;

        private VpcPeeringConnectionStateReason status;

        private List<Tag> tags;

        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcPeeringConnection model) {
            accepterVpcInfo(model.accepterVpcInfo);
            expirationTime(model.expirationTime);
            requesterVpcInfo(model.requesterVpcInfo);
            status(model.status);
            tags(model.tags);
            vpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final VpcPeeringConnectionVpcInfo.Builder getAccepterVpcInfo() {
            return accepterVpcInfo != null ? accepterVpcInfo.toBuilder() : null;
        }

        @Override
        public final Builder accepterVpcInfo(VpcPeeringConnectionVpcInfo accepterVpcInfo) {
            this.accepterVpcInfo = accepterVpcInfo;
            return this;
        }

        public final void setAccepterVpcInfo(VpcPeeringConnectionVpcInfo.BuilderImpl accepterVpcInfo) {
            this.accepterVpcInfo = accepterVpcInfo != null ? accepterVpcInfo.build() : null;
        }

        public final Instant getExpirationTime() {
            return expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        public final VpcPeeringConnectionVpcInfo.Builder getRequesterVpcInfo() {
            return requesterVpcInfo != null ? requesterVpcInfo.toBuilder() : null;
        }

        @Override
        public final Builder requesterVpcInfo(VpcPeeringConnectionVpcInfo requesterVpcInfo) {
            this.requesterVpcInfo = requesterVpcInfo;
            return this;
        }

        public final void setRequesterVpcInfo(VpcPeeringConnectionVpcInfo.BuilderImpl requesterVpcInfo) {
            this.requesterVpcInfo = requesterVpcInfo != null ? requesterVpcInfo.build() : null;
        }

        public final VpcPeeringConnectionStateReason.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        @Override
        public final Builder status(VpcPeeringConnectionStateReason status) {
            this.status = status;
            return this;
        }

        public final void setStatus(VpcPeeringConnectionStateReason.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getVpcPeeringConnectionId() {
            return vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public VpcPeeringConnection build() {
            return new VpcPeeringConnection(this);
        }
    }
}
