/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a virtual private gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VpnGateway implements ToCopyableBuilder<VpnGateway.Builder, VpnGateway> {
    private final String availabilityZone;

    private final String state;

    private final String type;

    private final List<VpcAttachment> vpcAttachments;

    private final String vpnGatewayId;

    private final Long amazonSideAsn;

    private final List<Tag> tags;

    private VpnGateway(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.state = builder.state;
        this.type = builder.type;
        this.vpcAttachments = builder.vpcAttachments;
        this.vpnGatewayId = builder.vpnGatewayId;
        this.amazonSideAsn = builder.amazonSideAsn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Availability Zone where the virtual private gateway was created, if applicable. This field may be empty or
     * not returned.
     * </p>
     * 
     * @return The Availability Zone where the virtual private gateway was created, if applicable. This field may be
     *         empty or not returned.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The current state of the virtual private gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VpnState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The current state of the virtual private gateway.
     * @see VpnState
     */
    public VpnState state() {
        return VpnState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the virtual private gateway.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VpnState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The current state of the virtual private gateway.
     * @see VpnState
     */
    public String stateString() {
        return state;
    }

    /**
     * <p>
     * The type of VPN connection the virtual private gateway supports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GatewayType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of VPN connection the virtual private gateway supports.
     * @see GatewayType
     */
    public GatewayType type() {
        return GatewayType.fromValue(type);
    }

    /**
     * <p>
     * The type of VPN connection the virtual private gateway supports.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GatewayType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The type of VPN connection the virtual private gateway supports.
     * @see GatewayType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * Any VPCs attached to the virtual private gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any VPCs attached to the virtual private gateway.
     */
    public List<VpcAttachment> vpcAttachments() {
        return vpcAttachments;
    }

    /**
     * <p>
     * The ID of the virtual private gateway.
     * </p>
     * 
     * @return The ID of the virtual private gateway.
     */
    public String vpnGatewayId() {
        return vpnGatewayId;
    }

    /**
     * <p>
     * The private Autonomous System Number (ASN) for the Amazon side of a BGP session.
     * </p>
     * 
     * @return The private Autonomous System Number (ASN) for the Amazon side of a BGP session.
     */
    public Long amazonSideAsn() {
        return amazonSideAsn;
    }

    /**
     * <p>
     * Any tags assigned to the virtual private gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the virtual private gateway.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(stateString());
        hashCode = 31 * hashCode + Objects.hashCode(typeString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(vpnGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(amazonSideAsn());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnGateway)) {
            return false;
        }
        VpnGateway other = (VpnGateway) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(stateString(), other.stateString())
                && Objects.equals(typeString(), other.typeString()) && Objects.equals(vpcAttachments(), other.vpcAttachments())
                && Objects.equals(vpnGatewayId(), other.vpnGatewayId()) && Objects.equals(amazonSideAsn(), other.amazonSideAsn())
                && Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        return ToString.builder("VpnGateway").add("AvailabilityZone", availabilityZone()).add("State", stateString())
                .add("Type", typeString()).add("VpcAttachments", vpcAttachments()).add("VpnGatewayId", vpnGatewayId())
                .add("AmazonSideAsn", amazonSideAsn()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.of(clazz.cast(availabilityZone()));
        case "State":
            return Optional.of(clazz.cast(stateString()));
        case "Type":
            return Optional.of(clazz.cast(typeString()));
        case "VpcAttachments":
            return Optional.of(clazz.cast(vpcAttachments()));
        case "VpnGatewayId":
            return Optional.of(clazz.cast(vpnGatewayId()));
        case "AmazonSideAsn":
            return Optional.of(clazz.cast(amazonSideAsn()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, VpnGateway> {
        /**
         * <p>
         * The Availability Zone where the virtual private gateway was created, if applicable. This field may be empty
         * or not returned.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone where the virtual private gateway was created, if applicable. This field may be
         *        empty or not returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The current state of the virtual private gateway.
         * </p>
         * 
         * @param state
         *        The current state of the virtual private gateway.
         * @see VpnState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpnState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the virtual private gateway.
         * </p>
         * 
         * @param state
         *        The current state of the virtual private gateway.
         * @see VpnState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpnState
         */
        Builder state(VpnState state);

        /**
         * <p>
         * The type of VPN connection the virtual private gateway supports.
         * </p>
         * 
         * @param type
         *        The type of VPN connection the virtual private gateway supports.
         * @see GatewayType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of VPN connection the virtual private gateway supports.
         * </p>
         * 
         * @param type
         *        The type of VPN connection the virtual private gateway supports.
         * @see GatewayType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayType
         */
        Builder type(GatewayType type);

        /**
         * <p>
         * Any VPCs attached to the virtual private gateway.
         * </p>
         * 
         * @param vpcAttachments
         *        Any VPCs attached to the virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcAttachments(Collection<VpcAttachment> vpcAttachments);

        /**
         * <p>
         * Any VPCs attached to the virtual private gateway.
         * </p>
         * 
         * @param vpcAttachments
         *        Any VPCs attached to the virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcAttachments(VpcAttachment... vpcAttachments);

        /**
         * <p>
         * The ID of the virtual private gateway.
         * </p>
         * 
         * @param vpnGatewayId
         *        The ID of the virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnGatewayId(String vpnGatewayId);

        /**
         * <p>
         * The private Autonomous System Number (ASN) for the Amazon side of a BGP session.
         * </p>
         * 
         * @param amazonSideAsn
         *        The private Autonomous System Number (ASN) for the Amazon side of a BGP session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonSideAsn(Long amazonSideAsn);

        /**
         * <p>
         * Any tags assigned to the virtual private gateway.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the virtual private gateway.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private String state;

        private String type;

        private List<VpcAttachment> vpcAttachments;

        private String vpnGatewayId;

        private Long amazonSideAsn;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(VpnGateway model) {
            availabilityZone(model.availabilityZone);
            state(model.state);
            type(model.type);
            vpcAttachments(model.vpcAttachments);
            vpnGatewayId(model.vpnGatewayId);
            amazonSideAsn(model.amazonSideAsn);
            tags(model.tags);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpnState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GatewayType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<VpcAttachment.Builder> getVpcAttachments() {
            return vpcAttachments != null ? vpcAttachments.stream().map(VpcAttachment::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder vpcAttachments(Collection<VpcAttachment> vpcAttachments) {
            this.vpcAttachments = VpcAttachmentListCopier.copy(vpcAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcAttachments(VpcAttachment... vpcAttachments) {
            vpcAttachments(Arrays.asList(vpcAttachments));
            return this;
        }

        public final void setVpcAttachments(Collection<VpcAttachment.BuilderImpl> vpcAttachments) {
            this.vpcAttachments = VpcAttachmentListCopier.copyFromBuilder(vpcAttachments);
        }

        public final String getVpnGatewayId() {
            return vpnGatewayId;
        }

        @Override
        public final Builder vpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        public final void setVpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
        }

        public final Long getAmazonSideAsn() {
            return amazonSideAsn;
        }

        @Override
        public final Builder amazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
            return this;
        }

        public final void setAmazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public VpnGateway build() {
            return new VpnGateway(this);
        }
    }
}
