/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * DescribeClassicLinkInstancesResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeClassicLinkInstancesResponseUnmarshaller implements
        Unmarshaller<DescribeClassicLinkInstancesResponse, StaxUnmarshallerContext> {

    public DescribeClassicLinkInstancesResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeClassicLinkInstancesResponse.Builder describeClassicLinkInstancesResponse = DescribeClassicLinkInstancesResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<ClassicLinkInstance> instances = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeClassicLinkInstancesResponse.instances(instances);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("instancesSet", targetDepth)) {
                    instances = new ArrayList<ClassicLinkInstance>();
                    continue;
                }

                if (context.testExpression("instancesSet/item", targetDepth)) {
                    instances.add(ClassicLinkInstanceUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("nextToken", targetDepth)) {
                    describeClassicLinkInstancesResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeClassicLinkInstancesResponse.instances(instances);
                    break;
                }
            }
        }
        return describeClassicLinkInstancesResponse.build();
    }

    private static final DescribeClassicLinkInstancesResponseUnmarshaller INSTANCE = new DescribeClassicLinkInstancesResponseUnmarshaller();

    public static DescribeClassicLinkInstancesResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
