/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * GetReservedInstancesExchangeQuoteRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetReservedInstancesExchangeQuoteRequestMarshaller implements
        Marshaller<Request<GetReservedInstancesExchangeQuoteRequest>, GetReservedInstancesExchangeQuoteRequest> {

    public Request<GetReservedInstancesExchangeQuoteRequest> marshall(
            GetReservedInstancesExchangeQuoteRequest getReservedInstancesExchangeQuoteRequest) {

        if (getReservedInstancesExchangeQuoteRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<GetReservedInstancesExchangeQuoteRequest> request = new DefaultRequest<GetReservedInstancesExchangeQuoteRequest>(
                getReservedInstancesExchangeQuoteRequest, "EC2Client");
        request.addParameter("Action", "GetReservedInstancesExchangeQuote");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<String> getReservedInstancesExchangeQuoteRequestReservedInstanceIdsList = getReservedInstancesExchangeQuoteRequest
                .reservedInstanceIds();
        if (getReservedInstancesExchangeQuoteRequestReservedInstanceIdsList != null) {
            int reservedInstanceIdsListIndex = 1;

            for (String getReservedInstancesExchangeQuoteRequestReservedInstanceIdsListValue : getReservedInstancesExchangeQuoteRequestReservedInstanceIdsList) {
                if (getReservedInstancesExchangeQuoteRequestReservedInstanceIdsListValue != null) {
                    request.addParameter("ReservedInstanceId." + reservedInstanceIdsListIndex,
                            StringUtils.fromString(getReservedInstancesExchangeQuoteRequestReservedInstanceIdsListValue));
                }
                reservedInstanceIdsListIndex++;
            }
        }

        java.util.List<TargetConfigurationRequest> getReservedInstancesExchangeQuoteRequestTargetConfigurationsList = getReservedInstancesExchangeQuoteRequest
                .targetConfigurations();
        if (getReservedInstancesExchangeQuoteRequestTargetConfigurationsList != null) {
            int targetConfigurationsListIndex = 1;

            for (TargetConfigurationRequest getReservedInstancesExchangeQuoteRequestTargetConfigurationsListValue : getReservedInstancesExchangeQuoteRequestTargetConfigurationsList) {

                if (getReservedInstancesExchangeQuoteRequestTargetConfigurationsListValue.instanceCount() != null) {
                    request.addParameter("TargetConfiguration." + targetConfigurationsListIndex + ".InstanceCount", StringUtils
                            .fromInteger(getReservedInstancesExchangeQuoteRequestTargetConfigurationsListValue.instanceCount()));
                }

                if (getReservedInstancesExchangeQuoteRequestTargetConfigurationsListValue.offeringId() != null) {
                    request.addParameter("TargetConfiguration." + targetConfigurationsListIndex + ".OfferingId", StringUtils
                            .fromString(getReservedInstancesExchangeQuoteRequestTargetConfigurationsListValue.offeringId()));
                }
                targetConfigurationsListIndex++;
            }
        }

        return request;
    }

}
