/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * ImportImageRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ImportImageRequestMarshaller implements Marshaller<Request<ImportImageRequest>, ImportImageRequest> {

    public Request<ImportImageRequest> marshall(ImportImageRequest importImageRequest) {

        if (importImageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ImportImageRequest> request = new DefaultRequest<ImportImageRequest>(importImageRequest, "EC2Client");
        request.addParameter("Action", "ImportImage");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (importImageRequest.architecture() != null) {
            request.addParameter("Architecture", StringUtils.fromString(importImageRequest.architecture()));
        }

        ClientData clientData = importImageRequest.clientData();
        if (clientData != null) {

            if (clientData.comment() != null) {
                request.addParameter("ClientData.Comment", StringUtils.fromString(clientData.comment()));
            }

            if (clientData.uploadEnd() != null) {
                request.addParameter("ClientData.UploadEnd", StringUtils.fromInstant(clientData.uploadEnd()));
            }

            if (clientData.uploadSize() != null) {
                request.addParameter("ClientData.UploadSize", StringUtils.fromDouble(clientData.uploadSize()));
            }

            if (clientData.uploadStart() != null) {
                request.addParameter("ClientData.UploadStart", StringUtils.fromInstant(clientData.uploadStart()));
            }
        }

        if (importImageRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(importImageRequest.clientToken()));
        }

        if (importImageRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString(importImageRequest.description()));
        }

        java.util.List<ImageDiskContainer> importImageRequestDiskContainersList = importImageRequest.diskContainers();
        if (importImageRequestDiskContainersList != null) {
            int diskContainersListIndex = 1;

            for (ImageDiskContainer importImageRequestDiskContainersListValue : importImageRequestDiskContainersList) {

                if (importImageRequestDiskContainersListValue.description() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".Description",
                            StringUtils.fromString(importImageRequestDiskContainersListValue.description()));
                }

                if (importImageRequestDiskContainersListValue.deviceName() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".DeviceName",
                            StringUtils.fromString(importImageRequestDiskContainersListValue.deviceName()));
                }

                if (importImageRequestDiskContainersListValue.format() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".Format",
                            StringUtils.fromString(importImageRequestDiskContainersListValue.format()));
                }

                if (importImageRequestDiskContainersListValue.snapshotId() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".SnapshotId",
                            StringUtils.fromString(importImageRequestDiskContainersListValue.snapshotId()));
                }

                if (importImageRequestDiskContainersListValue.url() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".Url",
                            StringUtils.fromString(importImageRequestDiskContainersListValue.url()));
                }

                UserBucket userBucket = importImageRequestDiskContainersListValue.userBucket();
                if (userBucket != null) {

                    if (userBucket.s3Bucket() != null) {
                        request.addParameter("DiskContainer." + diskContainersListIndex + ".UserBucket.S3Bucket",
                                StringUtils.fromString(userBucket.s3Bucket()));
                    }

                    if (userBucket.s3Key() != null) {
                        request.addParameter("DiskContainer." + diskContainersListIndex + ".UserBucket.S3Key",
                                StringUtils.fromString(userBucket.s3Key()));
                    }
                }
                diskContainersListIndex++;
            }
        }

        if (importImageRequest.hypervisor() != null) {
            request.addParameter("Hypervisor", StringUtils.fromString(importImageRequest.hypervisor()));
        }

        if (importImageRequest.licenseType() != null) {
            request.addParameter("LicenseType", StringUtils.fromString(importImageRequest.licenseType()));
        }

        if (importImageRequest.platform() != null) {
            request.addParameter("Platform", StringUtils.fromString(importImageRequest.platform()));
        }

        if (importImageRequest.roleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString(importImageRequest.roleName()));
        }

        return request;
    }

}
