/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * InstanceStatus StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class InstanceStatusUnmarshaller implements Unmarshaller<InstanceStatus, StaxUnmarshallerContext> {

    public InstanceStatus unmarshall(StaxUnmarshallerContext context) throws Exception {
        InstanceStatus.Builder instanceStatus = InstanceStatus.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<InstanceStatusEvent> events = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                instanceStatus.events(events);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("availabilityZone", targetDepth)) {
                    instanceStatus.availabilityZone(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("eventsSet", targetDepth)) {
                    events = new ArrayList<InstanceStatusEvent>();
                    continue;
                }

                if (context.testExpression("eventsSet/item", targetDepth)) {
                    events.add(InstanceStatusEventUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceId", targetDepth)) {
                    instanceStatus.instanceId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceState", targetDepth)) {
                    instanceStatus.instanceState(InstanceStateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceStatus", targetDepth)) {
                    instanceStatus.instanceStatus(InstanceStatusSummaryUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("systemStatus", targetDepth)) {
                    instanceStatus.systemStatus(InstanceStatusSummaryUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    instanceStatus.events(events);
                    break;
                }
            }
        }
        return instanceStatus.build();
    }

    private static final InstanceStatusUnmarshaller INSTANCE = new InstanceStatusUnmarshaller();

    public static InstanceStatusUnmarshaller getInstance() {
        return INSTANCE;
    }
}
