/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * Instance StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class InstanceUnmarshaller implements Unmarshaller<Instance, StaxUnmarshallerContext> {

    public Instance unmarshall(StaxUnmarshallerContext context) throws Exception {
        Instance.Builder instance = Instance.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<ProductCode> productCodes = null;
        java.util.List<InstanceBlockDeviceMapping> blockDeviceMappings = null;
        java.util.List<ElasticGpuAssociation> elasticGpuAssociations = null;
        java.util.List<InstanceNetworkInterface> networkInterfaces = null;
        java.util.List<GroupIdentifier> securityGroups = null;
        java.util.List<Tag> tags = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                instance.productCodes(productCodes);
                instance.blockDeviceMappings(blockDeviceMappings);
                instance.elasticGpuAssociations(elasticGpuAssociations);
                instance.networkInterfaces(networkInterfaces);
                instance.securityGroups(securityGroups);
                instance.tags(tags);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("amiLaunchIndex", targetDepth)) {
                    instance.amiLaunchIndex(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("imageId", targetDepth)) {
                    instance.imageId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceId", targetDepth)) {
                    instance.instanceId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceType", targetDepth)) {
                    instance.instanceType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("kernelId", targetDepth)) {
                    instance.kernelId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("keyName", targetDepth)) {
                    instance.keyName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("launchTime", targetDepth)) {
                    instance.launchTime(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("monitoring", targetDepth)) {
                    instance.monitoring(MonitoringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("placement", targetDepth)) {
                    instance.placement(PlacementUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("platform", targetDepth)) {
                    instance.platform(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("privateDnsName", targetDepth)) {
                    instance.privateDnsName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("privateIpAddress", targetDepth)) {
                    instance.privateIpAddress(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("productCodes", targetDepth)) {
                    productCodes = new ArrayList<ProductCode>();
                    continue;
                }

                if (context.testExpression("productCodes/item", targetDepth)) {
                    productCodes.add(ProductCodeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("dnsName", targetDepth)) {
                    instance.publicDnsName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ipAddress", targetDepth)) {
                    instance.publicIpAddress(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ramdiskId", targetDepth)) {
                    instance.ramdiskId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceState", targetDepth)) {
                    instance.state(InstanceStateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("reason", targetDepth)) {
                    instance.stateTransitionReason(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("subnetId", targetDepth)) {
                    instance.subnetId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("vpcId", targetDepth)) {
                    instance.vpcId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("architecture", targetDepth)) {
                    instance.architecture(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("blockDeviceMapping", targetDepth)) {
                    blockDeviceMappings = new ArrayList<InstanceBlockDeviceMapping>();
                    continue;
                }

                if (context.testExpression("blockDeviceMapping/item", targetDepth)) {
                    blockDeviceMappings.add(InstanceBlockDeviceMappingUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("clientToken", targetDepth)) {
                    instance.clientToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ebsOptimized", targetDepth)) {
                    instance.ebsOptimized(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("enaSupport", targetDepth)) {
                    instance.enaSupport(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("hypervisor", targetDepth)) {
                    instance.hypervisor(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("iamInstanceProfile", targetDepth)) {
                    instance.iamInstanceProfile(IamInstanceProfileUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceLifecycle", targetDepth)) {
                    instance.instanceLifecycle(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("elasticGpuAssociationSet", targetDepth)) {
                    elasticGpuAssociations = new ArrayList<ElasticGpuAssociation>();
                    continue;
                }

                if (context.testExpression("elasticGpuAssociationSet/item", targetDepth)) {
                    elasticGpuAssociations.add(ElasticGpuAssociationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("networkInterfaceSet", targetDepth)) {
                    networkInterfaces = new ArrayList<InstanceNetworkInterface>();
                    continue;
                }

                if (context.testExpression("networkInterfaceSet/item", targetDepth)) {
                    networkInterfaces.add(InstanceNetworkInterfaceUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("rootDeviceName", targetDepth)) {
                    instance.rootDeviceName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("rootDeviceType", targetDepth)) {
                    instance.rootDeviceType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("groupSet", targetDepth)) {
                    securityGroups = new ArrayList<GroupIdentifier>();
                    continue;
                }

                if (context.testExpression("groupSet/item", targetDepth)) {
                    securityGroups.add(GroupIdentifierUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("sourceDestCheck", targetDepth)) {
                    instance.sourceDestCheck(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("spotInstanceRequestId", targetDepth)) {
                    instance.spotInstanceRequestId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("sriovNetSupport", targetDepth)) {
                    instance.sriovNetSupport(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("stateReason", targetDepth)) {
                    instance.stateReason(StateReasonUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("tagSet", targetDepth)) {
                    tags = new ArrayList<Tag>();
                    continue;
                }

                if (context.testExpression("tagSet/item", targetDepth)) {
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("virtualizationType", targetDepth)) {
                    instance.virtualizationType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    instance.productCodes(productCodes);
                    instance.blockDeviceMappings(blockDeviceMappings);
                    instance.elasticGpuAssociations(elasticGpuAssociations);
                    instance.networkInterfaces(networkInterfaces);
                    instance.securityGroups(securityGroups);
                    instance.tags(tags);
                    break;
                }
            }
        }
        return instance.build();
    }

    private static final InstanceUnmarshaller INSTANCE = new InstanceUnmarshaller();

    public static InstanceUnmarshaller getInstance() {
        return INSTANCE;
    }
}
