/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * RegisterImageRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class RegisterImageRequestMarshaller implements Marshaller<Request<RegisterImageRequest>, RegisterImageRequest> {

    public Request<RegisterImageRequest> marshall(RegisterImageRequest registerImageRequest) {

        if (registerImageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<RegisterImageRequest> request = new DefaultRequest<RegisterImageRequest>(registerImageRequest, "EC2Client");
        request.addParameter("Action", "RegisterImage");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (registerImageRequest.imageLocation() != null) {
            request.addParameter("ImageLocation", StringUtils.fromString(registerImageRequest.imageLocation()));
        }

        if (registerImageRequest.architectureString() != null) {
            request.addParameter("Architecture", StringUtils.fromString(registerImageRequest.architectureString()));
        }

        java.util.List<BlockDeviceMapping> registerImageRequestBlockDeviceMappingsList = registerImageRequest
                .blockDeviceMappings();
        if (registerImageRequestBlockDeviceMappingsList != null) {
            int blockDeviceMappingsListIndex = 1;

            for (BlockDeviceMapping registerImageRequestBlockDeviceMappingsListValue : registerImageRequestBlockDeviceMappingsList) {

                if (registerImageRequestBlockDeviceMappingsListValue.deviceName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName",
                            StringUtils.fromString(registerImageRequestBlockDeviceMappingsListValue.deviceName()));
                }

                if (registerImageRequestBlockDeviceMappingsListValue.virtualName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName",
                            StringUtils.fromString(registerImageRequestBlockDeviceMappingsListValue.virtualName()));
                }

                EbsBlockDevice ebs = registerImageRequestBlockDeviceMappingsListValue.ebs();
                if (ebs != null) {

                    if (ebs.encrypted() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted",
                                StringUtils.fromBoolean(ebs.encrypted()));
                    }

                    if (ebs.deleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination",
                                StringUtils.fromBoolean(ebs.deleteOnTermination()));
                    }

                    if (ebs.iops() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops",
                                StringUtils.fromInteger(ebs.iops()));
                    }

                    if (ebs.snapshotId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId",
                                StringUtils.fromString(ebs.snapshotId()));
                    }

                    if (ebs.volumeSize() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize",
                                StringUtils.fromInteger(ebs.volumeSize()));
                    }

                    if (ebs.volumeTypeString() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType",
                                StringUtils.fromString(ebs.volumeTypeString()));
                    }
                }

                if (registerImageRequestBlockDeviceMappingsListValue.noDevice() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice",
                            StringUtils.fromString(registerImageRequestBlockDeviceMappingsListValue.noDevice()));
                }
                blockDeviceMappingsListIndex++;
            }
        }

        if (registerImageRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString(registerImageRequest.description()));
        }

        if (registerImageRequest.enaSupport() != null) {
            request.addParameter("EnaSupport", StringUtils.fromBoolean(registerImageRequest.enaSupport()));
        }

        if (registerImageRequest.kernelId() != null) {
            request.addParameter("KernelId", StringUtils.fromString(registerImageRequest.kernelId()));
        }

        if (registerImageRequest.name() != null) {
            request.addParameter("Name", StringUtils.fromString(registerImageRequest.name()));
        }

        java.util.List<String> registerImageRequestBillingProductsList = registerImageRequest.billingProducts();
        if (registerImageRequestBillingProductsList != null) {
            int billingProductsListIndex = 1;

            for (String registerImageRequestBillingProductsListValue : registerImageRequestBillingProductsList) {
                if (registerImageRequestBillingProductsListValue != null) {
                    request.addParameter("BillingProduct." + billingProductsListIndex,
                            StringUtils.fromString(registerImageRequestBillingProductsListValue));
                }
                billingProductsListIndex++;
            }
        }

        if (registerImageRequest.ramdiskId() != null) {
            request.addParameter("RamdiskId", StringUtils.fromString(registerImageRequest.ramdiskId()));
        }

        if (registerImageRequest.rootDeviceName() != null) {
            request.addParameter("RootDeviceName", StringUtils.fromString(registerImageRequest.rootDeviceName()));
        }

        if (registerImageRequest.sriovNetSupport() != null) {
            request.addParameter("SriovNetSupport", StringUtils.fromString(registerImageRequest.sriovNetSupport()));
        }

        if (registerImageRequest.virtualizationType() != null) {
            request.addParameter("VirtualizationType", StringUtils.fromString(registerImageRequest.virtualizationType()));
        }

        return request;
    }

}
