/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ReservedInstancesOffering StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ReservedInstancesOfferingUnmarshaller implements Unmarshaller<ReservedInstancesOffering, StaxUnmarshallerContext> {

    public ReservedInstancesOffering unmarshall(StaxUnmarshallerContext context) throws Exception {
        ReservedInstancesOffering.Builder reservedInstancesOffering = ReservedInstancesOffering.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<PricingDetail> pricingDetails = null;
        java.util.List<RecurringCharge> recurringCharges = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                reservedInstancesOffering.pricingDetails(pricingDetails);
                reservedInstancesOffering.recurringCharges(recurringCharges);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("availabilityZone", targetDepth)) {
                    reservedInstancesOffering.availabilityZone(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("duration", targetDepth)) {
                    reservedInstancesOffering.duration(LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("fixedPrice", targetDepth)) {
                    reservedInstancesOffering.fixedPrice(FloatUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceType", targetDepth)) {
                    reservedInstancesOffering.instanceType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("productDescription", targetDepth)) {
                    reservedInstancesOffering.productDescription(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("reservedInstancesOfferingId", targetDepth)) {
                    reservedInstancesOffering.reservedInstancesOfferingId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("usagePrice", targetDepth)) {
                    reservedInstancesOffering.usagePrice(FloatUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("currencyCode", targetDepth)) {
                    reservedInstancesOffering.currencyCode(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("instanceTenancy", targetDepth)) {
                    reservedInstancesOffering.instanceTenancy(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("marketplace", targetDepth)) {
                    reservedInstancesOffering.marketplace(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("offeringClass", targetDepth)) {
                    reservedInstancesOffering.offeringClass(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("offeringType", targetDepth)) {
                    reservedInstancesOffering.offeringType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("pricingDetailsSet", targetDepth)) {
                    pricingDetails = new ArrayList<PricingDetail>();
                    continue;
                }

                if (context.testExpression("pricingDetailsSet/item", targetDepth)) {
                    pricingDetails.add(PricingDetailUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("recurringCharges", targetDepth)) {
                    recurringCharges = new ArrayList<RecurringCharge>();
                    continue;
                }

                if (context.testExpression("recurringCharges/item", targetDepth)) {
                    recurringCharges.add(RecurringChargeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("scope", targetDepth)) {
                    reservedInstancesOffering.scope(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    reservedInstancesOffering.pricingDetails(pricingDetails);
                    reservedInstancesOffering.recurringCharges(recurringCharges);
                    break;
                }
            }
        }
        return reservedInstancesOffering.build();
    }

    private static final ReservedInstancesOfferingUnmarshaller INSTANCE = new ReservedInstancesOfferingUnmarshaller();

    public static ReservedInstancesOfferingUnmarshaller getInstance() {
        return INSTANCE;
    }
}
