/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * VpcPeeringConnectionVpcInfo StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class VpcPeeringConnectionVpcInfoUnmarshaller implements
        Unmarshaller<VpcPeeringConnectionVpcInfo, StaxUnmarshallerContext> {

    public VpcPeeringConnectionVpcInfo unmarshall(StaxUnmarshallerContext context) throws Exception {
        VpcPeeringConnectionVpcInfo.Builder vpcPeeringConnectionVpcInfo = VpcPeeringConnectionVpcInfo.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<Ipv6CidrBlock> ipv6CidrBlockSet = null;
        java.util.List<CidrBlock> cidrBlockSet = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                vpcPeeringConnectionVpcInfo.ipv6CidrBlockSet(ipv6CidrBlockSet);
                vpcPeeringConnectionVpcInfo.cidrBlockSet(cidrBlockSet);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("cidrBlock", targetDepth)) {
                    vpcPeeringConnectionVpcInfo.cidrBlock(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ipv6CidrBlockSet", targetDepth)) {
                    ipv6CidrBlockSet = new ArrayList<Ipv6CidrBlock>();
                    continue;
                }

                if (context.testExpression("ipv6CidrBlockSet/item", targetDepth)) {
                    ipv6CidrBlockSet.add(Ipv6CidrBlockUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("cidrBlockSet", targetDepth)) {
                    cidrBlockSet = new ArrayList<CidrBlock>();
                    continue;
                }

                if (context.testExpression("cidrBlockSet/item", targetDepth)) {
                    cidrBlockSet.add(CidrBlockUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ownerId", targetDepth)) {
                    vpcPeeringConnectionVpcInfo.ownerId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("peeringOptions", targetDepth)) {
                    vpcPeeringConnectionVpcInfo.peeringOptions(VpcPeeringConnectionOptionsDescriptionUnmarshaller.getInstance()
                            .unmarshall(context));
                    continue;
                }

                if (context.testExpression("vpcId", targetDepth)) {
                    vpcPeeringConnectionVpcInfo.vpcId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    vpcPeeringConnectionVpcInfo.ipv6CidrBlockSet(ipv6CidrBlockSet);
                    vpcPeeringConnectionVpcInfo.cidrBlockSet(cidrBlockSet);
                    break;
                }
            }
        }
        return vpcPeeringConnectionVpcInfo.build();
    }

    private static final VpcPeeringConnectionVpcInfoUnmarshaller INSTANCE = new VpcPeeringConnectionVpcInfoUnmarshaller();

    public static VpcPeeringConnectionVpcInfoUnmarshaller getInstance() {
        return INSTANCE;
    }
}
