/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.IcmpTypeCode;
import software.amazon.awssdk.services.ec2.model.PortRange;
import software.amazon.awssdk.services.ec2.model.RuleAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateNetworkAclEntryRequest
extends EC2Request
implements ToCopyableBuilder<Builder, CreateNetworkAclEntryRequest> {
    private final String cidrBlock;
    private final Boolean egress;
    private final IcmpTypeCode icmpTypeCode;
    private final String ipv6CidrBlock;
    private final String networkAclId;
    private final PortRange portRange;
    private final String protocol;
    private final String ruleAction;
    private final Integer ruleNumber;

    private CreateNetworkAclEntryRequest(BuilderImpl builder) {
        super(builder);
        this.cidrBlock = builder.cidrBlock;
        this.egress = builder.egress;
        this.icmpTypeCode = builder.icmpTypeCode;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.networkAclId = builder.networkAclId;
        this.portRange = builder.portRange;
        this.protocol = builder.protocol;
        this.ruleAction = builder.ruleAction;
        this.ruleNumber = builder.ruleNumber;
    }

    public String cidrBlock() {
        return this.cidrBlock;
    }

    public Boolean egress() {
        return this.egress;
    }

    public IcmpTypeCode icmpTypeCode() {
        return this.icmpTypeCode;
    }

    public String ipv6CidrBlock() {
        return this.ipv6CidrBlock;
    }

    public String networkAclId() {
        return this.networkAclId;
    }

    public PortRange portRange() {
        return this.portRange;
    }

    public String protocol() {
        return this.protocol;
    }

    public RuleAction ruleAction() {
        return RuleAction.fromValue(this.ruleAction);
    }

    public String ruleActionString() {
        return this.ruleAction;
    }

    public Integer ruleNumber() {
        return this.ruleNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.egress());
        hashCode = 31 * hashCode + Objects.hashCode(this.icmpTypeCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAclId());
        hashCode = 31 * hashCode + Objects.hashCode(this.portRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleActionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkAclEntryRequest)) {
            return false;
        }
        CreateNetworkAclEntryRequest other = (CreateNetworkAclEntryRequest)((Object)obj);
        return Objects.equals(this.cidrBlock(), other.cidrBlock()) && Objects.equals(this.egress(), other.egress()) && Objects.equals(this.icmpTypeCode(), other.icmpTypeCode()) && Objects.equals(this.ipv6CidrBlock(), other.ipv6CidrBlock()) && Objects.equals(this.networkAclId(), other.networkAclId()) && Objects.equals(this.portRange(), other.portRange()) && Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.ruleActionString(), other.ruleActionString()) && Objects.equals(this.ruleNumber(), other.ruleNumber());
    }

    public String toString() {
        return ToString.builder((String)"CreateNetworkAclEntryRequest").add("CidrBlock", (Object)this.cidrBlock()).add("Egress", (Object)this.egress()).add("IcmpTypeCode", (Object)this.icmpTypeCode()).add("Ipv6CidrBlock", (Object)this.ipv6CidrBlock()).add("NetworkAclId", (Object)this.networkAclId()).add("PortRange", (Object)this.portRange()).add("Protocol", (Object)this.protocol()).add("RuleAction", (Object)this.ruleActionString()).add("RuleNumber", (Object)this.ruleNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CidrBlock": {
                return Optional.of(clazz.cast(this.cidrBlock()));
            }
            case "Egress": {
                return Optional.of(clazz.cast(this.egress()));
            }
            case "IcmpTypeCode": {
                return Optional.of(clazz.cast(this.icmpTypeCode()));
            }
            case "Ipv6CidrBlock": {
                return Optional.of(clazz.cast(this.ipv6CidrBlock()));
            }
            case "NetworkAclId": {
                return Optional.of(clazz.cast(this.networkAclId()));
            }
            case "PortRange": {
                return Optional.of(clazz.cast(this.portRange()));
            }
            case "Protocol": {
                return Optional.of(clazz.cast(this.protocol()));
            }
            case "RuleAction": {
                return Optional.of(clazz.cast(this.ruleActionString()));
            }
            case "RuleNumber": {
                return Optional.of(clazz.cast(this.ruleNumber()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String cidrBlock;
        private Boolean egress;
        private IcmpTypeCode icmpTypeCode;
        private String ipv6CidrBlock;
        private String networkAclId;
        private PortRange portRange;
        private String protocol;
        private String ruleAction;
        private Integer ruleNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkAclEntryRequest model) {
            this.cidrBlock(model.cidrBlock);
            this.egress(model.egress);
            this.icmpTypeCode(model.icmpTypeCode);
            this.ipv6CidrBlock(model.ipv6CidrBlock);
            this.networkAclId(model.networkAclId);
            this.portRange(model.portRange);
            this.protocol(model.protocol);
            this.ruleAction(model.ruleAction);
            this.ruleNumber(model.ruleNumber);
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final Boolean getEgress() {
            return this.egress;
        }

        @Override
        public final Builder egress(Boolean egress) {
            this.egress = egress;
            return this;
        }

        public final void setEgress(Boolean egress) {
            this.egress = egress;
        }

        public final IcmpTypeCode.Builder getIcmpTypeCode() {
            return this.icmpTypeCode != null ? this.icmpTypeCode.toBuilder() : null;
        }

        @Override
        public final Builder icmpTypeCode(IcmpTypeCode icmpTypeCode) {
            this.icmpTypeCode = icmpTypeCode;
            return this;
        }

        public final void setIcmpTypeCode(IcmpTypeCode.BuilderImpl icmpTypeCode) {
            this.icmpTypeCode = icmpTypeCode != null ? icmpTypeCode.build() : null;
        }

        public final String getIpv6CidrBlock() {
            return this.ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        public final String getNetworkAclId() {
            return this.networkAclId;
        }

        @Override
        public final Builder networkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public final void setNetworkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
        }

        public final PortRange.Builder getPortRange() {
            return this.portRange != null ? this.portRange.toBuilder() : null;
        }

        @Override
        public final Builder portRange(PortRange portRange) {
            this.portRange = portRange;
            return this;
        }

        public final void setPortRange(PortRange.BuilderImpl portRange) {
            this.portRange = portRange != null ? portRange.build() : null;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getRuleAction() {
            return this.ruleAction;
        }

        @Override
        public final Builder ruleAction(String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        @Override
        public final Builder ruleAction(RuleAction ruleAction) {
            this.ruleAction(ruleAction.toString());
            return this;
        }

        public final void setRuleAction(String ruleAction) {
            this.ruleAction = ruleAction;
        }

        public final Integer getRuleNumber() {
            return this.ruleNumber;
        }

        @Override
        public final Builder ruleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        public final void setRuleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateNetworkAclEntryRequest build() {
            return new CreateNetworkAclEntryRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, CreateNetworkAclEntryRequest> {
        public Builder cidrBlock(String var1);

        public Builder egress(Boolean var1);

        public Builder icmpTypeCode(IcmpTypeCode var1);

        default public Builder icmpTypeCode(Consumer<IcmpTypeCode.Builder> icmpTypeCode) {
            return this.icmpTypeCode((IcmpTypeCode)((IcmpTypeCode.Builder)IcmpTypeCode.builder().apply(icmpTypeCode)).build());
        }

        public Builder ipv6CidrBlock(String var1);

        public Builder networkAclId(String var1);

        public Builder portRange(PortRange var1);

        default public Builder portRange(Consumer<PortRange.Builder> portRange) {
            return this.portRange((PortRange)((PortRange.Builder)PortRange.builder().apply(portRange)).build());
        }

        public Builder protocol(String var1);

        public Builder ruleAction(String var1);

        public Builder ruleAction(RuleAction var1);

        public Builder ruleNumber(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

