/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.VpnConnectionOptionsSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateVpnConnectionRequest
extends EC2Request
implements ToCopyableBuilder<Builder, CreateVpnConnectionRequest> {
    private final String customerGatewayId;
    private final String type;
    private final String vpnGatewayId;
    private final VpnConnectionOptionsSpecification options;

    private CreateVpnConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.customerGatewayId = builder.customerGatewayId;
        this.type = builder.type;
        this.vpnGatewayId = builder.vpnGatewayId;
        this.options = builder.options;
    }

    public String customerGatewayId() {
        return this.customerGatewayId;
    }

    public String type() {
        return this.type;
    }

    public String vpnGatewayId() {
        return this.vpnGatewayId;
    }

    public VpnConnectionOptionsSpecification options() {
        return this.options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customerGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpnConnectionRequest)) {
            return false;
        }
        CreateVpnConnectionRequest other = (CreateVpnConnectionRequest)((Object)obj);
        return Objects.equals(this.customerGatewayId(), other.customerGatewayId()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.vpnGatewayId(), other.vpnGatewayId()) && Objects.equals(this.options(), other.options());
    }

    public String toString() {
        return ToString.builder((String)"CreateVpnConnectionRequest").add("CustomerGatewayId", (Object)this.customerGatewayId()).add("Type", (Object)this.type()).add("VpnGatewayId", (Object)this.vpnGatewayId()).add("Options", (Object)this.options()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomerGatewayId": {
                return Optional.of(clazz.cast(this.customerGatewayId()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.type()));
            }
            case "VpnGatewayId": {
                return Optional.of(clazz.cast(this.vpnGatewayId()));
            }
            case "Options": {
                return Optional.of(clazz.cast(this.options()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String customerGatewayId;
        private String type;
        private String vpnGatewayId;
        private VpnConnectionOptionsSpecification options;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpnConnectionRequest model) {
            this.customerGatewayId(model.customerGatewayId);
            this.type(model.type);
            this.vpnGatewayId(model.vpnGatewayId);
            this.options(model.options);
        }

        public final String getCustomerGatewayId() {
            return this.customerGatewayId;
        }

        @Override
        public final Builder customerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
            return this;
        }

        public final void setCustomerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getVpnGatewayId() {
            return this.vpnGatewayId;
        }

        @Override
        public final Builder vpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        public final void setVpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
        }

        public final VpnConnectionOptionsSpecification.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        @Override
        public final Builder options(VpnConnectionOptionsSpecification options) {
            this.options = options;
            return this;
        }

        public final void setOptions(VpnConnectionOptionsSpecification.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateVpnConnectionRequest build() {
            return new CreateVpnConnectionRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, CreateVpnConnectionRequest> {
        public Builder customerGatewayId(String var1);

        public Builder type(String var1);

        public Builder vpnGatewayId(String var1);

        public Builder options(VpnConnectionOptionsSpecification var1);

        default public Builder options(Consumer<VpnConnectionOptionsSpecification.Builder> options) {
            return this.options((VpnConnectionOptionsSpecification)((VpnConnectionOptionsSpecification.Builder)VpnConnectionOptionsSpecification.builder().apply(options)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

