/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.DhcpOptionsIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDhcpOptionsRequest
extends EC2Request
implements ToCopyableBuilder<Builder, DescribeDhcpOptionsRequest> {
    private final List<String> dhcpOptionsIds;
    private final List<Filter> filters;

    private DescribeDhcpOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.dhcpOptionsIds = builder.dhcpOptionsIds;
        this.filters = builder.filters;
    }

    public List<String> dhcpOptionsIds() {
        return this.dhcpOptionsIds;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dhcpOptionsIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDhcpOptionsRequest)) {
            return false;
        }
        DescribeDhcpOptionsRequest other = (DescribeDhcpOptionsRequest)((Object)obj);
        return Objects.equals(this.dhcpOptionsIds(), other.dhcpOptionsIds()) && Objects.equals(this.filters(), other.filters());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDhcpOptionsRequest").add("DhcpOptionsIds", this.dhcpOptionsIds()).add("Filters", this.filters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DhcpOptionsIds": {
                return Optional.of(clazz.cast(this.dhcpOptionsIds()));
            }
            case "Filters": {
                return Optional.of(clazz.cast(this.filters()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private List<String> dhcpOptionsIds;
        private List<Filter> filters;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDhcpOptionsRequest model) {
            this.dhcpOptionsIds(model.dhcpOptionsIds);
            this.filters(model.filters);
        }

        public final Collection<String> getDhcpOptionsIds() {
            return this.dhcpOptionsIds;
        }

        @Override
        public final Builder dhcpOptionsIds(Collection<String> dhcpOptionsIds) {
            this.dhcpOptionsIds = DhcpOptionsIdStringListCopier.copy(dhcpOptionsIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpOptionsIds(String ... dhcpOptionsIds) {
            this.dhcpOptionsIds(Arrays.asList(dhcpOptionsIds));
            return this;
        }

        public final void setDhcpOptionsIds(Collection<String> dhcpOptionsIds) {
            this.dhcpOptionsIds = DhcpOptionsIdStringListCopier.copy(dhcpOptionsIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeDhcpOptionsRequest build() {
            return new DescribeDhcpOptionsRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, DescribeDhcpOptionsRequest> {
        public Builder dhcpOptionsIds(Collection<String> var1);

        public Builder dhcpOptionsIds(String ... var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

