/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PeeringConnectionOptions
implements ToCopyableBuilder<Builder, PeeringConnectionOptions> {
    private final Boolean allowDnsResolutionFromRemoteVpc;
    private final Boolean allowEgressFromLocalClassicLinkToRemoteVpc;
    private final Boolean allowEgressFromLocalVpcToRemoteClassicLink;

    private PeeringConnectionOptions(BuilderImpl builder) {
        this.allowDnsResolutionFromRemoteVpc = builder.allowDnsResolutionFromRemoteVpc;
        this.allowEgressFromLocalClassicLinkToRemoteVpc = builder.allowEgressFromLocalClassicLinkToRemoteVpc;
        this.allowEgressFromLocalVpcToRemoteClassicLink = builder.allowEgressFromLocalVpcToRemoteClassicLink;
    }

    public Boolean allowDnsResolutionFromRemoteVpc() {
        return this.allowDnsResolutionFromRemoteVpc;
    }

    public Boolean allowEgressFromLocalClassicLinkToRemoteVpc() {
        return this.allowEgressFromLocalClassicLinkToRemoteVpc;
    }

    public Boolean allowEgressFromLocalVpcToRemoteClassicLink() {
        return this.allowEgressFromLocalVpcToRemoteClassicLink;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allowDnsResolutionFromRemoteVpc());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowEgressFromLocalClassicLinkToRemoteVpc());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowEgressFromLocalVpcToRemoteClassicLink());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PeeringConnectionOptions)) {
            return false;
        }
        PeeringConnectionOptions other = (PeeringConnectionOptions)obj;
        return Objects.equals(this.allowDnsResolutionFromRemoteVpc(), other.allowDnsResolutionFromRemoteVpc()) && Objects.equals(this.allowEgressFromLocalClassicLinkToRemoteVpc(), other.allowEgressFromLocalClassicLinkToRemoteVpc()) && Objects.equals(this.allowEgressFromLocalVpcToRemoteClassicLink(), other.allowEgressFromLocalVpcToRemoteClassicLink());
    }

    public String toString() {
        return ToString.builder((String)"PeeringConnectionOptions").add("AllowDnsResolutionFromRemoteVpc", (Object)this.allowDnsResolutionFromRemoteVpc()).add("AllowEgressFromLocalClassicLinkToRemoteVpc", (Object)this.allowEgressFromLocalClassicLinkToRemoteVpc()).add("AllowEgressFromLocalVpcToRemoteClassicLink", (Object)this.allowEgressFromLocalVpcToRemoteClassicLink()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowDnsResolutionFromRemoteVpc": {
                return Optional.of(clazz.cast(this.allowDnsResolutionFromRemoteVpc()));
            }
            case "AllowEgressFromLocalClassicLinkToRemoteVpc": {
                return Optional.of(clazz.cast(this.allowEgressFromLocalClassicLinkToRemoteVpc()));
            }
            case "AllowEgressFromLocalVpcToRemoteClassicLink": {
                return Optional.of(clazz.cast(this.allowEgressFromLocalVpcToRemoteClassicLink()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean allowDnsResolutionFromRemoteVpc;
        private Boolean allowEgressFromLocalClassicLinkToRemoteVpc;
        private Boolean allowEgressFromLocalVpcToRemoteClassicLink;

        private BuilderImpl() {
        }

        private BuilderImpl(PeeringConnectionOptions model) {
            this.allowDnsResolutionFromRemoteVpc(model.allowDnsResolutionFromRemoteVpc);
            this.allowEgressFromLocalClassicLinkToRemoteVpc(model.allowEgressFromLocalClassicLinkToRemoteVpc);
            this.allowEgressFromLocalVpcToRemoteClassicLink(model.allowEgressFromLocalVpcToRemoteClassicLink);
        }

        public final Boolean getAllowDnsResolutionFromRemoteVpc() {
            return this.allowDnsResolutionFromRemoteVpc;
        }

        @Override
        public final Builder allowDnsResolutionFromRemoteVpc(Boolean allowDnsResolutionFromRemoteVpc) {
            this.allowDnsResolutionFromRemoteVpc = allowDnsResolutionFromRemoteVpc;
            return this;
        }

        public final void setAllowDnsResolutionFromRemoteVpc(Boolean allowDnsResolutionFromRemoteVpc) {
            this.allowDnsResolutionFromRemoteVpc = allowDnsResolutionFromRemoteVpc;
        }

        public final Boolean getAllowEgressFromLocalClassicLinkToRemoteVpc() {
            return this.allowEgressFromLocalClassicLinkToRemoteVpc;
        }

        @Override
        public final Builder allowEgressFromLocalClassicLinkToRemoteVpc(Boolean allowEgressFromLocalClassicLinkToRemoteVpc) {
            this.allowEgressFromLocalClassicLinkToRemoteVpc = allowEgressFromLocalClassicLinkToRemoteVpc;
            return this;
        }

        public final void setAllowEgressFromLocalClassicLinkToRemoteVpc(Boolean allowEgressFromLocalClassicLinkToRemoteVpc) {
            this.allowEgressFromLocalClassicLinkToRemoteVpc = allowEgressFromLocalClassicLinkToRemoteVpc;
        }

        public final Boolean getAllowEgressFromLocalVpcToRemoteClassicLink() {
            return this.allowEgressFromLocalVpcToRemoteClassicLink;
        }

        @Override
        public final Builder allowEgressFromLocalVpcToRemoteClassicLink(Boolean allowEgressFromLocalVpcToRemoteClassicLink) {
            this.allowEgressFromLocalVpcToRemoteClassicLink = allowEgressFromLocalVpcToRemoteClassicLink;
            return this;
        }

        public final void setAllowEgressFromLocalVpcToRemoteClassicLink(Boolean allowEgressFromLocalVpcToRemoteClassicLink) {
            this.allowEgressFromLocalVpcToRemoteClassicLink = allowEgressFromLocalVpcToRemoteClassicLink;
        }

        public PeeringConnectionOptions build() {
            return new PeeringConnectionOptions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PeeringConnectionOptions> {
        public Builder allowDnsResolutionFromRemoteVpc(Boolean var1);

        public Builder allowEgressFromLocalClassicLinkToRemoteVpc(Boolean var1);

        public Builder allowEgressFromLocalVpcToRemoteClassicLink(Boolean var1);
    }
}

