/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.CurrencyCodeValues;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.RequestHostIdSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PurchaseHostReservationRequest
extends EC2Request
implements ToCopyableBuilder<Builder, PurchaseHostReservationRequest> {
    private final String clientToken;
    private final String currencyCode;
    private final List<String> hostIdSet;
    private final String limitPrice;
    private final String offeringId;

    private PurchaseHostReservationRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.currencyCode = builder.currencyCode;
        this.hostIdSet = builder.hostIdSet;
        this.limitPrice = builder.limitPrice;
        this.offeringId = builder.offeringId;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(this.currencyCode);
    }

    public String currencyCodeString() {
        return this.currencyCode;
    }

    public List<String> hostIdSet() {
        return this.hostIdSet;
    }

    public String limitPrice() {
        return this.limitPrice;
    }

    public String offeringId() {
        return this.offeringId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCodeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostIdSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.limitPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseHostReservationRequest)) {
            return false;
        }
        PurchaseHostReservationRequest other = (PurchaseHostReservationRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.currencyCodeString(), other.currencyCodeString()) && Objects.equals(this.hostIdSet(), other.hostIdSet()) && Objects.equals(this.limitPrice(), other.limitPrice()) && Objects.equals(this.offeringId(), other.offeringId());
    }

    public String toString() {
        return ToString.builder((String)"PurchaseHostReservationRequest").add("ClientToken", (Object)this.clientToken()).add("CurrencyCode", (Object)this.currencyCodeString()).add("HostIdSet", this.hostIdSet()).add("LimitPrice", (Object)this.limitPrice()).add("OfferingId", (Object)this.offeringId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.of(clazz.cast(this.clientToken()));
            }
            case "CurrencyCode": {
                return Optional.of(clazz.cast(this.currencyCodeString()));
            }
            case "HostIdSet": {
                return Optional.of(clazz.cast(this.hostIdSet()));
            }
            case "LimitPrice": {
                return Optional.of(clazz.cast(this.limitPrice()));
            }
            case "OfferingId": {
                return Optional.of(clazz.cast(this.offeringId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String clientToken;
        private String currencyCode;
        private List<String> hostIdSet;
        private String limitPrice;
        private String offeringId;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseHostReservationRequest model) {
            this.clientToken(model.clientToken);
            this.currencyCode(model.currencyCode);
            this.hostIdSet(model.hostIdSet);
            this.limitPrice(model.limitPrice);
            this.offeringId(model.offeringId);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Collection<String> getHostIdSet() {
            return this.hostIdSet;
        }

        @Override
        public final Builder hostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = RequestHostIdSetCopier.copy(hostIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIdSet(String ... hostIdSet) {
            this.hostIdSet(Arrays.asList(hostIdSet));
            return this;
        }

        public final void setHostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = RequestHostIdSetCopier.copy(hostIdSet);
        }

        public final String getLimitPrice() {
            return this.limitPrice;
        }

        @Override
        public final Builder limitPrice(String limitPrice) {
            this.limitPrice = limitPrice;
            return this;
        }

        public final void setLimitPrice(String limitPrice) {
            this.limitPrice = limitPrice;
        }

        public final String getOfferingId() {
            return this.offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PurchaseHostReservationRequest build() {
            return new PurchaseHostReservationRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, PurchaseHostReservationRequest> {
        public Builder clientToken(String var1);

        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCodeValues var1);

        public Builder hostIdSet(Collection<String> var1);

        public Builder hostIdSet(String ... var1);

        public Builder limitPrice(String var1);

        public Builder offeringId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

