/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ResourceType {
    CUSTOMER_GATEWAY("customer-gateway"),
    DHCP_OPTIONS("dhcp-options"),
    IMAGE("image"),
    INSTANCE("instance"),
    INTERNET_GATEWAY("internet-gateway"),
    NETWORK_ACL("network-acl"),
    NETWORK_INTERFACE("network-interface"),
    RESERVED_INSTANCES("reserved-instances"),
    ROUTE_TABLE("route-table"),
    SNAPSHOT("snapshot"),
    SPOT_INSTANCES_REQUEST("spot-instances-request"),
    SUBNET("subnet"),
    SECURITY_GROUP("security-group"),
    VOLUME("volume"),
    VPC("vpc"),
    VPN_CONNECTION("vpn-connection"),
    VPN_GATEWAY("vpn-gateway"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ResourceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceType> knownValues() {
        return Stream.of(ResourceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

