/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.StaleIpPermission;
import software.amazon.awssdk.services.ec2.model.StaleIpPermissionSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StaleSecurityGroup
implements ToCopyableBuilder<Builder, StaleSecurityGroup> {
    private final String description;
    private final String groupId;
    private final String groupName;
    private final List<StaleIpPermission> staleIpPermissions;
    private final List<StaleIpPermission> staleIpPermissionsEgress;
    private final String vpcId;

    private StaleSecurityGroup(BuilderImpl builder) {
        this.description = builder.description;
        this.groupId = builder.groupId;
        this.groupName = builder.groupName;
        this.staleIpPermissions = builder.staleIpPermissions;
        this.staleIpPermissionsEgress = builder.staleIpPermissionsEgress;
        this.vpcId = builder.vpcId;
    }

    public String description() {
        return this.description;
    }

    public String groupId() {
        return this.groupId;
    }

    public String groupName() {
        return this.groupName;
    }

    public List<StaleIpPermission> staleIpPermissions() {
        return this.staleIpPermissions;
    }

    public List<StaleIpPermission> staleIpPermissionsEgress() {
        return this.staleIpPermissionsEgress;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.staleIpPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.staleIpPermissionsEgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaleSecurityGroup)) {
            return false;
        }
        StaleSecurityGroup other = (StaleSecurityGroup)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.staleIpPermissions(), other.staleIpPermissions()) && Objects.equals(this.staleIpPermissionsEgress(), other.staleIpPermissionsEgress()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public String toString() {
        return ToString.builder((String)"StaleSecurityGroup").add("Description", (Object)this.description()).add("GroupId", (Object)this.groupId()).add("GroupName", (Object)this.groupName()).add("StaleIpPermissions", this.staleIpPermissions()).add("StaleIpPermissionsEgress", this.staleIpPermissionsEgress()).add("VpcId", (Object)this.vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "GroupId": {
                return Optional.of(clazz.cast(this.groupId()));
            }
            case "GroupName": {
                return Optional.of(clazz.cast(this.groupName()));
            }
            case "StaleIpPermissions": {
                return Optional.of(clazz.cast(this.staleIpPermissions()));
            }
            case "StaleIpPermissionsEgress": {
                return Optional.of(clazz.cast(this.staleIpPermissionsEgress()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String groupId;
        private String groupName;
        private List<StaleIpPermission> staleIpPermissions;
        private List<StaleIpPermission> staleIpPermissionsEgress;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(StaleSecurityGroup model) {
            this.description(model.description);
            this.groupId(model.groupId);
            this.groupName(model.groupName);
            this.staleIpPermissions(model.staleIpPermissions);
            this.staleIpPermissionsEgress(model.staleIpPermissionsEgress);
            this.vpcId(model.vpcId);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final Collection<StaleIpPermission.Builder> getStaleIpPermissions() {
            return this.staleIpPermissions != null ? (Collection)this.staleIpPermissions.stream().map(StaleIpPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder staleIpPermissions(Collection<StaleIpPermission> staleIpPermissions) {
            this.staleIpPermissions = StaleIpPermissionSetCopier.copy(staleIpPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staleIpPermissions(StaleIpPermission ... staleIpPermissions) {
            this.staleIpPermissions(Arrays.asList(staleIpPermissions));
            return this;
        }

        public final void setStaleIpPermissions(Collection<StaleIpPermission.BuilderImpl> staleIpPermissions) {
            this.staleIpPermissions = StaleIpPermissionSetCopier.copyFromBuilder(staleIpPermissions);
        }

        public final Collection<StaleIpPermission.Builder> getStaleIpPermissionsEgress() {
            return this.staleIpPermissionsEgress != null ? (Collection)this.staleIpPermissionsEgress.stream().map(StaleIpPermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder staleIpPermissionsEgress(Collection<StaleIpPermission> staleIpPermissionsEgress) {
            this.staleIpPermissionsEgress = StaleIpPermissionSetCopier.copy(staleIpPermissionsEgress);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staleIpPermissionsEgress(StaleIpPermission ... staleIpPermissionsEgress) {
            this.staleIpPermissionsEgress(Arrays.asList(staleIpPermissionsEgress));
            return this;
        }

        public final void setStaleIpPermissionsEgress(Collection<StaleIpPermission.BuilderImpl> staleIpPermissionsEgress) {
            this.staleIpPermissionsEgress = StaleIpPermissionSetCopier.copyFromBuilder(staleIpPermissionsEgress);
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public StaleSecurityGroup build() {
            return new StaleSecurityGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StaleSecurityGroup> {
        public Builder description(String var1);

        public Builder groupId(String var1);

        public Builder groupName(String var1);

        public Builder staleIpPermissions(Collection<StaleIpPermission> var1);

        public Builder staleIpPermissions(StaleIpPermission ... var1);

        public Builder staleIpPermissionsEgress(Collection<StaleIpPermission> var1);

        public Builder staleIpPermissionsEgress(StaleIpPermission ... var1);

        public Builder vpcId(String var1);
    }
}

