/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.InstanceStateChange;
import software.amazon.awssdk.services.ec2.model.InstanceStateChangeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StartInstancesResponse
extends EC2Response
implements ToCopyableBuilder<Builder, StartInstancesResponse> {
    private final List<InstanceStateChange> startingInstances;

    private StartInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.startingInstances = builder.startingInstances;
    }

    public List<InstanceStateChange> startingInstances() {
        return this.startingInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startingInstances());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartInstancesResponse)) {
            return false;
        }
        StartInstancesResponse other = (StartInstancesResponse)((Object)obj);
        return Objects.equals(this.startingInstances(), other.startingInstances());
    }

    public String toString() {
        return ToString.builder((String)"StartInstancesResponse").add("StartingInstances", this.startingInstances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartingInstances": {
                return Optional.of(clazz.cast(this.startingInstances()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private List<InstanceStateChange> startingInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(StartInstancesResponse model) {
            this.startingInstances(model.startingInstances);
        }

        public final Collection<InstanceStateChange.Builder> getStartingInstances() {
            return this.startingInstances != null ? (Collection)this.startingInstances.stream().map(InstanceStateChange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder startingInstances(Collection<InstanceStateChange> startingInstances) {
            this.startingInstances = InstanceStateChangeListCopier.copy(startingInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startingInstances(InstanceStateChange ... startingInstances) {
            this.startingInstances(Arrays.asList(startingInstances));
            return this;
        }

        public final void setStartingInstances(Collection<InstanceStateChange.BuilderImpl> startingInstances) {
            this.startingInstances = InstanceStateChangeListCopier.copyFromBuilder(startingInstances);
        }

        @Override
        public StartInstancesResponse build() {
            return new StartInstancesResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, StartInstancesResponse> {
        public Builder startingInstances(Collection<InstanceStateChange> var1);

        public Builder startingInstances(InstanceStateChange ... var1);
    }
}

