/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.ec2.EC2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusResponse;
import software.amazon.awssdk.services.ec2.model.VolumeStatusItem;

public class DescribeVolumeStatusPublisher
implements SdkPublisher<DescribeVolumeStatusResponse> {
    private final EC2AsyncClient client;
    private final DescribeVolumeStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeVolumeStatusPublisher(EC2AsyncClient client, DescribeVolumeStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeVolumeStatusPublisher(EC2AsyncClient client, DescribeVolumeStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeVolumeStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeVolumeStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<VolumeStatusItem> volumeStatuses() {
        Function<DescribeVolumeStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.volumeStatuses() != null) {
                return response.volumeStatuses().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeVolumeStatusResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeVolumeStatusPublisher resume(DescribeVolumeStatusResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeVolumeStatusPublisher(this.client, (DescribeVolumeStatusRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeVolumeStatusPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeVolumeStatusResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeVolumeStatusResponseFetcher
    implements AsyncPageFetcher<DescribeVolumeStatusResponse> {
        private DescribeVolumeStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVolumeStatusResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<DescribeVolumeStatusResponse> nextPage(DescribeVolumeStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeVolumeStatusPublisher.this.client.describeVolumeStatus(DescribeVolumeStatusPublisher.this.firstRequest);
            }
            return DescribeVolumeStatusPublisher.this.client.describeVolumeStatus((DescribeVolumeStatusRequest)((Object)DescribeVolumeStatusPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

