/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.AttachClassicLinkVpcRequest;

public class AttachClassicLinkVpcRequestMarshaller
implements Marshaller<Request<AttachClassicLinkVpcRequest>, AttachClassicLinkVpcRequest> {
    public Request<AttachClassicLinkVpcRequest> marshall(AttachClassicLinkVpcRequest attachClassicLinkVpcRequest) {
        if (attachClassicLinkVpcRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)attachClassicLinkVpcRequest, "EC2Client");
        request.addParameter("Action", "AttachClassicLinkVpc");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> attachClassicLinkVpcRequestGroupsList = attachClassicLinkVpcRequest.groups();
        if (attachClassicLinkVpcRequestGroupsList != null) {
            int groupsListIndex = 1;
            for (String attachClassicLinkVpcRequestGroupsListValue : attachClassicLinkVpcRequestGroupsList) {
                if (attachClassicLinkVpcRequestGroupsListValue != null) {
                    request.addParameter("SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)attachClassicLinkVpcRequestGroupsListValue));
                }
                ++groupsListIndex;
            }
        }
        if (attachClassicLinkVpcRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)attachClassicLinkVpcRequest.instanceId()));
        }
        if (attachClassicLinkVpcRequest.vpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString((String)attachClassicLinkVpcRequest.vpcId()));
        }
        return request;
    }
}

