/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.CreateVpnGatewayRequest;

public class CreateVpnGatewayRequestMarshaller
implements Marshaller<Request<CreateVpnGatewayRequest>, CreateVpnGatewayRequest> {
    public Request<CreateVpnGatewayRequest> marshall(CreateVpnGatewayRequest createVpnGatewayRequest) {
        if (createVpnGatewayRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createVpnGatewayRequest, "EC2Client");
        request.addParameter("Action", "CreateVpnGateway");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVpnGatewayRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)createVpnGatewayRequest.availabilityZone()));
        }
        if (createVpnGatewayRequest.typeString() != null) {
            request.addParameter("Type", StringUtils.fromString((String)createVpnGatewayRequest.typeString()));
        }
        if (createVpnGatewayRequest.amazonSideAsn() != null) {
            request.addParameter("AmazonSideAsn", StringUtils.fromLong((Long)createVpnGatewayRequest.amazonSideAsn()));
        }
        return request;
    }
}

