/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.ReportInstanceStatusRequest;

public class ReportInstanceStatusRequestMarshaller
implements Marshaller<Request<ReportInstanceStatusRequest>, ReportInstanceStatusRequest> {
    public Request<ReportInstanceStatusRequest> marshall(ReportInstanceStatusRequest reportInstanceStatusRequest) {
        List<String> reportInstanceStatusRequestReasonCodesList;
        List<String> reportInstanceStatusRequestInstancesList;
        if (reportInstanceStatusRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)reportInstanceStatusRequest, "EC2Client");
        request.addParameter("Action", "ReportInstanceStatus");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (reportInstanceStatusRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)reportInstanceStatusRequest.description()));
        }
        if (reportInstanceStatusRequest.endTime() != null) {
            request.addParameter("EndTime", StringUtils.fromInstant((Instant)reportInstanceStatusRequest.endTime()));
        }
        if ((reportInstanceStatusRequestInstancesList = reportInstanceStatusRequest.instances()) != null) {
            int instancesListIndex = 1;
            for (String reportInstanceStatusRequestInstancesListValue : reportInstanceStatusRequestInstancesList) {
                if (reportInstanceStatusRequestInstancesListValue != null) {
                    request.addParameter("InstanceId." + instancesListIndex, StringUtils.fromString((String)reportInstanceStatusRequestInstancesListValue));
                }
                ++instancesListIndex;
            }
        }
        if ((reportInstanceStatusRequestReasonCodesList = reportInstanceStatusRequest.reasonCodesStrings()) != null) {
            int reasonCodesListIndex = 1;
            for (String reportInstanceStatusRequestReasonCodesListValue : reportInstanceStatusRequestReasonCodesList) {
                if (reportInstanceStatusRequestReasonCodesListValue != null) {
                    request.addParameter("ReasonCode." + reasonCodesListIndex, StringUtils.fromString((String)reportInstanceStatusRequestReasonCodesListValue));
                }
                ++reasonCodesListIndex;
            }
        }
        if (reportInstanceStatusRequest.startTime() != null) {
            request.addParameter("StartTime", StringUtils.fromInstant((Instant)reportInstanceStatusRequest.startTime()));
        }
        if (reportInstanceStatusRequest.statusString() != null) {
            request.addParameter("Status", StringUtils.fromString((String)reportInstanceStatusRequest.statusString()));
        }
        return request;
    }
}

