/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInternetGatewayResponse extends Ec2Response implements
        ToCopyableBuilder<CreateInternetGatewayResponse.Builder, CreateInternetGatewayResponse> {
    private static final SdkField<InternetGateway> INTERNET_GATEWAY_FIELD = SdkField
            .<InternetGateway> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateInternetGatewayResponse::internetGateway))
            .setter(setter(Builder::internetGateway))
            .constructor(InternetGateway::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetGateway")
                    .unmarshallLocationName("internetGateway").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERNET_GATEWAY_FIELD));

    private final InternetGateway internetGateway;

    private CreateInternetGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.internetGateway = builder.internetGateway;
    }

    /**
     * <p>
     * Information about the internet gateway.
     * </p>
     * 
     * @return Information about the internet gateway.
     */
    public InternetGateway internetGateway() {
        return internetGateway;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(internetGateway());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInternetGatewayResponse)) {
            return false;
        }
        CreateInternetGatewayResponse other = (CreateInternetGatewayResponse) obj;
        return Objects.equals(internetGateway(), other.internetGateway());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateInternetGatewayResponse").add("InternetGateway", internetGateway()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InternetGateway":
            return Optional.ofNullable(clazz.cast(internetGateway()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateInternetGatewayResponse, T> g) {
        return obj -> g.apply((CreateInternetGatewayResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateInternetGatewayResponse> {
        /**
         * <p>
         * Information about the internet gateway.
         * </p>
         * 
         * @param internetGateway
         *        Information about the internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internetGateway(InternetGateway internetGateway);

        /**
         * <p>
         * Information about the internet gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link InternetGateway.Builder} avoiding the need to
         * create one manually via {@link InternetGateway#builder()}.
         *
         * When the {@link Consumer} completes, {@link InternetGateway.Builder#build()} is called immediately and its
         * result is passed to {@link #internetGateway(InternetGateway)}.
         * 
         * @param internetGateway
         *        a consumer that will call methods on {@link InternetGateway.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #internetGateway(InternetGateway)
         */
        default Builder internetGateway(Consumer<InternetGateway.Builder> internetGateway) {
            return internetGateway(InternetGateway.builder().applyMutation(internetGateway).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private InternetGateway internetGateway;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInternetGatewayResponse model) {
            super(model);
            internetGateway(model.internetGateway);
        }

        public final InternetGateway.Builder getInternetGateway() {
            return internetGateway != null ? internetGateway.toBuilder() : null;
        }

        @Override
        public final Builder internetGateway(InternetGateway internetGateway) {
            this.internetGateway = internetGateway;
            return this;
        }

        public final void setInternetGateway(InternetGateway.BuilderImpl internetGateway) {
            this.internetGateway = internetGateway != null ? internetGateway.build() : null;
        }

        @Override
        public CreateInternetGatewayResponse build() {
            return new CreateInternetGatewayResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
