/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLaunchTemplateRequest extends Ec2Request implements
        ToCopyableBuilder<CreateLaunchTemplateRequest.Builder, CreateLaunchTemplateRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLaunchTemplateRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build()).build();

    private static final SdkField<String> LAUNCH_TEMPLATE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLaunchTemplateRequest::launchTemplateName))
            .setter(setter(Builder::launchTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateName")
                    .unmarshallLocationName("LaunchTemplateName").build()).build();

    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLaunchTemplateRequest::versionDescription))
            .setter(setter(Builder::versionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription")
                    .unmarshallLocationName("VersionDescription").build()).build();

    private static final SdkField<RequestLaunchTemplateData> LAUNCH_TEMPLATE_DATA_FIELD = SdkField
            .<RequestLaunchTemplateData> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateLaunchTemplateRequest::launchTemplateData))
            .setter(setter(Builder::launchTemplateData))
            .constructor(RequestLaunchTemplateData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateData")
                    .unmarshallLocationName("LaunchTemplateData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            LAUNCH_TEMPLATE_NAME_FIELD, VERSION_DESCRIPTION_FIELD, LAUNCH_TEMPLATE_DATA_FIELD));

    private final String clientToken;

    private final String launchTemplateName;

    private final String versionDescription;

    private final RequestLaunchTemplateData launchTemplateData;

    private CreateLaunchTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.launchTemplateName = builder.launchTemplateName;
        this.versionDescription = builder.versionDescription;
        this.launchTemplateData = builder.launchTemplateData;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see
     * <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A name for the launch template.
     * </p>
     * 
     * @return A name for the launch template.
     */
    public String launchTemplateName() {
        return launchTemplateName;
    }

    /**
     * <p>
     * A description for the first version of the launch template.
     * </p>
     * 
     * @return A description for the first version of the launch template.
     */
    public String versionDescription() {
        return versionDescription;
    }

    /**
     * <p>
     * The information for the launch template.
     * </p>
     * 
     * @return The information for the launch template.
     */
    public RequestLaunchTemplateData launchTemplateData() {
        return launchTemplateData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateData());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLaunchTemplateRequest)) {
            return false;
        }
        CreateLaunchTemplateRequest other = (CreateLaunchTemplateRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(launchTemplateName(), other.launchTemplateName())
                && Objects.equals(versionDescription(), other.versionDescription())
                && Objects.equals(launchTemplateData(), other.launchTemplateData());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateLaunchTemplateRequest").add("ClientToken", clientToken())
                .add("LaunchTemplateName", launchTemplateName()).add("VersionDescription", versionDescription())
                .add("LaunchTemplateData", launchTemplateData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "LaunchTemplateName":
            return Optional.ofNullable(clazz.cast(launchTemplateName()));
        case "VersionDescription":
            return Optional.ofNullable(clazz.cast(versionDescription()));
        case "LaunchTemplateData":
            return Optional.ofNullable(clazz.cast(launchTemplateData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLaunchTemplateRequest, T> g) {
        return obj -> g.apply((CreateLaunchTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateLaunchTemplateRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information,
         * see <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A name for the launch template.
         * </p>
         * 
         * @param launchTemplateName
         *        A name for the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateName(String launchTemplateName);

        /**
         * <p>
         * A description for the first version of the launch template.
         * </p>
         * 
         * @param versionDescription
         *        A description for the first version of the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionDescription(String versionDescription);

        /**
         * <p>
         * The information for the launch template.
         * </p>
         * 
         * @param launchTemplateData
         *        The information for the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateData(RequestLaunchTemplateData launchTemplateData);

        /**
         * <p>
         * The information for the launch template.
         * </p>
         * This is a convenience that creates an instance of the {@link RequestLaunchTemplateData.Builder} avoiding the
         * need to create one manually via {@link RequestLaunchTemplateData#builder()}.
         *
         * When the {@link Consumer} completes, {@link RequestLaunchTemplateData.Builder#build()} is called immediately
         * and its result is passed to {@link #launchTemplateData(RequestLaunchTemplateData)}.
         * 
         * @param launchTemplateData
         *        a consumer that will call methods on {@link RequestLaunchTemplateData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplateData(RequestLaunchTemplateData)
         */
        default Builder launchTemplateData(Consumer<RequestLaunchTemplateData.Builder> launchTemplateData) {
            return launchTemplateData(RequestLaunchTemplateData.builder().applyMutation(launchTemplateData).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String clientToken;

        private String launchTemplateName;

        private String versionDescription;

        private RequestLaunchTemplateData launchTemplateData;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLaunchTemplateRequest model) {
            super(model);
            clientToken(model.clientToken);
            launchTemplateName(model.launchTemplateName);
            versionDescription(model.versionDescription);
            launchTemplateData(model.launchTemplateData);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getLaunchTemplateName() {
            return launchTemplateName;
        }

        @Override
        public final Builder launchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
            return this;
        }

        public final void setLaunchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
        }

        public final String getVersionDescription() {
            return versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        public final RequestLaunchTemplateData.Builder getLaunchTemplateData() {
            return launchTemplateData != null ? launchTemplateData.toBuilder() : null;
        }

        @Override
        public final Builder launchTemplateData(RequestLaunchTemplateData launchTemplateData) {
            this.launchTemplateData = launchTemplateData;
            return this;
        }

        public final void setLaunchTemplateData(RequestLaunchTemplateData.BuilderImpl launchTemplateData) {
            this.launchTemplateData = launchTemplateData != null ? launchTemplateData.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLaunchTemplateRequest build() {
            return new CreateLaunchTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
