/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLaunchTemplateVersionResponse extends Ec2Response implements
        ToCopyableBuilder<CreateLaunchTemplateVersionResponse.Builder, CreateLaunchTemplateVersionResponse> {
    private static final SdkField<LaunchTemplateVersion> LAUNCH_TEMPLATE_VERSION_FIELD = SdkField
            .<LaunchTemplateVersion> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateLaunchTemplateVersionResponse::launchTemplateVersion))
            .setter(setter(Builder::launchTemplateVersion))
            .constructor(LaunchTemplateVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateVersion")
                    .unmarshallLocationName("launchTemplateVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_VERSION_FIELD));

    private final LaunchTemplateVersion launchTemplateVersion;

    private CreateLaunchTemplateVersionResponse(BuilderImpl builder) {
        super(builder);
        this.launchTemplateVersion = builder.launchTemplateVersion;
    }

    /**
     * <p>
     * Information about the launch template version.
     * </p>
     * 
     * @return Information about the launch template version.
     */
    public LaunchTemplateVersion launchTemplateVersion() {
        return launchTemplateVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLaunchTemplateVersionResponse)) {
            return false;
        }
        CreateLaunchTemplateVersionResponse other = (CreateLaunchTemplateVersionResponse) obj;
        return Objects.equals(launchTemplateVersion(), other.launchTemplateVersion());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateLaunchTemplateVersionResponse").add("LaunchTemplateVersion", launchTemplateVersion())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchTemplateVersion":
            return Optional.ofNullable(clazz.cast(launchTemplateVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLaunchTemplateVersionResponse, T> g) {
        return obj -> g.apply((CreateLaunchTemplateVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateLaunchTemplateVersionResponse> {
        /**
         * <p>
         * Information about the launch template version.
         * </p>
         * 
         * @param launchTemplateVersion
         *        Information about the launch template version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateVersion(LaunchTemplateVersion launchTemplateVersion);

        /**
         * <p>
         * Information about the launch template version.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchTemplateVersion.Builder} avoiding the need
         * to create one manually via {@link LaunchTemplateVersion#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchTemplateVersion.Builder#build()} is called immediately and
         * its result is passed to {@link #launchTemplateVersion(LaunchTemplateVersion)}.
         * 
         * @param launchTemplateVersion
         *        a consumer that will call methods on {@link LaunchTemplateVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplateVersion(LaunchTemplateVersion)
         */
        default Builder launchTemplateVersion(Consumer<LaunchTemplateVersion.Builder> launchTemplateVersion) {
            return launchTemplateVersion(LaunchTemplateVersion.builder().applyMutation(launchTemplateVersion).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private LaunchTemplateVersion launchTemplateVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLaunchTemplateVersionResponse model) {
            super(model);
            launchTemplateVersion(model.launchTemplateVersion);
        }

        public final LaunchTemplateVersion.Builder getLaunchTemplateVersion() {
            return launchTemplateVersion != null ? launchTemplateVersion.toBuilder() : null;
        }

        @Override
        public final Builder launchTemplateVersion(LaunchTemplateVersion launchTemplateVersion) {
            this.launchTemplateVersion = launchTemplateVersion;
            return this;
        }

        public final void setLaunchTemplateVersion(LaunchTemplateVersion.BuilderImpl launchTemplateVersion) {
            this.launchTemplateVersion = launchTemplateVersion != null ? launchTemplateVersion.build() : null;
        }

        @Override
        public CreateLaunchTemplateVersionResponse build() {
            return new CreateLaunchTemplateVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
