/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateNetworkInterface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNetworkInterfaceResponse extends Ec2Response implements
        ToCopyableBuilder<CreateNetworkInterfaceResponse.Builder, CreateNetworkInterfaceResponse> {
    private static final SdkField<NetworkInterface> NETWORK_INTERFACE_FIELD = SdkField
            .<NetworkInterface> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateNetworkInterfaceResponse::networkInterface))
            .setter(setter(Builder::networkInterface))
            .constructor(NetworkInterface::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterface")
                    .unmarshallLocationName("networkInterface").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_FIELD));

    private final NetworkInterface networkInterface;

    private CreateNetworkInterfaceResponse(BuilderImpl builder) {
        super(builder);
        this.networkInterface = builder.networkInterface;
    }

    /**
     * <p>
     * Information about the network interface.
     * </p>
     * 
     * @return Information about the network interface.
     */
    public NetworkInterface networkInterface() {
        return networkInterface;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkInterface());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkInterfaceResponse)) {
            return false;
        }
        CreateNetworkInterfaceResponse other = (CreateNetworkInterfaceResponse) obj;
        return Objects.equals(networkInterface(), other.networkInterface());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateNetworkInterfaceResponse").add("NetworkInterface", networkInterface()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInterface":
            return Optional.ofNullable(clazz.cast(networkInterface()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNetworkInterfaceResponse, T> g) {
        return obj -> g.apply((CreateNetworkInterfaceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateNetworkInterfaceResponse> {
        /**
         * <p>
         * Information about the network interface.
         * </p>
         * 
         * @param networkInterface
         *        Information about the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterface(NetworkInterface networkInterface);

        /**
         * <p>
         * Information about the network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkInterface.Builder} avoiding the need to
         * create one manually via {@link NetworkInterface#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkInterface.Builder#build()} is called immediately and its
         * result is passed to {@link #networkInterface(NetworkInterface)}.
         * 
         * @param networkInterface
         *        a consumer that will call methods on {@link NetworkInterface.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInterface(NetworkInterface)
         */
        default Builder networkInterface(Consumer<NetworkInterface.Builder> networkInterface) {
            return networkInterface(NetworkInterface.builder().applyMutation(networkInterface).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private NetworkInterface networkInterface;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkInterfaceResponse model) {
            super(model);
            networkInterface(model.networkInterface);
        }

        public final NetworkInterface.Builder getNetworkInterface() {
            return networkInterface != null ? networkInterface.toBuilder() : null;
        }

        @Override
        public final Builder networkInterface(NetworkInterface networkInterface) {
            this.networkInterface = networkInterface;
            return this;
        }

        public final void setNetworkInterface(NetworkInterface.BuilderImpl networkInterface) {
            this.networkInterface = networkInterface != null ? networkInterface.build() : null;
        }

        @Override
        public CreateNetworkInterfaceResponse build() {
            return new CreateNetworkInterfaceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
