/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTransitGatewayRouteTableResponse extends Ec2Response implements
        ToCopyableBuilder<CreateTransitGatewayRouteTableResponse.Builder, CreateTransitGatewayRouteTableResponse> {
    private static final SdkField<TransitGatewayRouteTable> TRANSIT_GATEWAY_ROUTE_TABLE_FIELD = SdkField
            .<TransitGatewayRouteTable> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateTransitGatewayRouteTableResponse::transitGatewayRouteTable))
            .setter(setter(Builder::transitGatewayRouteTable))
            .constructor(TransitGatewayRouteTable::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTable")
                    .unmarshallLocationName("transitGatewayRouteTable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TRANSIT_GATEWAY_ROUTE_TABLE_FIELD));

    private final TransitGatewayRouteTable transitGatewayRouteTable;

    private CreateTransitGatewayRouteTableResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayRouteTable = builder.transitGatewayRouteTable;
    }

    /**
     * <p>
     * Information about the transit gateway route table.
     * </p>
     * 
     * @return Information about the transit gateway route table.
     */
    public TransitGatewayRouteTable transitGatewayRouteTable() {
        return transitGatewayRouteTable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayRouteTable());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransitGatewayRouteTableResponse)) {
            return false;
        }
        CreateTransitGatewayRouteTableResponse other = (CreateTransitGatewayRouteTableResponse) obj;
        return Objects.equals(transitGatewayRouteTable(), other.transitGatewayRouteTable());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateTransitGatewayRouteTableResponse")
                .add("TransitGatewayRouteTable", transitGatewayRouteTable()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayRouteTable":
            return Optional.ofNullable(clazz.cast(transitGatewayRouteTable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTransitGatewayRouteTableResponse, T> g) {
        return obj -> g.apply((CreateTransitGatewayRouteTableResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateTransitGatewayRouteTableResponse> {
        /**
         * <p>
         * Information about the transit gateway route table.
         * </p>
         * 
         * @param transitGatewayRouteTable
         *        Information about the transit gateway route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayRouteTable(TransitGatewayRouteTable transitGatewayRouteTable);

        /**
         * <p>
         * Information about the transit gateway route table.
         * </p>
         * This is a convenience that creates an instance of the {@link TransitGatewayRouteTable.Builder} avoiding the
         * need to create one manually via {@link TransitGatewayRouteTable#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransitGatewayRouteTable.Builder#build()} is called immediately
         * and its result is passed to {@link #transitGatewayRouteTable(TransitGatewayRouteTable)}.
         * 
         * @param transitGatewayRouteTable
         *        a consumer that will call methods on {@link TransitGatewayRouteTable.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitGatewayRouteTable(TransitGatewayRouteTable)
         */
        default Builder transitGatewayRouteTable(Consumer<TransitGatewayRouteTable.Builder> transitGatewayRouteTable) {
            return transitGatewayRouteTable(TransitGatewayRouteTable.builder().applyMutation(transitGatewayRouteTable).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private TransitGatewayRouteTable transitGatewayRouteTable;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransitGatewayRouteTableResponse model) {
            super(model);
            transitGatewayRouteTable(model.transitGatewayRouteTable);
        }

        public final TransitGatewayRouteTable.Builder getTransitGatewayRouteTable() {
            return transitGatewayRouteTable != null ? transitGatewayRouteTable.toBuilder() : null;
        }

        @Override
        public final Builder transitGatewayRouteTable(TransitGatewayRouteTable transitGatewayRouteTable) {
            this.transitGatewayRouteTable = transitGatewayRouteTable;
            return this;
        }

        public final void setTransitGatewayRouteTable(TransitGatewayRouteTable.BuilderImpl transitGatewayRouteTable) {
            this.transitGatewayRouteTable = transitGatewayRouteTable != null ? transitGatewayRouteTable.build() : null;
        }

        @Override
        public CreateTransitGatewayRouteTableResponse build() {
            return new CreateTransitGatewayRouteTableResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
