/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateVpnConnection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpnConnectionRequest extends Ec2Request implements
        ToCopyableBuilder<CreateVpnConnectionRequest.Builder, CreateVpnConnectionRequest> {
    private static final SdkField<String> CUSTOMER_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateVpnConnectionRequest::customerGatewayId))
            .setter(setter(Builder::customerGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerGatewayId")
                    .unmarshallLocationName("CustomerGatewayId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateVpnConnectionRequest::type))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("Type").build()).build();

    private static final SdkField<String> VPN_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateVpnConnectionRequest::vpnGatewayId))
            .setter(setter(Builder::vpnGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnGatewayId")
                    .unmarshallLocationName("VpnGatewayId").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateVpnConnectionRequest::transitGatewayId))
            .setter(setter(Builder::transitGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId")
                    .unmarshallLocationName("TransitGatewayId").build()).build();

    private static final SdkField<VpnConnectionOptionsSpecification> OPTIONS_FIELD = SdkField
            .<VpnConnectionOptionsSpecification> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateVpnConnectionRequest::options))
            .setter(setter(Builder::options))
            .constructor(VpnConnectionOptionsSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options")
                    .unmarshallLocationName("options").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_GATEWAY_ID_FIELD,
            TYPE_FIELD, VPN_GATEWAY_ID_FIELD, TRANSIT_GATEWAY_ID_FIELD, OPTIONS_FIELD));

    private final String customerGatewayId;

    private final String type;

    private final String vpnGatewayId;

    private final String transitGatewayId;

    private final VpnConnectionOptionsSpecification options;

    private CreateVpnConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.customerGatewayId = builder.customerGatewayId;
        this.type = builder.type;
        this.vpnGatewayId = builder.vpnGatewayId;
        this.transitGatewayId = builder.transitGatewayId;
        this.options = builder.options;
    }

    /**
     * <p>
     * The ID of the customer gateway.
     * </p>
     * 
     * @return The ID of the customer gateway.
     */
    public String customerGatewayId() {
        return customerGatewayId;
    }

    /**
     * <p>
     * The type of VPN connection (<code>ipsec.1</code>).
     * </p>
     * 
     * @return The type of VPN connection (<code>ipsec.1</code>).
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * The ID of the virtual private gateway. If you specify a virtual private gateway, you cannot specify a transit
     * gateway.
     * </p>
     * 
     * @return The ID of the virtual private gateway. If you specify a virtual private gateway, you cannot specify a
     *         transit gateway.
     */
    public String vpnGatewayId() {
        return vpnGatewayId;
    }

    /**
     * <p>
     * The ID of the transit gateway. If you specify a transit gateway, you cannot specify a virtual private gateway.
     * </p>
     * 
     * @return The ID of the transit gateway. If you specify a transit gateway, you cannot specify a virtual private
     *         gateway.
     */
    public String transitGatewayId() {
        return transitGatewayId;
    }

    /**
     * <p>
     * The options for the VPN connection.
     * </p>
     * 
     * @return The options for the VPN connection.
     */
    public VpnConnectionOptionsSpecification options() {
        return options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customerGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(vpnGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(options());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpnConnectionRequest)) {
            return false;
        }
        CreateVpnConnectionRequest other = (CreateVpnConnectionRequest) obj;
        return Objects.equals(customerGatewayId(), other.customerGatewayId()) && Objects.equals(type(), other.type())
                && Objects.equals(vpnGatewayId(), other.vpnGatewayId())
                && Objects.equals(transitGatewayId(), other.transitGatewayId()) && Objects.equals(options(), other.options());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateVpnConnectionRequest").add("CustomerGatewayId", customerGatewayId()).add("Type", type())
                .add("VpnGatewayId", vpnGatewayId()).add("TransitGatewayId", transitGatewayId()).add("Options", options())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomerGatewayId":
            return Optional.ofNullable(clazz.cast(customerGatewayId()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "VpnGatewayId":
            return Optional.ofNullable(clazz.cast(vpnGatewayId()));
        case "TransitGatewayId":
            return Optional.ofNullable(clazz.cast(transitGatewayId()));
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpnConnectionRequest, T> g) {
        return obj -> g.apply((CreateVpnConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateVpnConnectionRequest> {
        /**
         * <p>
         * The ID of the customer gateway.
         * </p>
         * 
         * @param customerGatewayId
         *        The ID of the customer gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerGatewayId(String customerGatewayId);

        /**
         * <p>
         * The type of VPN connection (<code>ipsec.1</code>).
         * </p>
         * 
         * @param type
         *        The type of VPN connection (<code>ipsec.1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The ID of the virtual private gateway. If you specify a virtual private gateway, you cannot specify a transit
         * gateway.
         * </p>
         * 
         * @param vpnGatewayId
         *        The ID of the virtual private gateway. If you specify a virtual private gateway, you cannot specify a
         *        transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnGatewayId(String vpnGatewayId);

        /**
         * <p>
         * The ID of the transit gateway. If you specify a transit gateway, you cannot specify a virtual private
         * gateway.
         * </p>
         * 
         * @param transitGatewayId
         *        The ID of the transit gateway. If you specify a transit gateway, you cannot specify a virtual private
         *        gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayId(String transitGatewayId);

        /**
         * <p>
         * The options for the VPN connection.
         * </p>
         * 
         * @param options
         *        The options for the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(VpnConnectionOptionsSpecification options);

        /**
         * <p>
         * The options for the VPN connection.
         * </p>
         * This is a convenience that creates an instance of the {@link VpnConnectionOptionsSpecification.Builder}
         * avoiding the need to create one manually via {@link VpnConnectionOptionsSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpnConnectionOptionsSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #options(VpnConnectionOptionsSpecification)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link VpnConnectionOptionsSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(VpnConnectionOptionsSpecification)
         */
        default Builder options(Consumer<VpnConnectionOptionsSpecification.Builder> options) {
            return options(VpnConnectionOptionsSpecification.builder().applyMutation(options).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String customerGatewayId;

        private String type;

        private String vpnGatewayId;

        private String transitGatewayId;

        private VpnConnectionOptionsSpecification options;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpnConnectionRequest model) {
            super(model);
            customerGatewayId(model.customerGatewayId);
            type(model.type);
            vpnGatewayId(model.vpnGatewayId);
            transitGatewayId(model.transitGatewayId);
            options(model.options);
        }

        public final String getCustomerGatewayId() {
            return customerGatewayId;
        }

        @Override
        public final Builder customerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
            return this;
        }

        public final void setCustomerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getVpnGatewayId() {
            return vpnGatewayId;
        }

        @Override
        public final Builder vpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        public final void setVpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
        }

        public final String getTransitGatewayId() {
            return transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        public final VpnConnectionOptionsSpecification.Builder getOptions() {
            return options != null ? options.toBuilder() : null;
        }

        @Override
        public final Builder options(VpnConnectionOptionsSpecification options) {
            this.options = options;
            return this;
        }

        public final void setOptions(VpnConnectionOptionsSpecification.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpnConnectionRequest build() {
            return new CreateVpnConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
