/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteLaunchTemplateVersionsResponse extends Ec2Response implements
        ToCopyableBuilder<DeleteLaunchTemplateVersionsResponse.Builder, DeleteLaunchTemplateVersionsResponse> {
    private static final SdkField<List<DeleteLaunchTemplateVersionsResponseSuccessItem>> SUCCESSFULLY_DELETED_LAUNCH_TEMPLATE_VERSIONS_FIELD = SdkField
            .<List<DeleteLaunchTemplateVersionsResponseSuccessItem>> builder(MarshallingType.LIST)
            .getter(getter(DeleteLaunchTemplateVersionsResponse::successfullyDeletedLaunchTemplateVersions))
            .setter(setter(Builder::successfullyDeletedLaunchTemplateVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SuccessfullyDeletedLaunchTemplateVersionSet")
                    .unmarshallLocationName("successfullyDeletedLaunchTemplateVersionSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<DeleteLaunchTemplateVersionsResponseSuccessItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeleteLaunchTemplateVersionsResponseSuccessItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<DeleteLaunchTemplateVersionsResponseErrorItem>> UNSUCCESSFULLY_DELETED_LAUNCH_TEMPLATE_VERSIONS_FIELD = SdkField
            .<List<DeleteLaunchTemplateVersionsResponseErrorItem>> builder(MarshallingType.LIST)
            .getter(getter(DeleteLaunchTemplateVersionsResponse::unsuccessfullyDeletedLaunchTemplateVersions))
            .setter(setter(Builder::unsuccessfullyDeletedLaunchTemplateVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("UnsuccessfullyDeletedLaunchTemplateVersionSet")
                    .unmarshallLocationName("unsuccessfullyDeletedLaunchTemplateVersionSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<DeleteLaunchTemplateVersionsResponseErrorItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeleteLaunchTemplateVersionsResponseErrorItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SUCCESSFULLY_DELETED_LAUNCH_TEMPLATE_VERSIONS_FIELD, UNSUCCESSFULLY_DELETED_LAUNCH_TEMPLATE_VERSIONS_FIELD));

    private final List<DeleteLaunchTemplateVersionsResponseSuccessItem> successfullyDeletedLaunchTemplateVersions;

    private final List<DeleteLaunchTemplateVersionsResponseErrorItem> unsuccessfullyDeletedLaunchTemplateVersions;

    private DeleteLaunchTemplateVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.successfullyDeletedLaunchTemplateVersions = builder.successfullyDeletedLaunchTemplateVersions;
        this.unsuccessfullyDeletedLaunchTemplateVersions = builder.unsuccessfullyDeletedLaunchTemplateVersions;
    }

    /**
     * <p>
     * Information about the launch template versions that were successfully deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the launch template versions that were successfully deleted.
     */
    public List<DeleteLaunchTemplateVersionsResponseSuccessItem> successfullyDeletedLaunchTemplateVersions() {
        return successfullyDeletedLaunchTemplateVersions;
    }

    /**
     * <p>
     * Information about the launch template versions that could not be deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the launch template versions that could not be deleted.
     */
    public List<DeleteLaunchTemplateVersionsResponseErrorItem> unsuccessfullyDeletedLaunchTemplateVersions() {
        return unsuccessfullyDeletedLaunchTemplateVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(successfullyDeletedLaunchTemplateVersions());
        hashCode = 31 * hashCode + Objects.hashCode(unsuccessfullyDeletedLaunchTemplateVersions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLaunchTemplateVersionsResponse)) {
            return false;
        }
        DeleteLaunchTemplateVersionsResponse other = (DeleteLaunchTemplateVersionsResponse) obj;
        return Objects.equals(successfullyDeletedLaunchTemplateVersions(), other.successfullyDeletedLaunchTemplateVersions())
                && Objects.equals(unsuccessfullyDeletedLaunchTemplateVersions(),
                        other.unsuccessfullyDeletedLaunchTemplateVersions());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteLaunchTemplateVersionsResponse")
                .add("SuccessfullyDeletedLaunchTemplateVersions", successfullyDeletedLaunchTemplateVersions())
                .add("UnsuccessfullyDeletedLaunchTemplateVersions", unsuccessfullyDeletedLaunchTemplateVersions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuccessfullyDeletedLaunchTemplateVersions":
            return Optional.ofNullable(clazz.cast(successfullyDeletedLaunchTemplateVersions()));
        case "UnsuccessfullyDeletedLaunchTemplateVersions":
            return Optional.ofNullable(clazz.cast(unsuccessfullyDeletedLaunchTemplateVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteLaunchTemplateVersionsResponse, T> g) {
        return obj -> g.apply((DeleteLaunchTemplateVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DeleteLaunchTemplateVersionsResponse> {
        /**
         * <p>
         * Information about the launch template versions that were successfully deleted.
         * </p>
         * 
         * @param successfullyDeletedLaunchTemplateVersions
         *        Information about the launch template versions that were successfully deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfullyDeletedLaunchTemplateVersions(
                Collection<DeleteLaunchTemplateVersionsResponseSuccessItem> successfullyDeletedLaunchTemplateVersions);

        /**
         * <p>
         * Information about the launch template versions that were successfully deleted.
         * </p>
         * 
         * @param successfullyDeletedLaunchTemplateVersions
         *        Information about the launch template versions that were successfully deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successfullyDeletedLaunchTemplateVersions(
                DeleteLaunchTemplateVersionsResponseSuccessItem... successfullyDeletedLaunchTemplateVersions);

        /**
         * <p>
         * Information about the launch template versions that were successfully deleted.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <DeleteLaunchTemplateVersionsResponseSuccessItem>.Builder} avoiding the need to create one manually via
         * {@link List<DeleteLaunchTemplateVersionsResponseSuccessItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <DeleteLaunchTemplateVersionsResponseSuccessItem>.Builder#build()} is called immediately and its result is
         * passed to {@link
         * #successfullyDeletedLaunchTemplateVersions(List<DeleteLaunchTemplateVersionsResponseSuccessItem>)}.
         * 
         * @param successfullyDeletedLaunchTemplateVersions
         *        a consumer that will call methods on {@link List
         *        <DeleteLaunchTemplateVersionsResponseSuccessItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successfullyDeletedLaunchTemplateVersions(List<DeleteLaunchTemplateVersionsResponseSuccessItem>)
         */
        Builder successfullyDeletedLaunchTemplateVersions(
                Consumer<DeleteLaunchTemplateVersionsResponseSuccessItem.Builder>... successfullyDeletedLaunchTemplateVersions);

        /**
         * <p>
         * Information about the launch template versions that could not be deleted.
         * </p>
         * 
         * @param unsuccessfullyDeletedLaunchTemplateVersions
         *        Information about the launch template versions that could not be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessfullyDeletedLaunchTemplateVersions(
                Collection<DeleteLaunchTemplateVersionsResponseErrorItem> unsuccessfullyDeletedLaunchTemplateVersions);

        /**
         * <p>
         * Information about the launch template versions that could not be deleted.
         * </p>
         * 
         * @param unsuccessfullyDeletedLaunchTemplateVersions
         *        Information about the launch template versions that could not be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessfullyDeletedLaunchTemplateVersions(
                DeleteLaunchTemplateVersionsResponseErrorItem... unsuccessfullyDeletedLaunchTemplateVersions);

        /**
         * <p>
         * Information about the launch template versions that could not be deleted.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <DeleteLaunchTemplateVersionsResponseErrorItem>.Builder} avoiding the need to create one manually via
         * {@link List<DeleteLaunchTemplateVersionsResponseErrorItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <DeleteLaunchTemplateVersionsResponseErrorItem>.Builder#build()} is called immediately and its result is
         * passed to {@link
         * #unsuccessfullyDeletedLaunchTemplateVersions(List<DeleteLaunchTemplateVersionsResponseErrorItem>)}.
         * 
         * @param unsuccessfullyDeletedLaunchTemplateVersions
         *        a consumer that will call methods on {@link List
         *        <DeleteLaunchTemplateVersionsResponseErrorItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unsuccessfullyDeletedLaunchTemplateVersions(List<DeleteLaunchTemplateVersionsResponseErrorItem>)
         */
        Builder unsuccessfullyDeletedLaunchTemplateVersions(
                Consumer<DeleteLaunchTemplateVersionsResponseErrorItem.Builder>... unsuccessfullyDeletedLaunchTemplateVersions);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<DeleteLaunchTemplateVersionsResponseSuccessItem> successfullyDeletedLaunchTemplateVersions = DefaultSdkAutoConstructList
                .getInstance();

        private List<DeleteLaunchTemplateVersionsResponseErrorItem> unsuccessfullyDeletedLaunchTemplateVersions = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLaunchTemplateVersionsResponse model) {
            super(model);
            successfullyDeletedLaunchTemplateVersions(model.successfullyDeletedLaunchTemplateVersions);
            unsuccessfullyDeletedLaunchTemplateVersions(model.unsuccessfullyDeletedLaunchTemplateVersions);
        }

        public final Collection<DeleteLaunchTemplateVersionsResponseSuccessItem.Builder> getSuccessfullyDeletedLaunchTemplateVersions() {
            return successfullyDeletedLaunchTemplateVersions != null ? successfullyDeletedLaunchTemplateVersions.stream()
                    .map(DeleteLaunchTemplateVersionsResponseSuccessItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder successfullyDeletedLaunchTemplateVersions(
                Collection<DeleteLaunchTemplateVersionsResponseSuccessItem> successfullyDeletedLaunchTemplateVersions) {
            this.successfullyDeletedLaunchTemplateVersions = DeleteLaunchTemplateVersionsResponseSuccessSetCopier
                    .copy(successfullyDeletedLaunchTemplateVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfullyDeletedLaunchTemplateVersions(
                DeleteLaunchTemplateVersionsResponseSuccessItem... successfullyDeletedLaunchTemplateVersions) {
            successfullyDeletedLaunchTemplateVersions(Arrays.asList(successfullyDeletedLaunchTemplateVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfullyDeletedLaunchTemplateVersions(
                Consumer<DeleteLaunchTemplateVersionsResponseSuccessItem.Builder>... successfullyDeletedLaunchTemplateVersions) {
            successfullyDeletedLaunchTemplateVersions(Stream.of(successfullyDeletedLaunchTemplateVersions)
                    .map(c -> DeleteLaunchTemplateVersionsResponseSuccessItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSuccessfullyDeletedLaunchTemplateVersions(
                Collection<DeleteLaunchTemplateVersionsResponseSuccessItem.BuilderImpl> successfullyDeletedLaunchTemplateVersions) {
            this.successfullyDeletedLaunchTemplateVersions = DeleteLaunchTemplateVersionsResponseSuccessSetCopier
                    .copyFromBuilder(successfullyDeletedLaunchTemplateVersions);
        }

        public final Collection<DeleteLaunchTemplateVersionsResponseErrorItem.Builder> getUnsuccessfullyDeletedLaunchTemplateVersions() {
            return unsuccessfullyDeletedLaunchTemplateVersions != null ? unsuccessfullyDeletedLaunchTemplateVersions.stream()
                    .map(DeleteLaunchTemplateVersionsResponseErrorItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unsuccessfullyDeletedLaunchTemplateVersions(
                Collection<DeleteLaunchTemplateVersionsResponseErrorItem> unsuccessfullyDeletedLaunchTemplateVersions) {
            this.unsuccessfullyDeletedLaunchTemplateVersions = DeleteLaunchTemplateVersionsResponseErrorSetCopier
                    .copy(unsuccessfullyDeletedLaunchTemplateVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfullyDeletedLaunchTemplateVersions(
                DeleteLaunchTemplateVersionsResponseErrorItem... unsuccessfullyDeletedLaunchTemplateVersions) {
            unsuccessfullyDeletedLaunchTemplateVersions(Arrays.asList(unsuccessfullyDeletedLaunchTemplateVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfullyDeletedLaunchTemplateVersions(
                Consumer<DeleteLaunchTemplateVersionsResponseErrorItem.Builder>... unsuccessfullyDeletedLaunchTemplateVersions) {
            unsuccessfullyDeletedLaunchTemplateVersions(Stream.of(unsuccessfullyDeletedLaunchTemplateVersions)
                    .map(c -> DeleteLaunchTemplateVersionsResponseErrorItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUnsuccessfullyDeletedLaunchTemplateVersions(
                Collection<DeleteLaunchTemplateVersionsResponseErrorItem.BuilderImpl> unsuccessfullyDeletedLaunchTemplateVersions) {
            this.unsuccessfullyDeletedLaunchTemplateVersions = DeleteLaunchTemplateVersionsResponseErrorSetCopier
                    .copyFromBuilder(unsuccessfullyDeletedLaunchTemplateVersions);
        }

        @Override
        public DeleteLaunchTemplateVersionsResponse build() {
            return new DeleteLaunchTemplateVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
