/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteVpcEndpointServiceConfigurationsRequest extends Ec2Request implements
        ToCopyableBuilder<DeleteVpcEndpointServiceConfigurationsRequest.Builder, DeleteVpcEndpointServiceConfigurationsRequest> {
    private static final SdkField<List<String>> SERVICE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DeleteVpcEndpointServiceConfigurationsRequest::serviceIds))
            .setter(setter(Builder::serviceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId")
                    .unmarshallLocationName("ServiceId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_IDS_FIELD));

    private final List<String> serviceIds;

    private DeleteVpcEndpointServiceConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.serviceIds = builder.serviceIds;
    }

    /**
     * <p>
     * The IDs of one or more services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of one or more services.
     */
    public List<String> serviceIds() {
        return serviceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVpcEndpointServiceConfigurationsRequest)) {
            return false;
        }
        DeleteVpcEndpointServiceConfigurationsRequest other = (DeleteVpcEndpointServiceConfigurationsRequest) obj;
        return Objects.equals(serviceIds(), other.serviceIds());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteVpcEndpointServiceConfigurationsRequest").add("ServiceIds", serviceIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceIds":
            return Optional.ofNullable(clazz.cast(serviceIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteVpcEndpointServiceConfigurationsRequest, T> g) {
        return obj -> g.apply((DeleteVpcEndpointServiceConfigurationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteVpcEndpointServiceConfigurationsRequest> {
        /**
         * <p>
         * The IDs of one or more services.
         * </p>
         * 
         * @param serviceIds
         *        The IDs of one or more services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceIds(Collection<String> serviceIds);

        /**
         * <p>
         * The IDs of one or more services.
         * </p>
         * 
         * @param serviceIds
         *        The IDs of one or more services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceIds(String... serviceIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<String> serviceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVpcEndpointServiceConfigurationsRequest model) {
            super(model);
            serviceIds(model.serviceIds);
        }

        public final Collection<String> getServiceIds() {
            return serviceIds;
        }

        @Override
        public final Builder serviceIds(Collection<String> serviceIds) {
            this.serviceIds = ValueStringListCopier.copy(serviceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceIds(String... serviceIds) {
            serviceIds(Arrays.asList(serviceIds));
            return this;
        }

        public final void setServiceIds(Collection<String> serviceIds) {
            this.serviceIds = ValueStringListCopier.copy(serviceIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteVpcEndpointServiceConfigurationsRequest build() {
            return new DeleteVpcEndpointServiceConfigurationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
