/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeByoipCidrsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeByoipCidrsResponse.Builder, DescribeByoipCidrsResponse> {
    private static final SdkField<List<ByoipCidr>> BYOIP_CIDRS_FIELD = SdkField
            .<List<ByoipCidr>> builder(MarshallingType.LIST)
            .getter(getter(DescribeByoipCidrsResponse::byoipCidrs))
            .setter(setter(Builder::byoipCidrs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ByoipCidrSet")
                    .unmarshallLocationName("byoipCidrSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ByoipCidr> builder(MarshallingType.SDK_POJO)
                                            .constructor(ByoipCidr::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeByoipCidrsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYOIP_CIDRS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ByoipCidr> byoipCidrs;

    private final String nextToken;

    private DescribeByoipCidrsResponse(BuilderImpl builder) {
        super(builder);
        this.byoipCidrs = builder.byoipCidrs;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about your address ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about your address ranges.
     */
    public List<ByoipCidr> byoipCidrs() {
        return byoipCidrs;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(byoipCidrs());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeByoipCidrsResponse)) {
            return false;
        }
        DescribeByoipCidrsResponse other = (DescribeByoipCidrsResponse) obj;
        return Objects.equals(byoipCidrs(), other.byoipCidrs()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeByoipCidrsResponse").add("ByoipCidrs", byoipCidrs()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ByoipCidrs":
            return Optional.ofNullable(clazz.cast(byoipCidrs()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeByoipCidrsResponse, T> g) {
        return obj -> g.apply((DescribeByoipCidrsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeByoipCidrsResponse> {
        /**
         * <p>
         * Information about your address ranges.
         * </p>
         * 
         * @param byoipCidrs
         *        Information about your address ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byoipCidrs(Collection<ByoipCidr> byoipCidrs);

        /**
         * <p>
         * Information about your address ranges.
         * </p>
         * 
         * @param byoipCidrs
         *        Information about your address ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byoipCidrs(ByoipCidr... byoipCidrs);

        /**
         * <p>
         * Information about your address ranges.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ByoipCidr>.Builder} avoiding the need to
         * create one manually via {@link List<ByoipCidr>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ByoipCidr>.Builder#build()} is called immediately and its
         * result is passed to {@link #byoipCidrs(List<ByoipCidr>)}.
         * 
         * @param byoipCidrs
         *        a consumer that will call methods on {@link List<ByoipCidr>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #byoipCidrs(List<ByoipCidr>)
         */
        Builder byoipCidrs(Consumer<ByoipCidr.Builder>... byoipCidrs);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<ByoipCidr> byoipCidrs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeByoipCidrsResponse model) {
            super(model);
            byoipCidrs(model.byoipCidrs);
            nextToken(model.nextToken);
        }

        public final Collection<ByoipCidr.Builder> getByoipCidrs() {
            return byoipCidrs != null ? byoipCidrs.stream().map(ByoipCidr::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder byoipCidrs(Collection<ByoipCidr> byoipCidrs) {
            this.byoipCidrs = ByoipCidrSetCopier.copy(byoipCidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder byoipCidrs(ByoipCidr... byoipCidrs) {
            byoipCidrs(Arrays.asList(byoipCidrs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder byoipCidrs(Consumer<ByoipCidr.Builder>... byoipCidrs) {
            byoipCidrs(Stream.of(byoipCidrs).map(c -> ByoipCidr.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setByoipCidrs(Collection<ByoipCidr.BuilderImpl> byoipCidrs) {
            this.byoipCidrs = ByoipCidrSetCopier.copyFromBuilder(byoipCidrs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeByoipCidrsResponse build() {
            return new DescribeByoipCidrsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
