/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output for DescribeExportTasks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeExportTasksResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeExportTasksResponse.Builder, DescribeExportTasksResponse> {
    private static final SdkField<List<ExportTask>> EXPORT_TASKS_FIELD = SdkField
            .<List<ExportTask>> builder(MarshallingType.LIST)
            .getter(getter(DescribeExportTasksResponse::exportTasks))
            .setter(setter(Builder::exportTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportTaskSet")
                    .unmarshallLocationName("exportTaskSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ExportTask> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExportTask::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_TASKS_FIELD));

    private final List<ExportTask> exportTasks;

    private DescribeExportTasksResponse(BuilderImpl builder) {
        super(builder);
        this.exportTasks = builder.exportTasks;
    }

    /**
     * <p>
     * Information about the export tasks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the export tasks.
     */
    public List<ExportTask> exportTasks() {
        return exportTasks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exportTasks());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExportTasksResponse)) {
            return false;
        }
        DescribeExportTasksResponse other = (DescribeExportTasksResponse) obj;
        return Objects.equals(exportTasks(), other.exportTasks());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeExportTasksResponse").add("ExportTasks", exportTasks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportTasks":
            return Optional.ofNullable(clazz.cast(exportTasks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeExportTasksResponse, T> g) {
        return obj -> g.apply((DescribeExportTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeExportTasksResponse> {
        /**
         * <p>
         * Information about the export tasks.
         * </p>
         * 
         * @param exportTasks
         *        Information about the export tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportTasks(Collection<ExportTask> exportTasks);

        /**
         * <p>
         * Information about the export tasks.
         * </p>
         * 
         * @param exportTasks
         *        Information about the export tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportTasks(ExportTask... exportTasks);

        /**
         * <p>
         * Information about the export tasks.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ExportTask>.Builder} avoiding the need to
         * create one manually via {@link List<ExportTask>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ExportTask>.Builder#build()} is called immediately and its
         * result is passed to {@link #exportTasks(List<ExportTask>)}.
         * 
         * @param exportTasks
         *        a consumer that will call methods on {@link List<ExportTask>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportTasks(List<ExportTask>)
         */
        Builder exportTasks(Consumer<ExportTask.Builder>... exportTasks);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<ExportTask> exportTasks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExportTasksResponse model) {
            super(model);
            exportTasks(model.exportTasks);
        }

        public final Collection<ExportTask.Builder> getExportTasks() {
            return exportTasks != null ? exportTasks.stream().map(ExportTask::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder exportTasks(Collection<ExportTask> exportTasks) {
            this.exportTasks = ExportTaskListCopier.copy(exportTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportTasks(ExportTask... exportTasks) {
            exportTasks(Arrays.asList(exportTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportTasks(Consumer<ExportTask.Builder>... exportTasks) {
            exportTasks(Stream.of(exportTasks).map(c -> ExportTask.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setExportTasks(Collection<ExportTask.BuilderImpl> exportTasks) {
            this.exportTasks = ExportTaskListCopier.copyFromBuilder(exportTasks);
        }

        @Override
        public DescribeExportTasksResponse build() {
            return new DescribeExportTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
