/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFlowLogsRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeFlowLogsRequest.Builder, DescribeFlowLogsRequest> {
    private static final SdkField<List<Filter>> FILTER_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeFlowLogsRequest::filter))
            .setter(setter(Builder::filter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> FLOW_LOG_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeFlowLogsRequest::flowLogIds))
            .setter(setter(Builder::flowLogIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowLogId")
                    .unmarshallLocationName("FlowLogId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeFlowLogsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeFlowLogsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD,
            FLOW_LOG_IDS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<Filter> filter;

    private final List<String> flowLogIds;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeFlowLogsRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.flowLogIds = builder.flowLogIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>deliver-log-status</code> - The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>log-destination-type</code> - The type of destination to which the flow log publishes data. Possible
     * destination types include <code>cloud-watch-logs</code> and <code>S3</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>flow-log-id</code> - The ID of the flow log.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>log-group-name</code> - The name of the log group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resource-id</code> - The ID of the VPC, subnet, or network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>traffic-type</code> - The type of traffic (<code>ACCEPT</code> | <code>REJECT</code> | <code>ALL</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>deliver-log-status</code> - The status of the logs delivery (<code>SUCCESS</code> |
     *         <code>FAILED</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>log-destination-type</code> - The type of destination to which the flow log publishes data.
     *         Possible destination types include <code>cloud-watch-logs</code> and <code>S3</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>flow-log-id</code> - The ID of the flow log.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>log-group-name</code> - The name of the log group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resource-id</code> - The ID of the VPC, subnet, or network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>traffic-type</code> - The type of traffic (<code>ACCEPT</code> | <code>REJECT</code> |
     *         <code>ALL</code>).
     *         </p>
     *         </li>
     */
    public List<Filter> filter() {
        return filter;
    }

    /**
     * <p>
     * One or more flow log IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more flow log IDs.
     */
    public List<String> flowLogIds() {
        return flowLogIds;
    }

    /**
     * <p>
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by
     * sending another request with the returned <code>NextToken</code> value. This value can be between 5 and 1000. If
     * <code>MaxResults</code> is given a value larger than 1000, only 1000 results are returned. You cannot specify
     * this parameter and the flow log IDs parameter in the same request.
     * </p>
     * 
     * @return The maximum number of results to return for the request in a single page. The remaining results can be
     *         seen by sending another request with the returned <code>NextToken</code> value. This value can be between
     *         5 and 1000. If <code>MaxResults</code> is given a value larger than 1000, only 1000 results are returned.
     *         You cannot specify this parameter and the flow log IDs parameter in the same request.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to retrieve the next page of results.
     * </p>
     * 
     * @return The token to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(flowLogIds());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFlowLogsRequest)) {
            return false;
        }
        DescribeFlowLogsRequest other = (DescribeFlowLogsRequest) obj;
        return Objects.equals(filter(), other.filter()) && Objects.equals(flowLogIds(), other.flowLogIds())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeFlowLogsRequest").add("Filter", filter()).add("FlowLogIds", flowLogIds())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "FlowLogIds":
            return Optional.ofNullable(clazz.cast(flowLogIds()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFlowLogsRequest, T> g) {
        return obj -> g.apply((DescribeFlowLogsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFlowLogsRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>deliver-log-status</code> - The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>
         * ).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>log-destination-type</code> - The type of destination to which the flow log publishes data. Possible
         * destination types include <code>cloud-watch-logs</code> and <code>S3</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>flow-log-id</code> - The ID of the flow log.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>log-group-name</code> - The name of the log group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resource-id</code> - The ID of the VPC, subnet, or network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>traffic-type</code> - The type of traffic (<code>ACCEPT</code> | <code>REJECT</code> | <code>ALL</code>
         * ).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filter
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>deliver-log-status</code> - The status of the logs delivery (<code>SUCCESS</code> |
         *        <code>FAILED</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>log-destination-type</code> - The type of destination to which the flow log publishes data.
         *        Possible destination types include <code>cloud-watch-logs</code> and <code>S3</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>flow-log-id</code> - The ID of the flow log.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>log-group-name</code> - The name of the log group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resource-id</code> - The ID of the VPC, subnet, or network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>traffic-type</code> - The type of traffic (<code>ACCEPT</code> | <code>REJECT</code> |
         *        <code>ALL</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Collection<Filter> filter);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>deliver-log-status</code> - The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>
         * ).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>log-destination-type</code> - The type of destination to which the flow log publishes data. Possible
         * destination types include <code>cloud-watch-logs</code> and <code>S3</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>flow-log-id</code> - The ID of the flow log.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>log-group-name</code> - The name of the log group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resource-id</code> - The ID of the VPC, subnet, or network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>traffic-type</code> - The type of traffic (<code>ACCEPT</code> | <code>REJECT</code> | <code>ALL</code>
         * ).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filter
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>deliver-log-status</code> - The status of the logs delivery (<code>SUCCESS</code> |
         *        <code>FAILED</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>log-destination-type</code> - The type of destination to which the flow log publishes data.
         *        Possible destination types include <code>cloud-watch-logs</code> and <code>S3</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>flow-log-id</code> - The ID of the flow log.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>log-group-name</code> - The name of the log group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resource-id</code> - The ID of the VPC, subnet, or network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>traffic-type</code> - The type of traffic (<code>ACCEPT</code> | <code>REJECT</code> |
         *        <code>ALL</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Filter... filter);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>deliver-log-status</code> - The status of the logs delivery (<code>SUCCESS</code> | <code>FAILED</code>
         * ).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>log-destination-type</code> - The type of destination to which the flow log publishes data. Possible
         * destination types include <code>cloud-watch-logs</code> and <code>S3</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>flow-log-id</code> - The ID of the flow log.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>log-group-name</code> - The name of the log group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resource-id</code> - The ID of the VPC, subnet, or network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>traffic-type</code> - The type of traffic (<code>ACCEPT</code> | <code>REJECT</code> | <code>ALL</code>
         * ).
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filter(List<Filter>)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(List<Filter>)
         */
        Builder filter(Consumer<Filter.Builder>... filter);

        /**
         * <p>
         * One or more flow log IDs.
         * </p>
         * 
         * @param flowLogIds
         *        One or more flow log IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowLogIds(Collection<String> flowLogIds);

        /**
         * <p>
         * One or more flow log IDs.
         * </p>
         * 
         * @param flowLogIds
         *        One or more flow log IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowLogIds(String... flowLogIds);

        /**
         * <p>
         * The maximum number of results to return for the request in a single page. The remaining results can be seen
         * by sending another request with the returned <code>NextToken</code> value. This value can be between 5 and
         * 1000. If <code>MaxResults</code> is given a value larger than 1000, only 1000 results are returned. You
         * cannot specify this parameter and the flow log IDs parameter in the same request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for the request in a single page. The remaining results can be
         *        seen by sending another request with the returned <code>NextToken</code> value. This value can be
         *        between 5 and 1000. If <code>MaxResults</code> is given a value larger than 1000, only 1000 results
         *        are returned. You cannot specify this parameter and the flow log IDs parameter in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<Filter> filter = DefaultSdkAutoConstructList.getInstance();

        private List<String> flowLogIds = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFlowLogsRequest model) {
            super(model);
            filter(model.filter);
            flowLogIds(model.flowLogIds);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<Filter.Builder> getFilter() {
            return filter != null ? filter.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filter(Collection<Filter> filter) {
            this.filter = FilterListCopier.copy(filter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filter(Filter... filter) {
            filter(Arrays.asList(filter));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filter(Consumer<Filter.Builder>... filter) {
            filter(Stream.of(filter).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilter(Collection<Filter.BuilderImpl> filter) {
            this.filter = FilterListCopier.copyFromBuilder(filter);
        }

        public final Collection<String> getFlowLogIds() {
            return flowLogIds;
        }

        @Override
        public final Builder flowLogIds(Collection<String> flowLogIds) {
            this.flowLogIds = ValueStringListCopier.copy(flowLogIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder flowLogIds(String... flowLogIds) {
            flowLogIds(Arrays.asList(flowLogIds));
            return this;
        }

        public final void setFlowLogIds(Collection<String> flowLogIds) {
            this.flowLogIds = ValueStringListCopier.copy(flowLogIds);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeFlowLogsRequest build() {
            return new DescribeFlowLogsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
