/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeHostsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeHostsResponse.Builder, DescribeHostsResponse> {
    private static final SdkField<List<Host>> HOSTS_FIELD = SdkField
            .<List<Host>> builder(MarshallingType.LIST)
            .getter(getter(DescribeHostsResponse::hosts))
            .setter(setter(Builder::hosts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostSet")
                    .unmarshallLocationName("hostSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Host> builder(MarshallingType.SDK_POJO)
                                            .constructor(Host::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeHostsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(HOSTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<Host> hosts;

    private final String nextToken;

    private DescribeHostsResponse(BuilderImpl builder) {
        super(builder);
        this.hosts = builder.hosts;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the Dedicated Hosts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the Dedicated Hosts.
     */
    public List<Host> hosts() {
        return hosts;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hosts());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostsResponse)) {
            return false;
        }
        DescribeHostsResponse other = (DescribeHostsResponse) obj;
        return Objects.equals(hosts(), other.hosts()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeHostsResponse").add("Hosts", hosts()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Hosts":
            return Optional.ofNullable(clazz.cast(hosts()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeHostsResponse, T> g) {
        return obj -> g.apply((DescribeHostsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeHostsResponse> {
        /**
         * <p>
         * Information about the Dedicated Hosts.
         * </p>
         * 
         * @param hosts
         *        Information about the Dedicated Hosts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hosts(Collection<Host> hosts);

        /**
         * <p>
         * Information about the Dedicated Hosts.
         * </p>
         * 
         * @param hosts
         *        Information about the Dedicated Hosts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hosts(Host... hosts);

        /**
         * <p>
         * Information about the Dedicated Hosts.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Host>.Builder} avoiding the need to create
         * one manually via {@link List<Host>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Host>.Builder#build()} is called immediately and its result
         * is passed to {@link #hosts(List<Host>)}.
         * 
         * @param hosts
         *        a consumer that will call methods on {@link List<Host>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hosts(List<Host>)
         */
        Builder hosts(Consumer<Host.Builder>... hosts);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<Host> hosts = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostsResponse model) {
            super(model);
            hosts(model.hosts);
            nextToken(model.nextToken);
        }

        public final Collection<Host.Builder> getHosts() {
            return hosts != null ? hosts.stream().map(Host::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hosts(Collection<Host> hosts) {
            this.hosts = HostListCopier.copy(hosts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hosts(Host... hosts) {
            hosts(Arrays.asList(hosts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hosts(Consumer<Host.Builder>... hosts) {
            hosts(Stream.of(hosts).map(c -> Host.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHosts(Collection<Host.BuilderImpl> hosts) {
            this.hosts = HostListCopier.copyFromBuilder(hosts);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeHostsResponse build() {
            return new DescribeHostsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
