/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeNetworkInterfaces.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeNetworkInterfacesRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeNetworkInterfacesRequest.Builder, DescribeNetworkInterfacesRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeNetworkInterfacesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> NETWORK_INTERFACE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeNetworkInterfacesRequest::networkInterfaceIds))
            .setter(setter(Builder::networkInterfaceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("NetworkInterfaceId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeNetworkInterfacesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeNetworkInterfacesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            NETWORK_INTERFACE_IDS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final List<Filter> filters;

    private final List<String> networkInterfaceIds;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeNetworkInterfacesRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.networkInterfaceIds = builder.networkInterfaceIds;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>addresses.private-ip-address</code> - The private IPv4 addresses associated with the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>addresses.primary</code> - Whether the private IPv4 address is the primary IP address associated with the
     * network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>addresses.association.public-ip</code> - The association ID returned when the network interface was
     * associated with the Elastic IP address (IPv4).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>addresses.association.owner-id</code> - The owner ID of the addresses associated with the network
     * interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>association.association-id</code> - The association ID returned when the network interface was associated
     * with an IPv4 address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP address
     * (IPv4) for your network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated with the network
     * interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>association.public-dns-name</code> - The public DNS name for the network interface (IPv4).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.attachment-id</code> - The ID of the interface attachment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.attach.time</code> - The time that the network interface was attached to an instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.delete-on-termination</code> - Indicates whether the attachment is deleted when an instance is
     * terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.device-index</code> - The device index to which the network interface is attached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.instance-id</code> - The ID of the instance to which the network interface is attached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.instance-owner-id</code> - The owner ID of the instance to which the network interface is
     * attached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.nat-gateway-id</code> - The ID of the NAT gateway to which the network interface is attached.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attachment.status</code> - The status of the attachment (<code>attaching</code> | <code>attached</code> |
     * <code>detaching</code> | <code>detached</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>description</code> - The description of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>group-id</code> - The ID of a security group associated with the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>group-name</code> - The name of a security group associated with the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ipv6-addresses.ipv6-address</code> - An IPv6 address associated with the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mac-address</code> - The MAC address of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface-id</code> - The ID of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>owner-id</code> - The AWS account ID of the network interface owner.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>private-ip-address</code> - The private IPv4 address or addresses of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>private-dns-name</code> - The private DNS name of the network interface (IPv4).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example, AWS
     * Management Console, Auto Scaling, and so on).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>requester-managed</code> - Indicates whether the network interface is being managed by an AWS service (for
     * example, AWS Management Console, Auto Scaling, and so on).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>source-desk-check</code> - Indicates whether the network interface performs source/destination checking. A
     * value of <code>true</code> means checking is enabled, and <code>false</code> means checking is disabled. The
     * value must be <code>false</code> for the network interface to perform network address translation (NAT) in your
     * VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status</code> - The status of the network interface. If the network interface is not attached to an
     * instance, the status is <code>available</code>; if a network interface is attached to an instance the status is
     * <code>in-use</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>subnet-id</code> - The ID of the subnet for the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key in
     * the filter name and the tag value as the filter value. For example, to find all resources that have a tag with
     * the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name
     * and <code>TeamA</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned
     * a tag with a specific key, regardless of the tag value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-id</code> - The ID of the VPC for the network interface.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>addresses.private-ip-address</code> - The private IPv4 addresses associated with the network
     *         interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>addresses.primary</code> - Whether the private IPv4 address is the primary IP address associated
     *         with the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>addresses.association.public-ip</code> - The association ID returned when the network interface was
     *         associated with the Elastic IP address (IPv4).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>addresses.association.owner-id</code> - The owner ID of the addresses associated with the network
     *         interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>association.association-id</code> - The association ID returned when the network interface was
     *         associated with an IPv4 address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP
     *         address (IPv4) for your network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated with the
     *         network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the network
     *         interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>association.public-dns-name</code> - The public DNS name for the network interface (IPv4).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.attachment-id</code> - The ID of the interface attachment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.attach.time</code> - The time that the network interface was attached to an instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.delete-on-termination</code> - Indicates whether the attachment is deleted when an
     *         instance is terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.device-index</code> - The device index to which the network interface is attached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.instance-id</code> - The ID of the instance to which the network interface is attached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.instance-owner-id</code> - The owner ID of the instance to which the network interface
     *         is attached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.nat-gateway-id</code> - The ID of the NAT gateway to which the network interface is
     *         attached.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attachment.status</code> - The status of the attachment (<code>attaching</code> |
     *         <code>attached</code> | <code>detaching</code> | <code>detached</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>description</code> - The description of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>group-id</code> - The ID of a security group associated with the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>group-name</code> - The name of a security group associated with the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ipv6-addresses.ipv6-address</code> - An IPv6 address associated with the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mac-address</code> - The MAC address of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface-id</code> - The ID of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>owner-id</code> - The AWS account ID of the network interface owner.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>private-ip-address</code> - The private IPv4 address or addresses of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>private-dns-name</code> - The private DNS name of the network interface (IPv4).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example,
     *         AWS Management Console, Auto Scaling, and so on).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>requester-managed</code> - Indicates whether the network interface is being managed by an AWS
     *         service (for example, AWS Management Console, Auto Scaling, and so on).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>source-desk-check</code> - Indicates whether the network interface performs source/destination
     *         checking. A value of <code>true</code> means checking is enabled, and <code>false</code> means checking
     *         is disabled. The value must be <code>false</code> for the network interface to perform network address
     *         translation (NAT) in your VPC.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status</code> - The status of the network interface. If the network interface is not attached to an
     *         instance, the status is <code>available</code>; if a network interface is attached to an instance the
     *         status is <code>in-use</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>subnet-id</code> - The ID of the subnet for the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag
     *         key in the filter name and the tag value as the filter value. For example, to find all resources that
     *         have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
     *         <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
     *         assigned a tag with a specific key, regardless of the tag value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpc-id</code> - The ID of the VPC for the network interface.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * One or more network interface IDs.
     * </p>
     * <p>
     * Default: Describes all your network interfaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more network interface IDs.</p>
     *         <p>
     *         Default: Describes all your network interfaces.
     */
    public List<String> networkInterfaceIds() {
        return networkInterfaceIds;
    }

    /**
     * <p>
     * The token to retrieve the next page of results.
     * </p>
     * 
     * @return The token to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return for this request. The request returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @return The maximum number of items to return for this request. The request returns a token that you can specify
     *         in a subsequent call to get the next set of results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceIds());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkInterfacesRequest)) {
            return false;
        }
        DescribeNetworkInterfacesRequest other = (DescribeNetworkInterfacesRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(networkInterfaceIds(), other.networkInterfaceIds())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeNetworkInterfacesRequest").add("Filters", filters())
                .add("NetworkInterfaceIds", networkInterfaceIds()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "NetworkInterfaceIds":
            return Optional.ofNullable(clazz.cast(networkInterfaceIds()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNetworkInterfacesRequest, T> g) {
        return obj -> g.apply((DescribeNetworkInterfacesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeNetworkInterfacesRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>addresses.private-ip-address</code> - The private IPv4 addresses associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>addresses.primary</code> - Whether the private IPv4 address is the primary IP address associated with
         * the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>addresses.association.public-ip</code> - The association ID returned when the network interface was
         * associated with the Elastic IP address (IPv4).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>addresses.association.owner-id</code> - The owner ID of the addresses associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.association-id</code> - The association ID returned when the network interface was
         * associated with an IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP address
         * (IPv4) for your network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.public-dns-name</code> - The public DNS name for the network interface (IPv4).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.attachment-id</code> - The ID of the interface attachment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.attach.time</code> - The time that the network interface was attached to an instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.delete-on-termination</code> - Indicates whether the attachment is deleted when an instance
         * is terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.device-index</code> - The device index to which the network interface is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.instance-id</code> - The ID of the instance to which the network interface is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.instance-owner-id</code> - The owner ID of the instance to which the network interface is
         * attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.nat-gateway-id</code> - The ID of the NAT gateway to which the network interface is
         * attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.status</code> - The status of the attachment (<code>attaching</code> | <code>attached</code>
         * | <code>detaching</code> | <code>detached</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>description</code> - The description of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-id</code> - The ID of a security group associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-name</code> - The name of a security group associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-addresses.ipv6-address</code> - An IPv6 address associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mac-address</code> - The MAC address of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-id</code> - The ID of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The AWS account ID of the network interface owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-ip-address</code> - The private IPv4 address or addresses of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name</code> - The private DNS name of the network interface (IPv4).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example, AWS
         * Management Console, Auto Scaling, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-managed</code> - Indicates whether the network interface is being managed by an AWS service
         * (for example, AWS Management Console, Auto Scaling, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>source-desk-check</code> - Indicates whether the network interface performs source/destination
         * checking. A value of <code>true</code> means checking is enabled, and <code>false</code> means checking is
         * disabled. The value must be <code>false</code> for the network interface to perform network address
         * translation (NAT) in your VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the network interface. If the network interface is not attached to an
         * instance, the status is <code>available</code>; if a network interface is attached to an instance the status
         * is <code>in-use</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-id</code> - The ID of the subnet for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC for the network interface.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>addresses.private-ip-address</code> - The private IPv4 addresses associated with the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>addresses.primary</code> - Whether the private IPv4 address is the primary IP address associated
         *        with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>addresses.association.public-ip</code> - The association ID returned when the network interface
         *        was associated with the Elastic IP address (IPv4).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>addresses.association.owner-id</code> - The owner ID of the addresses associated with the
         *        network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.association-id</code> - The association ID returned when the network interface was
         *        associated with an IPv4 address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP
         *        address (IPv4) for your network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated with the
         *        network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.public-dns-name</code> - The public DNS name for the network interface (IPv4).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.attachment-id</code> - The ID of the interface attachment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.attach.time</code> - The time that the network interface was attached to an instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.delete-on-termination</code> - Indicates whether the attachment is deleted when an
         *        instance is terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.device-index</code> - The device index to which the network interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.instance-id</code> - The ID of the instance to which the network interface is
         *        attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.instance-owner-id</code> - The owner ID of the instance to which the network
         *        interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.nat-gateway-id</code> - The ID of the NAT gateway to which the network interface is
         *        attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.status</code> - The status of the attachment (<code>attaching</code> |
         *        <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>description</code> - The description of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-id</code> - The ID of a security group associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-name</code> - The name of a security group associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-addresses.ipv6-address</code> - An IPv6 address associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mac-address</code> - The MAC address of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface-id</code> - The ID of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The AWS account ID of the network interface owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-ip-address</code> - The private IPv4 address or addresses of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-dns-name</code> - The private DNS name of the network interface (IPv4).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for
         *        example, AWS Management Console, Auto Scaling, and so on).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requester-managed</code> - Indicates whether the network interface is being managed by an AWS
         *        service (for example, AWS Management Console, Auto Scaling, and so on).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>source-desk-check</code> - Indicates whether the network interface performs source/destination
         *        checking. A value of <code>true</code> means checking is enabled, and <code>false</code> means
         *        checking is disabled. The value must be <code>false</code> for the network interface to perform
         *        network address translation (NAT) in your VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - The status of the network interface. If the network interface is not attached to
         *        an instance, the status is <code>available</code>; if a network interface is attached to an instance
         *        the status is <code>in-use</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>subnet-id</code> - The ID of the subnet for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC for the network interface.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>addresses.private-ip-address</code> - The private IPv4 addresses associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>addresses.primary</code> - Whether the private IPv4 address is the primary IP address associated with
         * the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>addresses.association.public-ip</code> - The association ID returned when the network interface was
         * associated with the Elastic IP address (IPv4).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>addresses.association.owner-id</code> - The owner ID of the addresses associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.association-id</code> - The association ID returned when the network interface was
         * associated with an IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP address
         * (IPv4) for your network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.public-dns-name</code> - The public DNS name for the network interface (IPv4).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.attachment-id</code> - The ID of the interface attachment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.attach.time</code> - The time that the network interface was attached to an instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.delete-on-termination</code> - Indicates whether the attachment is deleted when an instance
         * is terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.device-index</code> - The device index to which the network interface is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.instance-id</code> - The ID of the instance to which the network interface is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.instance-owner-id</code> - The owner ID of the instance to which the network interface is
         * attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.nat-gateway-id</code> - The ID of the NAT gateway to which the network interface is
         * attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.status</code> - The status of the attachment (<code>attaching</code> | <code>attached</code>
         * | <code>detaching</code> | <code>detached</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>description</code> - The description of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-id</code> - The ID of a security group associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-name</code> - The name of a security group associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-addresses.ipv6-address</code> - An IPv6 address associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mac-address</code> - The MAC address of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-id</code> - The ID of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The AWS account ID of the network interface owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-ip-address</code> - The private IPv4 address or addresses of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name</code> - The private DNS name of the network interface (IPv4).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example, AWS
         * Management Console, Auto Scaling, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-managed</code> - Indicates whether the network interface is being managed by an AWS service
         * (for example, AWS Management Console, Auto Scaling, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>source-desk-check</code> - Indicates whether the network interface performs source/destination
         * checking. A value of <code>true</code> means checking is enabled, and <code>false</code> means checking is
         * disabled. The value must be <code>false</code> for the network interface to perform network address
         * translation (NAT) in your VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the network interface. If the network interface is not attached to an
         * instance, the status is <code>available</code>; if a network interface is attached to an instance the status
         * is <code>in-use</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-id</code> - The ID of the subnet for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC for the network interface.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>addresses.private-ip-address</code> - The private IPv4 addresses associated with the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>addresses.primary</code> - Whether the private IPv4 address is the primary IP address associated
         *        with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>addresses.association.public-ip</code> - The association ID returned when the network interface
         *        was associated with the Elastic IP address (IPv4).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>addresses.association.owner-id</code> - The owner ID of the addresses associated with the
         *        network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.association-id</code> - The association ID returned when the network interface was
         *        associated with an IPv4 address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP
         *        address (IPv4) for your network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated with the
         *        network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the network
         *        interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>association.public-dns-name</code> - The public DNS name for the network interface (IPv4).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.attachment-id</code> - The ID of the interface attachment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.attach.time</code> - The time that the network interface was attached to an instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.delete-on-termination</code> - Indicates whether the attachment is deleted when an
         *        instance is terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.device-index</code> - The device index to which the network interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.instance-id</code> - The ID of the instance to which the network interface is
         *        attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.instance-owner-id</code> - The owner ID of the instance to which the network
         *        interface is attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.nat-gateway-id</code> - The ID of the NAT gateway to which the network interface is
         *        attached.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attachment.status</code> - The status of the attachment (<code>attaching</code> |
         *        <code>attached</code> | <code>detaching</code> | <code>detached</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>description</code> - The description of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-id</code> - The ID of a security group associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>group-name</code> - The name of a security group associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6-addresses.ipv6-address</code> - An IPv6 address associated with the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mac-address</code> - The MAC address of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface-id</code> - The ID of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>owner-id</code> - The AWS account ID of the network interface owner.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-ip-address</code> - The private IPv4 address or addresses of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private-dns-name</code> - The private DNS name of the network interface (IPv4).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for
         *        example, AWS Management Console, Auto Scaling, and so on).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requester-managed</code> - Indicates whether the network interface is being managed by an AWS
         *        service (for example, AWS Management Console, Auto Scaling, and so on).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>source-desk-check</code> - Indicates whether the network interface performs source/destination
         *        checking. A value of <code>true</code> means checking is enabled, and <code>false</code> means
         *        checking is disabled. The value must be <code>false</code> for the network interface to perform
         *        network address translation (NAT) in your VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - The status of the network interface. If the network interface is not attached to
         *        an instance, the status is <code>available</code>; if a network interface is attached to an instance
         *        the status is <code>in-use</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>subnet-id</code> - The ID of the subnet for the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the
         *        tag key in the filter name and the tag value as the filter value. For example, to find all resources
         *        that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify
         *        <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all
         *        resources assigned a tag with a specific key, regardless of the tag value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC for the network interface.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>addresses.private-ip-address</code> - The private IPv4 addresses associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>addresses.primary</code> - Whether the private IPv4 address is the primary IP address associated with
         * the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>addresses.association.public-ip</code> - The association ID returned when the network interface was
         * associated with the Elastic IP address (IPv4).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>addresses.association.owner-id</code> - The owner ID of the addresses associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.association-id</code> - The association ID returned when the network interface was
         * associated with an IPv4 address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.allocation-id</code> - The allocation ID returned when you allocated the Elastic IP address
         * (IPv4) for your network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.ip-owner-id</code> - The owner of the Elastic IP address (IPv4) associated with the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.public-ip</code> - The address of the Elastic IP address (IPv4) bound to the network
         * interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>association.public-dns-name</code> - The public DNS name for the network interface (IPv4).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.attachment-id</code> - The ID of the interface attachment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.attach.time</code> - The time that the network interface was attached to an instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.delete-on-termination</code> - Indicates whether the attachment is deleted when an instance
         * is terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.device-index</code> - The device index to which the network interface is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.instance-id</code> - The ID of the instance to which the network interface is attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.instance-owner-id</code> - The owner ID of the instance to which the network interface is
         * attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.nat-gateway-id</code> - The ID of the NAT gateway to which the network interface is
         * attached.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attachment.status</code> - The status of the attachment (<code>attaching</code> | <code>attached</code>
         * | <code>detaching</code> | <code>detached</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>description</code> - The description of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-id</code> - The ID of a security group associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>group-name</code> - The name of a security group associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6-addresses.ipv6-address</code> - An IPv6 address associated with the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mac-address</code> - The MAC address of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-id</code> - The ID of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>owner-id</code> - The AWS account ID of the network interface owner.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-ip-address</code> - The private IPv4 address or addresses of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private-dns-name</code> - The private DNS name of the network interface (IPv4).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-id</code> - The ID of the entity that launched the instance on your behalf (for example, AWS
         * Management Console, Auto Scaling, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-managed</code> - Indicates whether the network interface is being managed by an AWS service
         * (for example, AWS Management Console, Auto Scaling, and so on).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>source-desk-check</code> - Indicates whether the network interface performs source/destination
         * checking. A value of <code>true</code> means checking is enabled, and <code>false</code> means checking is
         * disabled. The value must be <code>false</code> for the network interface to perform network address
         * translation (NAT) in your VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - The status of the network interface. If the network interface is not attached to an
         * instance, the status is <code>available</code>; if a network interface is attached to an instance the status
         * is <code>in-use</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>subnet-id</code> - The ID of the subnet for the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag key
         * in the filter name and the tag value as the filter value. For example, to find all resources that have a tag
         * with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the
         * filter name and <code>TeamA</code> for the filter value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources
         * assigned a tag with a specific key, regardless of the tag value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC for the network interface.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * One or more network interface IDs.
         * </p>
         * <p>
         * Default: Describes all your network interfaces.
         * </p>
         * 
         * @param networkInterfaceIds
         *        One or more network interface IDs.</p>
         *        <p>
         *        Default: Describes all your network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceIds(Collection<String> networkInterfaceIds);

        /**
         * <p>
         * One or more network interface IDs.
         * </p>
         * <p>
         * Default: Describes all your network interfaces.
         * </p>
         * 
         * @param networkInterfaceIds
         *        One or more network interface IDs.</p>
         *        <p>
         *        Default: Describes all your network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceIds(String... networkInterfaceIds);

        /**
         * <p>
         * The token to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return for this request. The request returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this request. The request returns a token that you can
         *        specify in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<String> networkInterfaceIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkInterfacesRequest model) {
            super(model);
            filters(model.filters);
            networkInterfaceIds(model.networkInterfaceIds);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getNetworkInterfaceIds() {
            return networkInterfaceIds;
        }

        @Override
        public final Builder networkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = NetworkInterfaceIdListCopier.copy(networkInterfaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaceIds(String... networkInterfaceIds) {
            networkInterfaceIds(Arrays.asList(networkInterfaceIds));
            return this;
        }

        public final void setNetworkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = NetworkInterfaceIdListCopier.copy(networkInterfaceIds);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeNetworkInterfacesRequest build() {
            return new DescribeNetworkInterfacesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
