/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeSpotFleetRequests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSpotFleetRequestsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeSpotFleetRequestsResponse.Builder, DescribeSpotFleetRequestsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSpotFleetRequestsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<List<SpotFleetRequestConfig>> SPOT_FLEET_REQUEST_CONFIGS_FIELD = SdkField
            .<List<SpotFleetRequestConfig>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSpotFleetRequestsResponse::spotFleetRequestConfigs))
            .setter(setter(Builder::spotFleetRequestConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotFleetRequestConfigSet")
                    .unmarshallLocationName("spotFleetRequestConfigSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<SpotFleetRequestConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(SpotFleetRequestConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SPOT_FLEET_REQUEST_CONFIGS_FIELD));

    private final String nextToken;

    private final List<SpotFleetRequestConfig> spotFleetRequestConfigs;

    private DescribeSpotFleetRequestsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.spotFleetRequestConfigs = builder.spotFleetRequestConfigs;
    }

    /**
     * <p>
     * The token required to retrieve the next set of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token required to retrieve the next set of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Information about the configuration of your Spot Fleet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the configuration of your Spot Fleet.
     */
    public List<SpotFleetRequestConfig> spotFleetRequestConfigs() {
        return spotFleetRequestConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(spotFleetRequestConfigs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotFleetRequestsResponse)) {
            return false;
        }
        DescribeSpotFleetRequestsResponse other = (DescribeSpotFleetRequestsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(spotFleetRequestConfigs(), other.spotFleetRequestConfigs());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeSpotFleetRequestsResponse").add("NextToken", nextToken())
                .add("SpotFleetRequestConfigs", spotFleetRequestConfigs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "SpotFleetRequestConfigs":
            return Optional.ofNullable(clazz.cast(spotFleetRequestConfigs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSpotFleetRequestsResponse, T> g) {
        return obj -> g.apply((DescribeSpotFleetRequestsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSpotFleetRequestsResponse> {
        /**
         * <p>
         * The token required to retrieve the next set of results. This value is <code>null</code> when there are no
         * more results to return.
         * </p>
         * 
         * @param nextToken
         *        The token required to retrieve the next set of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the configuration of your Spot Fleet.
         * </p>
         * 
         * @param spotFleetRequestConfigs
         *        Information about the configuration of your Spot Fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestConfigs(Collection<SpotFleetRequestConfig> spotFleetRequestConfigs);

        /**
         * <p>
         * Information about the configuration of your Spot Fleet.
         * </p>
         * 
         * @param spotFleetRequestConfigs
         *        Information about the configuration of your Spot Fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestConfigs(SpotFleetRequestConfig... spotFleetRequestConfigs);

        /**
         * <p>
         * Information about the configuration of your Spot Fleet.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SpotFleetRequestConfig>.Builder} avoiding
         * the need to create one manually via {@link List<SpotFleetRequestConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SpotFleetRequestConfig>.Builder#build()} is called
         * immediately and its result is passed to {@link #spotFleetRequestConfigs(List<SpotFleetRequestConfig>)}.
         * 
         * @param spotFleetRequestConfigs
         *        a consumer that will call methods on {@link List<SpotFleetRequestConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spotFleetRequestConfigs(List<SpotFleetRequestConfig>)
         */
        Builder spotFleetRequestConfigs(Consumer<SpotFleetRequestConfig.Builder>... spotFleetRequestConfigs);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<SpotFleetRequestConfig> spotFleetRequestConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotFleetRequestsResponse model) {
            super(model);
            nextToken(model.nextToken);
            spotFleetRequestConfigs(model.spotFleetRequestConfigs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<SpotFleetRequestConfig.Builder> getSpotFleetRequestConfigs() {
            return spotFleetRequestConfigs != null ? spotFleetRequestConfigs.stream().map(SpotFleetRequestConfig::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder spotFleetRequestConfigs(Collection<SpotFleetRequestConfig> spotFleetRequestConfigs) {
            this.spotFleetRequestConfigs = SpotFleetRequestConfigSetCopier.copy(spotFleetRequestConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotFleetRequestConfigs(SpotFleetRequestConfig... spotFleetRequestConfigs) {
            spotFleetRequestConfigs(Arrays.asList(spotFleetRequestConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotFleetRequestConfigs(Consumer<SpotFleetRequestConfig.Builder>... spotFleetRequestConfigs) {
            spotFleetRequestConfigs(Stream.of(spotFleetRequestConfigs)
                    .map(c -> SpotFleetRequestConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSpotFleetRequestConfigs(Collection<SpotFleetRequestConfig.BuilderImpl> spotFleetRequestConfigs) {
            this.spotFleetRequestConfigs = SpotFleetRequestConfigSetCopier.copyFromBuilder(spotFleetRequestConfigs);
        }

        @Override
        public DescribeSpotFleetRequestsResponse build() {
            return new DescribeSpotFleetRequestsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
