/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeSpotPriceHistory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSpotPriceHistoryRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeSpotPriceHistoryRequest.Builder, DescribeSpotPriceHistoryRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSpotPriceHistoryRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSpotPriceHistoryRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeSpotPriceHistoryRequest::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime")
                    .unmarshallLocationName("endTime").build()).build();

    private static final SdkField<List<String>> INSTANCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSpotPriceHistoryRequest::instanceTypesAsStrings))
            .setter(setter(Builder::instanceTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("InstanceType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeSpotPriceHistoryRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSpotPriceHistoryRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<List<String>> PRODUCT_DESCRIPTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSpotPriceHistoryRequest::productDescriptions))
            .setter(setter(Builder::productDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductDescription")
                    .unmarshallLocationName("ProductDescription").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeSpotPriceHistoryRequest::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime")
                    .unmarshallLocationName("startTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            AVAILABILITY_ZONE_FIELD, END_TIME_FIELD, INSTANCE_TYPES_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD,
            PRODUCT_DESCRIPTIONS_FIELD, START_TIME_FIELD));

    private final List<Filter> filters;

    private final String availabilityZone;

    private final Instant endTime;

    private final List<String> instanceTypes;

    private final Integer maxResults;

    private final String nextToken;

    private final List<String> productDescriptions;

    private final Instant startTime;

    private DescribeSpotPriceHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.availabilityZone = builder.availabilityZone;
        this.endTime = builder.endTime;
        this.instanceTypes = builder.instanceTypes;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.productDescriptions = builder.productDescriptions;
        this.startTime = builder.startTime;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone for which prices should be returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-type</code> - The type of instance (for example, <code>m3.medium</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>product-description</code> - The product description for the Spot price (<code>Linux/UNIX</code> |
     * <code>SUSE Linux</code> | <code>Windows</code> | <code>Linux/UNIX (Amazon VPC)</code> |
     * <code>SUSE Linux (Amazon VPC)</code> | <code>Windows (Amazon VPC)</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>spot-price</code> - The Spot price. The value must match exactly (or use wildcards; greater than or less
     * than comparison is not supported).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>timestamp</code> - The time stamp of the Spot price history, in UTC format (for example,
     * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). You can use wildcards (* and ?). Greater than or
     * less than comparison is not supported.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone for which prices should be returned.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-type</code> - The type of instance (for example, <code>m3.medium</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>product-description</code> - The product description for the Spot price (<code>Linux/UNIX</code> |
     *         <code>SUSE Linux</code> | <code>Windows</code> | <code>Linux/UNIX (Amazon VPC)</code> |
     *         <code>SUSE Linux (Amazon VPC)</code> | <code>Windows (Amazon VPC)</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>spot-price</code> - The Spot price. The value must match exactly (or use wildcards; greater than or
     *         less than comparison is not supported).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>timestamp</code> - The time stamp of the Spot price history, in UTC format (for example,
     *         <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). You can use wildcards (* and ?). Greater
     *         than or less than comparison is not supported.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * Filters the results by the specified Availability Zone.
     * </p>
     * 
     * @return Filters the results by the specified Availability Zone.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The date and time, up to the current date, from which to stop retrieving the price history data, in UTC format
     * (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     * </p>
     * 
     * @return The date and time, up to the current date, from which to stop retrieving the price history data, in UTC
     *         format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Filters the results by the specified instance types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Filters the results by the specified instance types.
     */
    public List<InstanceType> instanceTypes() {
        return TypeConverter.convert(instanceTypes, InstanceType::fromValue);
    }

    /**
     * <p>
     * Filters the results by the specified instance types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Filters the results by the specified instance types.
     */
    public List<String> instanceTypesAsStrings() {
        return instanceTypes;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default value
     * is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default
     *         value is 1000. To retrieve the remaining results, make another call with the returned
     *         <code>NextToken</code> value.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Filters the results by the specified basic product descriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Filters the results by the specified basic product descriptions.
     */
    public List<String> productDescriptions() {
        return productDescriptions;
    }

    /**
     * <p>
     * The date and time, up to the past 90 days, from which to start retrieving the price history data, in UTC format
     * (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     * </p>
     * 
     * @return The date and time, up to the past 90 days, from which to start retrieving the price history data, in UTC
     *         format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     */
    public Instant startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(productDescriptions());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotPriceHistoryRequest)) {
            return false;
        }
        DescribeSpotPriceHistoryRequest other = (DescribeSpotPriceHistoryRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(endTime(), other.endTime())
                && Objects.equals(instanceTypesAsStrings(), other.instanceTypesAsStrings())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(productDescriptions(), other.productDescriptions())
                && Objects.equals(startTime(), other.startTime());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeSpotPriceHistoryRequest").add("Filters", filters())
                .add("AvailabilityZone", availabilityZone()).add("EndTime", endTime())
                .add("InstanceTypes", instanceTypesAsStrings()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("ProductDescriptions", productDescriptions()).add("StartTime", startTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "InstanceTypes":
            return Optional.ofNullable(clazz.cast(instanceTypesAsStrings()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ProductDescriptions":
            return Optional.ofNullable(clazz.cast(productDescriptions()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSpotPriceHistoryRequest, T> g) {
        return obj -> g.apply((DescribeSpotPriceHistoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSpotPriceHistoryRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone for which prices should be returned.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The type of instance (for example, <code>m3.medium</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-description</code> - The product description for the Spot price (<code>Linux/UNIX</code> |
         * <code>SUSE Linux</code> | <code>Windows</code> | <code>Linux/UNIX (Amazon VPC)</code> |
         * <code>SUSE Linux (Amazon VPC)</code> | <code>Windows (Amazon VPC)</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>spot-price</code> - The Spot price. The value must match exactly (or use wildcards; greater than or
         * less than comparison is not supported).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>timestamp</code> - The time stamp of the Spot price history, in UTC format (for example,
         * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). You can use wildcards (* and ?). Greater
         * than or less than comparison is not supported.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone for which prices should be returned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The type of instance (for example, <code>m3.medium</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-description</code> - The product description for the Spot price (<code>Linux/UNIX</code>
         *        | <code>SUSE Linux</code> | <code>Windows</code> | <code>Linux/UNIX (Amazon VPC)</code> |
         *        <code>SUSE Linux (Amazon VPC)</code> | <code>Windows (Amazon VPC)</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>spot-price</code> - The Spot price. The value must match exactly (or use wildcards; greater than
         *        or less than comparison is not supported).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>timestamp</code> - The time stamp of the Spot price history, in UTC format (for example,
         *        <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). You can use wildcards (* and ?).
         *        Greater than or less than comparison is not supported.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone for which prices should be returned.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The type of instance (for example, <code>m3.medium</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-description</code> - The product description for the Spot price (<code>Linux/UNIX</code> |
         * <code>SUSE Linux</code> | <code>Windows</code> | <code>Linux/UNIX (Amazon VPC)</code> |
         * <code>SUSE Linux (Amazon VPC)</code> | <code>Windows (Amazon VPC)</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>spot-price</code> - The Spot price. The value must match exactly (or use wildcards; greater than or
         * less than comparison is not supported).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>timestamp</code> - The time stamp of the Spot price history, in UTC format (for example,
         * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). You can use wildcards (* and ?). Greater
         * than or less than comparison is not supported.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone for which prices should be returned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The type of instance (for example, <code>m3.medium</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>product-description</code> - The product description for the Spot price (<code>Linux/UNIX</code>
         *        | <code>SUSE Linux</code> | <code>Windows</code> | <code>Linux/UNIX (Amazon VPC)</code> |
         *        <code>SUSE Linux (Amazon VPC)</code> | <code>Windows (Amazon VPC)</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>spot-price</code> - The Spot price. The value must match exactly (or use wildcards; greater than
         *        or less than comparison is not supported).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>timestamp</code> - The time stamp of the Spot price history, in UTC format (for example,
         *        <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). You can use wildcards (* and ?).
         *        Greater than or less than comparison is not supported.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone for which prices should be returned.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The type of instance (for example, <code>m3.medium</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>product-description</code> - The product description for the Spot price (<code>Linux/UNIX</code> |
         * <code>SUSE Linux</code> | <code>Windows</code> | <code>Linux/UNIX (Amazon VPC)</code> |
         * <code>SUSE Linux (Amazon VPC)</code> | <code>Windows (Amazon VPC)</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>spot-price</code> - The Spot price. The value must match exactly (or use wildcards; greater than or
         * less than comparison is not supported).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>timestamp</code> - The time stamp of the Spot price history, in UTC format (for example,
         * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). You can use wildcards (* and ?). Greater
         * than or less than comparison is not supported.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * Filters the results by the specified Availability Zone.
         * </p>
         * 
         * @param availabilityZone
         *        Filters the results by the specified Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The date and time, up to the current date, from which to stop retrieving the price history data, in UTC
         * format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
         * </p>
         * 
         * @param endTime
         *        The date and time, up to the current date, from which to stop retrieving the price history data, in
         *        UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Filters the results by the specified instance types.
         * </p>
         * 
         * @param instanceTypes
         *        Filters the results by the specified instance types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypesWithStrings(Collection<String> instanceTypes);

        /**
         * <p>
         * Filters the results by the specified instance types.
         * </p>
         * 
         * @param instanceTypes
         *        Filters the results by the specified instance types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypesWithStrings(String... instanceTypes);

        /**
         * <p>
         * Filters the results by the specified instance types.
         * </p>
         * 
         * @param instanceTypes
         *        Filters the results by the specified instance types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypes(Collection<InstanceType> instanceTypes);

        /**
         * <p>
         * Filters the results by the specified instance types.
         * </p>
         * 
         * @param instanceTypes
         *        Filters the results by the specified instance types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypes(InstanceType... instanceTypes);

        /**
         * <p>
         * The maximum number of results to return in a single call. Specify a value between 1 and 1000. The default
         * value is 1000. To retrieve the remaining results, make another call with the returned <code>NextToken</code>
         * value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. Specify a value between 1 and 1000. The
         *        default value is 1000. To retrieve the remaining results, make another call with the returned
         *        <code>NextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Filters the results by the specified basic product descriptions.
         * </p>
         * 
         * @param productDescriptions
         *        Filters the results by the specified basic product descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productDescriptions(Collection<String> productDescriptions);

        /**
         * <p>
         * Filters the results by the specified basic product descriptions.
         * </p>
         * 
         * @param productDescriptions
         *        Filters the results by the specified basic product descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productDescriptions(String... productDescriptions);

        /**
         * <p>
         * The date and time, up to the past 90 days, from which to start retrieving the price history data, in UTC
         * format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
         * </p>
         * 
         * @param startTime
         *        The date and time, up to the past 90 days, from which to start retrieving the price history data, in
         *        UTC format (for example, <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private String availabilityZone;

        private Instant endTime;

        private List<String> instanceTypes = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private List<String> productDescriptions = DefaultSdkAutoConstructList.getInstance();

        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotPriceHistoryRequest model) {
            super(model);
            filters(model.filters);
            availabilityZone(model.availabilityZone);
            endTime(model.endTime);
            instanceTypesWithStrings(model.instanceTypes);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            productDescriptions(model.productDescriptions);
            startTime(model.startTime);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Collection<String> getInstanceTypes() {
            return instanceTypes;
        }

        @Override
        public final Builder instanceTypesWithStrings(Collection<String> instanceTypes) {
            this.instanceTypes = InstanceTypeListCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypesWithStrings(String... instanceTypes) {
            instanceTypesWithStrings(Arrays.asList(instanceTypes));
            return this;
        }

        @Override
        public final Builder instanceTypes(Collection<InstanceType> instanceTypes) {
            this.instanceTypes = InstanceTypeListCopier.copyEnumToString(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(InstanceType... instanceTypes) {
            instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        public final void setInstanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = InstanceTypeListCopier.copy(instanceTypes);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getProductDescriptions() {
            return productDescriptions;
        }

        @Override
        public final Builder productDescriptions(Collection<String> productDescriptions) {
            this.productDescriptions = ProductDescriptionListCopier.copy(productDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productDescriptions(String... productDescriptions) {
            productDescriptions(Arrays.asList(productDescriptions));
            return this;
        }

        public final void setProductDescriptions(Collection<String> productDescriptions) {
            this.productDescriptions = ProductDescriptionListCopier.copy(productDescriptions);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSpotPriceHistoryRequest build() {
            return new DescribeSpotPriceHistoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
