/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTagsRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeTagsRequest.Builder, DescribeTagsRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeTagsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeTagsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTagsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<Filter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeTagsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>key</code> - The tag key.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resource-id</code> - The ID of the resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resource-type</code> - The resource type (<code>customer-gateway</code> | <code>dedicated-host</code> |
     * <code>dhcp-options</code> | <code>elastic-ip</code> | <code>fleet</code> | <code>fpga-image</code> |
     * <code>image</code> | <code>instance</code> | <code>internet-gateway</code> | <code>launch-template</code> |
     * <code>natgateway</code> | <code>network-acl</code> | <code>network-interface</code> |
     * <code>reserved-instances</code> | <code>route-table</code> | <code>security-group</code> | <code>snapshot</code>
     * | <code>spot-instances-request</code> | <code>subnet</code> | <code>volume</code> | <code>vpc</code> |
     * <code>vpc-peering-connection</code> | <code>vpn-connection</code> | <code>vpn-gateway</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:&lt;key&gt; - The key/value combination of the tag. For example, specify "tag:Owner" for the
     * filter name and "TeamA" for the filter value to find resources with the tag "Owner=TeamA".
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>value</code> - The tag value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>key</code> - The tag key.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resource-id</code> - The ID of the resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resource-type</code> - The resource type (<code>customer-gateway</code> |
     *         <code>dedicated-host</code> | <code>dhcp-options</code> | <code>elastic-ip</code> | <code>fleet</code> |
     *         <code>fpga-image</code> | <code>image</code> | <code>instance</code> | <code>internet-gateway</code> |
     *         <code>launch-template</code> | <code>natgateway</code> | <code>network-acl</code> |
     *         <code>network-interface</code> | <code>reserved-instances</code> | <code>route-table</code> |
     *         <code>security-group</code> | <code>snapshot</code> | <code>spot-instances-request</code> |
     *         <code>subnet</code> | <code>volume</code> | <code>vpc</code> | <code>vpc-peering-connection</code> |
     *         <code>vpn-connection</code> | <code>vpn-gateway</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:&lt;key&gt; - The key/value combination of the tag. For example, specify "tag:Owner" for
     *         the filter name and "TeamA" for the filter value to find resources with the tag "Owner=TeamA".
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>value</code> - The tag value.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. This value can be between 5 and 1000. To retrieve the
     * remaining results, make another call with the returned <code>NextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. This value can be between 5 and 1000. To
     *         retrieve the remaining results, make another call with the returned <code>NextToken</code> value.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to retrieve the next page of results.
     * </p>
     * 
     * @return The token to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsRequest)) {
            return false;
        }
        DescribeTagsRequest other = (DescribeTagsRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeTagsRequest").add("Filters", filters()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTagsRequest, T> g) {
        return obj -> g.apply((DescribeTagsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTagsRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>key</code> - The tag key.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resource-id</code> - The ID of the resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resource-type</code> - The resource type (<code>customer-gateway</code> | <code>dedicated-host</code> |
         * <code>dhcp-options</code> | <code>elastic-ip</code> | <code>fleet</code> | <code>fpga-image</code> |
         * <code>image</code> | <code>instance</code> | <code>internet-gateway</code> | <code>launch-template</code> |
         * <code>natgateway</code> | <code>network-acl</code> | <code>network-interface</code> |
         * <code>reserved-instances</code> | <code>route-table</code> | <code>security-group</code> |
         * <code>snapshot</code> | <code>spot-instances-request</code> | <code>subnet</code> | <code>volume</code> |
         * <code>vpc</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> |
         * <code>vpn-gateway</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of the tag. For example, specify "tag:Owner" for the
         * filter name and "TeamA" for the filter value to find resources with the tag "Owner=TeamA".
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>value</code> - The tag value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>key</code> - The tag key.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resource-id</code> - The ID of the resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resource-type</code> - The resource type (<code>customer-gateway</code> |
         *        <code>dedicated-host</code> | <code>dhcp-options</code> | <code>elastic-ip</code> | <code>fleet</code>
         *        | <code>fpga-image</code> | <code>image</code> | <code>instance</code> | <code>internet-gateway</code>
         *        | <code>launch-template</code> | <code>natgateway</code> | <code>network-acl</code> |
         *        <code>network-interface</code> | <code>reserved-instances</code> | <code>route-table</code> |
         *        <code>security-group</code> | <code>snapshot</code> | <code>spot-instances-request</code> |
         *        <code>subnet</code> | <code>volume</code> | <code>vpc</code> | <code>vpc-peering-connection</code> |
         *        <code>vpn-connection</code> | <code>vpn-gateway</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of the tag. For example, specify "tag:Owner"
         *        for the filter name and "TeamA" for the filter value to find resources with the tag "Owner=TeamA".
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>value</code> - The tag value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>key</code> - The tag key.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resource-id</code> - The ID of the resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resource-type</code> - The resource type (<code>customer-gateway</code> | <code>dedicated-host</code> |
         * <code>dhcp-options</code> | <code>elastic-ip</code> | <code>fleet</code> | <code>fpga-image</code> |
         * <code>image</code> | <code>instance</code> | <code>internet-gateway</code> | <code>launch-template</code> |
         * <code>natgateway</code> | <code>network-acl</code> | <code>network-interface</code> |
         * <code>reserved-instances</code> | <code>route-table</code> | <code>security-group</code> |
         * <code>snapshot</code> | <code>spot-instances-request</code> | <code>subnet</code> | <code>volume</code> |
         * <code>vpc</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> |
         * <code>vpn-gateway</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of the tag. For example, specify "tag:Owner" for the
         * filter name and "TeamA" for the filter value to find resources with the tag "Owner=TeamA".
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>value</code> - The tag value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>key</code> - The tag key.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resource-id</code> - The ID of the resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resource-type</code> - The resource type (<code>customer-gateway</code> |
         *        <code>dedicated-host</code> | <code>dhcp-options</code> | <code>elastic-ip</code> | <code>fleet</code>
         *        | <code>fpga-image</code> | <code>image</code> | <code>instance</code> | <code>internet-gateway</code>
         *        | <code>launch-template</code> | <code>natgateway</code> | <code>network-acl</code> |
         *        <code>network-interface</code> | <code>reserved-instances</code> | <code>route-table</code> |
         *        <code>security-group</code> | <code>snapshot</code> | <code>spot-instances-request</code> |
         *        <code>subnet</code> | <code>volume</code> | <code>vpc</code> | <code>vpc-peering-connection</code> |
         *        <code>vpn-connection</code> | <code>vpn-gateway</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:&lt;key&gt; - The key/value combination of the tag. For example, specify "tag:Owner"
         *        for the filter name and "TeamA" for the filter value to find resources with the tag "Owner=TeamA".
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>value</code> - The tag value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>key</code> - The tag key.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resource-id</code> - The ID of the resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resource-type</code> - The resource type (<code>customer-gateway</code> | <code>dedicated-host</code> |
         * <code>dhcp-options</code> | <code>elastic-ip</code> | <code>fleet</code> | <code>fpga-image</code> |
         * <code>image</code> | <code>instance</code> | <code>internet-gateway</code> | <code>launch-template</code> |
         * <code>natgateway</code> | <code>network-acl</code> | <code>network-interface</code> |
         * <code>reserved-instances</code> | <code>route-table</code> | <code>security-group</code> |
         * <code>snapshot</code> | <code>spot-instances-request</code> | <code>subnet</code> | <code>volume</code> |
         * <code>vpc</code> | <code>vpc-peering-connection</code> | <code>vpn-connection</code> |
         * <code>vpn-gateway</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:&lt;key&gt; - The key/value combination of the tag. For example, specify "tag:Owner" for the
         * filter name and "TeamA" for the filter value to find resources with the tag "Owner=TeamA".
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>value</code> - The tag value.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The maximum number of results to return in a single call. This value can be between 5 and 1000. To retrieve
         * the remaining results, make another call with the returned <code>NextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. This value can be between 5 and 1000. To
         *        retrieve the remaining results, make another call with the returned <code>NextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTagsRequest model) {
            super(model);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTagsRequest build() {
            return new DescribeTagsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
