/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportTransitGatewayRoutesRequest extends Ec2Request implements
        ToCopyableBuilder<ExportTransitGatewayRoutesRequest.Builder, ExportTransitGatewayRoutesRequest> {
    private static final SdkField<String> TRANSIT_GATEWAY_ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ExportTransitGatewayRoutesRequest::transitGatewayRouteTableId))
            .setter(setter(Builder::transitGatewayRouteTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTableId")
                    .unmarshallLocationName("TransitGatewayRouteTableId").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .getter(getter(ExportTransitGatewayRoutesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<String> S3_BUCKET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ExportTransitGatewayRoutesRequest::s3Bucket))
            .setter(setter(Builder::s3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket")
                    .unmarshallLocationName("S3Bucket").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_ROUTE_TABLE_ID_FIELD, FILTERS_FIELD, S3_BUCKET_FIELD));

    private final String transitGatewayRouteTableId;

    private final List<Filter> filters;

    private final String s3Bucket;

    private ExportTransitGatewayRoutesRequest(BuilderImpl builder) {
        super(builder);
        this.transitGatewayRouteTableId = builder.transitGatewayRouteTableId;
        this.filters = builder.filters;
        this.s3Bucket = builder.s3Bucket;
    }

    /**
     * <p>
     * The ID of the route table.
     * </p>
     * 
     * @return The ID of the route table.
     */
    public String transitGatewayRouteTableId() {
        return transitGatewayRouteTableId;
    }

    /**
     * <p>
     * One or more filters. The possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>transit-gateway-route-destination-cidr-block</code> - The CIDR range.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>transit-gateway-route-state</code> - The state of the route (<code>active</code> | <code>blackhole</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>transit-gateway-route-transit-gateway-attachment-id</code> - The ID of the attachment.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>transit-gateway-route-type</code> - The route type (<code>static</code> | <code>propagated</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>transit-gateway-route-vpn-connection-id</code> - The ID of the VPN connection.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters. The possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>transit-gateway-route-destination-cidr-block</code> - The CIDR range.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>transit-gateway-route-state</code> - The state of the route (<code>active</code> |
     *         <code>blackhole</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>transit-gateway-route-transit-gateway-attachment-id</code> - The ID of the attachment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>transit-gateway-route-type</code> - The route type (<code>static</code> | <code>propagated</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>transit-gateway-route-vpn-connection-id</code> - The ID of the VPN connection.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The name of the S3 bucket.
     * </p>
     * 
     * @return The name of the S3 bucket.
     */
    public String s3Bucket() {
        return s3Bucket;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTransitGatewayRoutesRequest)) {
            return false;
        }
        ExportTransitGatewayRoutesRequest other = (ExportTransitGatewayRoutesRequest) obj;
        return Objects.equals(transitGatewayRouteTableId(), other.transitGatewayRouteTableId())
                && Objects.equals(filters(), other.filters()) && Objects.equals(s3Bucket(), other.s3Bucket());
    }

    @Override
    public String toString() {
        return ToString.builder("ExportTransitGatewayRoutesRequest")
                .add("TransitGatewayRouteTableId", transitGatewayRouteTableId()).add("Filters", filters())
                .add("S3Bucket", s3Bucket()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayRouteTableId":
            return Optional.ofNullable(clazz.cast(transitGatewayRouteTableId()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "S3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportTransitGatewayRoutesRequest, T> g) {
        return obj -> g.apply((ExportTransitGatewayRoutesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ExportTransitGatewayRoutesRequest> {
        /**
         * <p>
         * The ID of the route table.
         * </p>
         * 
         * @param transitGatewayRouteTableId
         *        The ID of the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayRouteTableId(String transitGatewayRouteTableId);

        /**
         * <p>
         * One or more filters. The possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>transit-gateway-route-destination-cidr-block</code> - The CIDR range.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-route-state</code> - The state of the route (<code>active</code> |
         * <code>blackhole</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-route-transit-gateway-attachment-id</code> - The ID of the attachment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-route-type</code> - The route type (<code>static</code> | <code>propagated</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-route-vpn-connection-id</code> - The ID of the VPN connection.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters. The possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>transit-gateway-route-destination-cidr-block</code> - The CIDR range.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>transit-gateway-route-state</code> - The state of the route (<code>active</code> |
         *        <code>blackhole</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>transit-gateway-route-transit-gateway-attachment-id</code> - The ID of the attachment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>transit-gateway-route-type</code> - The route type (<code>static</code> |
         *        <code>propagated</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>transit-gateway-route-vpn-connection-id</code> - The ID of the VPN connection.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters. The possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>transit-gateway-route-destination-cidr-block</code> - The CIDR range.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-route-state</code> - The state of the route (<code>active</code> |
         * <code>blackhole</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-route-transit-gateway-attachment-id</code> - The ID of the attachment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-route-type</code> - The route type (<code>static</code> | <code>propagated</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-route-vpn-connection-id</code> - The ID of the VPN connection.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters. The possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>transit-gateway-route-destination-cidr-block</code> - The CIDR range.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>transit-gateway-route-state</code> - The state of the route (<code>active</code> |
         *        <code>blackhole</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>transit-gateway-route-transit-gateway-attachment-id</code> - The ID of the attachment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>transit-gateway-route-type</code> - The route type (<code>static</code> |
         *        <code>propagated</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>transit-gateway-route-vpn-connection-id</code> - The ID of the VPN connection.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters. The possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>transit-gateway-route-destination-cidr-block</code> - The CIDR range.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-route-state</code> - The state of the route (<code>active</code> |
         * <code>blackhole</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-route-transit-gateway-attachment-id</code> - The ID of the attachment.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-route-type</code> - The route type (<code>static</code> | <code>propagated</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>transit-gateway-route-vpn-connection-id</code> - The ID of the VPN connection.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The name of the S3 bucket.
         * </p>
         * 
         * @param s3Bucket
         *        The name of the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String transitGatewayRouteTableId;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private String s3Bucket;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportTransitGatewayRoutesRequest model) {
            super(model);
            transitGatewayRouteTableId(model.transitGatewayRouteTableId);
            filters(model.filters);
            s3Bucket(model.s3Bucket);
        }

        public final String getTransitGatewayRouteTableId() {
            return transitGatewayRouteTableId;
        }

        @Override
        public final Builder transitGatewayRouteTableId(String transitGatewayRouteTableId) {
            this.transitGatewayRouteTableId = transitGatewayRouteTableId;
            return this;
        }

        public final void setTransitGatewayRouteTableId(String transitGatewayRouteTableId) {
            this.transitGatewayRouteTableId = transitGatewayRouteTableId;
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExportTransitGatewayRoutesRequest build() {
            return new ExportTransitGatewayRoutesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
