/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a launch template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FleetLaunchTemplateSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<FleetLaunchTemplateSpecification.Builder, FleetLaunchTemplateSpecification> {
    private static final SdkField<String> LAUNCH_TEMPLATE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FleetLaunchTemplateSpecification::launchTemplateId))
            .setter(setter(Builder::launchTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateId")
                    .unmarshallLocationName("launchTemplateId").build()).build();

    private static final SdkField<String> LAUNCH_TEMPLATE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FleetLaunchTemplateSpecification::launchTemplateName))
            .setter(setter(Builder::launchTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateName")
                    .unmarshallLocationName("launchTemplateName").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(FleetLaunchTemplateSpecification::version))
            .setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version")
                    .unmarshallLocationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_ID_FIELD,
            LAUNCH_TEMPLATE_NAME_FIELD, VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String launchTemplateId;

    private final String launchTemplateName;

    private final String version;

    private FleetLaunchTemplateSpecification(BuilderImpl builder) {
        this.launchTemplateId = builder.launchTemplateId;
        this.launchTemplateName = builder.launchTemplateName;
        this.version = builder.version;
    }

    /**
     * <p>
     * The ID of the launch template. You must specify either a template ID or a template name.
     * </p>
     * 
     * @return The ID of the launch template. You must specify either a template ID or a template name.
     */
    public String launchTemplateId() {
        return launchTemplateId;
    }

    /**
     * <p>
     * The name of the launch template. You must specify either a template name or a template ID.
     * </p>
     * 
     * @return The name of the launch template. You must specify either a template name or a template ID.
     */
    public String launchTemplateName() {
        return launchTemplateName;
    }

    /**
     * <p>
     * The version number of the launch template. You must specify a version number.
     * </p>
     * 
     * @return The version number of the launch template. You must specify a version number.
     */
    public String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetLaunchTemplateSpecification)) {
            return false;
        }
        FleetLaunchTemplateSpecification other = (FleetLaunchTemplateSpecification) obj;
        return Objects.equals(launchTemplateId(), other.launchTemplateId())
                && Objects.equals(launchTemplateName(), other.launchTemplateName()) && Objects.equals(version(), other.version());
    }

    @Override
    public String toString() {
        return ToString.builder("FleetLaunchTemplateSpecification").add("LaunchTemplateId", launchTemplateId())
                .add("LaunchTemplateName", launchTemplateName()).add("Version", version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchTemplateId":
            return Optional.ofNullable(clazz.cast(launchTemplateId()));
        case "LaunchTemplateName":
            return Optional.ofNullable(clazz.cast(launchTemplateName()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FleetLaunchTemplateSpecification, T> g) {
        return obj -> g.apply((FleetLaunchTemplateSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FleetLaunchTemplateSpecification> {
        /**
         * <p>
         * The ID of the launch template. You must specify either a template ID or a template name.
         * </p>
         * 
         * @param launchTemplateId
         *        The ID of the launch template. You must specify either a template ID or a template name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateId(String launchTemplateId);

        /**
         * <p>
         * The name of the launch template. You must specify either a template name or a template ID.
         * </p>
         * 
         * @param launchTemplateName
         *        The name of the launch template. You must specify either a template name or a template ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateName(String launchTemplateName);

        /**
         * <p>
         * The version number of the launch template. You must specify a version number.
         * </p>
         * 
         * @param version
         *        The version number of the launch template. You must specify a version number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private String launchTemplateId;

        private String launchTemplateName;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetLaunchTemplateSpecification model) {
            launchTemplateId(model.launchTemplateId);
            launchTemplateName(model.launchTemplateName);
            version(model.version);
        }

        public final String getLaunchTemplateId() {
            return launchTemplateId;
        }

        @Override
        public final Builder launchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
            return this;
        }

        public final void setLaunchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
        }

        public final String getLaunchTemplateName() {
            return launchTemplateName;
        }

        @Override
        public final Builder launchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
            return this;
        }

        public final void setLaunchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public FleetLaunchTemplateSpecification build() {
            return new FleetLaunchTemplateSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
