/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a key pair.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeyPairInfo implements SdkPojo, Serializable, ToCopyableBuilder<KeyPairInfo.Builder, KeyPairInfo> {
    private static final SdkField<String> KEY_FINGERPRINT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(KeyPairInfo::keyFingerprint))
            .setter(setter(Builder::keyFingerprint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyFingerprint")
                    .unmarshallLocationName("keyFingerprint").build()).build();

    private static final SdkField<String> KEY_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(KeyPairInfo::keyName))
            .setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName")
                    .unmarshallLocationName("keyName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FINGERPRINT_FIELD,
            KEY_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String keyFingerprint;

    private final String keyName;

    private KeyPairInfo(BuilderImpl builder) {
        this.keyFingerprint = builder.keyFingerprint;
        this.keyName = builder.keyName;
    }

    /**
     * <p>
     * If you used <a>CreateKeyPair</a> to create the key pair, this is the SHA-1 digest of the DER encoded private key.
     * If you used <a>ImportKeyPair</a> to provide AWS the public key, this is the MD5 public key fingerprint as
     * specified in section 4 of RFC4716.
     * </p>
     * 
     * @return If you used <a>CreateKeyPair</a> to create the key pair, this is the SHA-1 digest of the DER encoded
     *         private key. If you used <a>ImportKeyPair</a> to provide AWS the public key, this is the MD5 public key
     *         fingerprint as specified in section 4 of RFC4716.
     */
    public String keyFingerprint() {
        return keyFingerprint;
    }

    /**
     * <p>
     * The name of the key pair.
     * </p>
     * 
     * @return The name of the key pair.
     */
    public String keyName() {
        return keyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyFingerprint());
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyPairInfo)) {
            return false;
        }
        KeyPairInfo other = (KeyPairInfo) obj;
        return Objects.equals(keyFingerprint(), other.keyFingerprint()) && Objects.equals(keyName(), other.keyName());
    }

    @Override
    public String toString() {
        return ToString.builder("KeyPairInfo").add("KeyFingerprint", keyFingerprint()).add("KeyName", keyName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyFingerprint":
            return Optional.ofNullable(clazz.cast(keyFingerprint()));
        case "KeyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KeyPairInfo, T> g) {
        return obj -> g.apply((KeyPairInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeyPairInfo> {
        /**
         * <p>
         * If you used <a>CreateKeyPair</a> to create the key pair, this is the SHA-1 digest of the DER encoded private
         * key. If you used <a>ImportKeyPair</a> to provide AWS the public key, this is the MD5 public key fingerprint
         * as specified in section 4 of RFC4716.
         * </p>
         * 
         * @param keyFingerprint
         *        If you used <a>CreateKeyPair</a> to create the key pair, this is the SHA-1 digest of the DER encoded
         *        private key. If you used <a>ImportKeyPair</a> to provide AWS the public key, this is the MD5 public
         *        key fingerprint as specified in section 4 of RFC4716.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyFingerprint(String keyFingerprint);

        /**
         * <p>
         * The name of the key pair.
         * </p>
         * 
         * @param keyName
         *        The name of the key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);
    }

    static final class BuilderImpl implements Builder {
        private String keyFingerprint;

        private String keyName;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyPairInfo model) {
            keyFingerprint(model.keyFingerprint);
            keyName(model.keyName);
        }

        public final String getKeyFingerprint() {
            return keyFingerprint;
        }

        @Override
        public final Builder keyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
            return this;
        }

        public final void setKeyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
        }

        public final String getKeyName() {
            return keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public KeyPairInfo build() {
            return new KeyPairInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
