/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyFleetRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyFleetRequest.Builder, ModifyFleetRequest> {
    private static final SdkField<String> EXCESS_CAPACITY_TERMINATION_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyFleetRequest::excessCapacityTerminationPolicyAsString))
            .setter(setter(Builder::excessCapacityTerminationPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcessCapacityTerminationPolicy")
                    .unmarshallLocationName("ExcessCapacityTerminationPolicy").build()).build();

    private static final SdkField<String> FLEET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyFleetRequest::fleetId))
            .setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId")
                    .unmarshallLocationName("FleetId").build()).build();

    private static final SdkField<TargetCapacitySpecificationRequest> TARGET_CAPACITY_SPECIFICATION_FIELD = SdkField
            .<TargetCapacitySpecificationRequest> builder(MarshallingType.SDK_POJO)
            .getter(getter(ModifyFleetRequest::targetCapacitySpecification))
            .setter(setter(Builder::targetCapacitySpecification))
            .constructor(TargetCapacitySpecificationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCapacitySpecification")
                    .unmarshallLocationName("TargetCapacitySpecification").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EXCESS_CAPACITY_TERMINATION_POLICY_FIELD, FLEET_ID_FIELD, TARGET_CAPACITY_SPECIFICATION_FIELD));

    private final String excessCapacityTerminationPolicy;

    private final String fleetId;

    private final TargetCapacitySpecificationRequest targetCapacitySpecification;

    private ModifyFleetRequest(BuilderImpl builder) {
        super(builder);
        this.excessCapacityTerminationPolicy = builder.excessCapacityTerminationPolicy;
        this.fleetId = builder.fleetId;
        this.targetCapacitySpecification = builder.targetCapacitySpecification;
    }

    /**
     * <p>
     * Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is
     * decreased below the current size of the EC2 Fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #excessCapacityTerminationPolicy} will return
     * {@link FleetExcessCapacityTerminationPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #excessCapacityTerminationPolicyAsString}.
     * </p>
     * 
     * @return Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is
     *         decreased below the current size of the EC2 Fleet.
     * @see FleetExcessCapacityTerminationPolicy
     */
    public FleetExcessCapacityTerminationPolicy excessCapacityTerminationPolicy() {
        return FleetExcessCapacityTerminationPolicy.fromValue(excessCapacityTerminationPolicy);
    }

    /**
     * <p>
     * Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is
     * decreased below the current size of the EC2 Fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #excessCapacityTerminationPolicy} will return
     * {@link FleetExcessCapacityTerminationPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #excessCapacityTerminationPolicyAsString}.
     * </p>
     * 
     * @return Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is
     *         decreased below the current size of the EC2 Fleet.
     * @see FleetExcessCapacityTerminationPolicy
     */
    public String excessCapacityTerminationPolicyAsString() {
        return excessCapacityTerminationPolicy;
    }

    /**
     * <p>
     * The ID of the EC2 Fleet.
     * </p>
     * 
     * @return The ID of the EC2 Fleet.
     */
    public String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * The size of the EC2 Fleet.
     * </p>
     * 
     * @return The size of the EC2 Fleet.
     */
    public TargetCapacitySpecificationRequest targetCapacitySpecification() {
        return targetCapacitySpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(excessCapacityTerminationPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(targetCapacitySpecification());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyFleetRequest)) {
            return false;
        }
        ModifyFleetRequest other = (ModifyFleetRequest) obj;
        return Objects.equals(excessCapacityTerminationPolicyAsString(), other.excessCapacityTerminationPolicyAsString())
                && Objects.equals(fleetId(), other.fleetId())
                && Objects.equals(targetCapacitySpecification(), other.targetCapacitySpecification());
    }

    @Override
    public String toString() {
        return ToString.builder("ModifyFleetRequest")
                .add("ExcessCapacityTerminationPolicy", excessCapacityTerminationPolicyAsString()).add("FleetId", fleetId())
                .add("TargetCapacitySpecification", targetCapacitySpecification()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExcessCapacityTerminationPolicy":
            return Optional.ofNullable(clazz.cast(excessCapacityTerminationPolicyAsString()));
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "TargetCapacitySpecification":
            return Optional.ofNullable(clazz.cast(targetCapacitySpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyFleetRequest, T> g) {
        return obj -> g.apply((ModifyFleetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyFleetRequest> {
        /**
         * <p>
         * Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is
         * decreased below the current size of the EC2 Fleet.
         * </p>
         * 
         * @param excessCapacityTerminationPolicy
         *        Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet
         *        is decreased below the current size of the EC2 Fleet.
         * @see FleetExcessCapacityTerminationPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetExcessCapacityTerminationPolicy
         */
        Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy);

        /**
         * <p>
         * Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is
         * decreased below the current size of the EC2 Fleet.
         * </p>
         * 
         * @param excessCapacityTerminationPolicy
         *        Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet
         *        is decreased below the current size of the EC2 Fleet.
         * @see FleetExcessCapacityTerminationPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetExcessCapacityTerminationPolicy
         */
        Builder excessCapacityTerminationPolicy(FleetExcessCapacityTerminationPolicy excessCapacityTerminationPolicy);

        /**
         * <p>
         * The ID of the EC2 Fleet.
         * </p>
         * 
         * @param fleetId
         *        The ID of the EC2 Fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * The size of the EC2 Fleet.
         * </p>
         * 
         * @param targetCapacitySpecification
         *        The size of the EC2 Fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCapacitySpecification(TargetCapacitySpecificationRequest targetCapacitySpecification);

        /**
         * <p>
         * The size of the EC2 Fleet.
         * </p>
         * This is a convenience that creates an instance of the {@link TargetCapacitySpecificationRequest.Builder}
         * avoiding the need to create one manually via {@link TargetCapacitySpecificationRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link TargetCapacitySpecificationRequest.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #targetCapacitySpecification(TargetCapacitySpecificationRequest)}.
         * 
         * @param targetCapacitySpecification
         *        a consumer that will call methods on {@link TargetCapacitySpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetCapacitySpecification(TargetCapacitySpecificationRequest)
         */
        default Builder targetCapacitySpecification(
                Consumer<TargetCapacitySpecificationRequest.Builder> targetCapacitySpecification) {
            return targetCapacitySpecification(TargetCapacitySpecificationRequest.builder()
                    .applyMutation(targetCapacitySpecification).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String excessCapacityTerminationPolicy;

        private String fleetId;

        private TargetCapacitySpecificationRequest targetCapacitySpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyFleetRequest model) {
            super(model);
            excessCapacityTerminationPolicy(model.excessCapacityTerminationPolicy);
            fleetId(model.fleetId);
            targetCapacitySpecification(model.targetCapacitySpecification);
        }

        public final String getExcessCapacityTerminationPolicy() {
            return excessCapacityTerminationPolicy;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
            return this;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(FleetExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy(excessCapacityTerminationPolicy.toString());
            return this;
        }

        public final void setExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
        }

        public final String getFleetId() {
            return fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final TargetCapacitySpecificationRequest.Builder getTargetCapacitySpecification() {
            return targetCapacitySpecification != null ? targetCapacitySpecification.toBuilder() : null;
        }

        @Override
        public final Builder targetCapacitySpecification(TargetCapacitySpecificationRequest targetCapacitySpecification) {
            this.targetCapacitySpecification = targetCapacitySpecification;
            return this;
        }

        public final void setTargetCapacitySpecification(
                TargetCapacitySpecificationRequest.BuilderImpl targetCapacitySpecification) {
            this.targetCapacitySpecification = targetCapacitySpecification != null ? targetCapacitySpecification.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyFleetRequest build() {
            return new ModifyFleetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
