/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an address range of an IPv4 address pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublicIpv4PoolRange implements SdkPojo, Serializable,
        ToCopyableBuilder<PublicIpv4PoolRange.Builder, PublicIpv4PoolRange> {
    private static final SdkField<String> FIRST_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PublicIpv4PoolRange::firstAddress))
            .setter(setter(Builder::firstAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstAddress")
                    .unmarshallLocationName("firstAddress").build()).build();

    private static final SdkField<String> LAST_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PublicIpv4PoolRange::lastAddress))
            .setter(setter(Builder::lastAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAddress")
                    .unmarshallLocationName("lastAddress").build()).build();

    private static final SdkField<Integer> ADDRESS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PublicIpv4PoolRange::addressCount))
            .setter(setter(Builder::addressCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressCount")
                    .unmarshallLocationName("addressCount").build()).build();

    private static final SdkField<Integer> AVAILABLE_ADDRESS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PublicIpv4PoolRange::availableAddressCount))
            .setter(setter(Builder::availableAddressCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableAddressCount")
                    .unmarshallLocationName("availableAddressCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIRST_ADDRESS_FIELD,
            LAST_ADDRESS_FIELD, ADDRESS_COUNT_FIELD, AVAILABLE_ADDRESS_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String firstAddress;

    private final String lastAddress;

    private final Integer addressCount;

    private final Integer availableAddressCount;

    private PublicIpv4PoolRange(BuilderImpl builder) {
        this.firstAddress = builder.firstAddress;
        this.lastAddress = builder.lastAddress;
        this.addressCount = builder.addressCount;
        this.availableAddressCount = builder.availableAddressCount;
    }

    /**
     * <p>
     * The first IP address in the range.
     * </p>
     * 
     * @return The first IP address in the range.
     */
    public String firstAddress() {
        return firstAddress;
    }

    /**
     * <p>
     * The last IP address in the range.
     * </p>
     * 
     * @return The last IP address in the range.
     */
    public String lastAddress() {
        return lastAddress;
    }

    /**
     * <p>
     * The number of addresses in the range.
     * </p>
     * 
     * @return The number of addresses in the range.
     */
    public Integer addressCount() {
        return addressCount;
    }

    /**
     * <p>
     * The number of available addresses in the range.
     * </p>
     * 
     * @return The number of available addresses in the range.
     */
    public Integer availableAddressCount() {
        return availableAddressCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(firstAddress());
        hashCode = 31 * hashCode + Objects.hashCode(lastAddress());
        hashCode = 31 * hashCode + Objects.hashCode(addressCount());
        hashCode = 31 * hashCode + Objects.hashCode(availableAddressCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublicIpv4PoolRange)) {
            return false;
        }
        PublicIpv4PoolRange other = (PublicIpv4PoolRange) obj;
        return Objects.equals(firstAddress(), other.firstAddress()) && Objects.equals(lastAddress(), other.lastAddress())
                && Objects.equals(addressCount(), other.addressCount())
                && Objects.equals(availableAddressCount(), other.availableAddressCount());
    }

    @Override
    public String toString() {
        return ToString.builder("PublicIpv4PoolRange").add("FirstAddress", firstAddress()).add("LastAddress", lastAddress())
                .add("AddressCount", addressCount()).add("AvailableAddressCount", availableAddressCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirstAddress":
            return Optional.ofNullable(clazz.cast(firstAddress()));
        case "LastAddress":
            return Optional.ofNullable(clazz.cast(lastAddress()));
        case "AddressCount":
            return Optional.ofNullable(clazz.cast(addressCount()));
        case "AvailableAddressCount":
            return Optional.ofNullable(clazz.cast(availableAddressCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublicIpv4PoolRange, T> g) {
        return obj -> g.apply((PublicIpv4PoolRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PublicIpv4PoolRange> {
        /**
         * <p>
         * The first IP address in the range.
         * </p>
         * 
         * @param firstAddress
         *        The first IP address in the range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstAddress(String firstAddress);

        /**
         * <p>
         * The last IP address in the range.
         * </p>
         * 
         * @param lastAddress
         *        The last IP address in the range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAddress(String lastAddress);

        /**
         * <p>
         * The number of addresses in the range.
         * </p>
         * 
         * @param addressCount
         *        The number of addresses in the range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressCount(Integer addressCount);

        /**
         * <p>
         * The number of available addresses in the range.
         * </p>
         * 
         * @param availableAddressCount
         *        The number of available addresses in the range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableAddressCount(Integer availableAddressCount);
    }

    static final class BuilderImpl implements Builder {
        private String firstAddress;

        private String lastAddress;

        private Integer addressCount;

        private Integer availableAddressCount;

        private BuilderImpl() {
        }

        private BuilderImpl(PublicIpv4PoolRange model) {
            firstAddress(model.firstAddress);
            lastAddress(model.lastAddress);
            addressCount(model.addressCount);
            availableAddressCount(model.availableAddressCount);
        }

        public final String getFirstAddress() {
            return firstAddress;
        }

        @Override
        public final Builder firstAddress(String firstAddress) {
            this.firstAddress = firstAddress;
            return this;
        }

        public final void setFirstAddress(String firstAddress) {
            this.firstAddress = firstAddress;
        }

        public final String getLastAddress() {
            return lastAddress;
        }

        @Override
        public final Builder lastAddress(String lastAddress) {
            this.lastAddress = lastAddress;
            return this;
        }

        public final void setLastAddress(String lastAddress) {
            this.lastAddress = lastAddress;
        }

        public final Integer getAddressCount() {
            return addressCount;
        }

        @Override
        public final Builder addressCount(Integer addressCount) {
            this.addressCount = addressCount;
            return this;
        }

        public final void setAddressCount(Integer addressCount) {
            this.addressCount = addressCount;
        }

        public final Integer getAvailableAddressCount() {
            return availableAddressCount;
        }

        @Override
        public final Builder availableAddressCount(Integer availableAddressCount) {
            this.availableAddressCount = availableAddressCount;
            return this;
        }

        public final void setAvailableAddressCount(Integer availableAddressCount) {
            this.availableAddressCount = availableAddressCount;
        }

        @Override
        public PublicIpv4PoolRange build() {
            return new PublicIpv4PoolRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
