/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of Spot Instances in an EC2 Fleet request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpotOptionsRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<SpotOptionsRequest.Builder, SpotOptionsRequest> {
    private static final SdkField<String> ALLOCATION_STRATEGY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SpotOptionsRequest::allocationStrategyAsString))
            .setter(setter(Builder::allocationStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationStrategy")
                    .unmarshallLocationName("AllocationStrategy").build()).build();

    private static final SdkField<String> INSTANCE_INTERRUPTION_BEHAVIOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SpotOptionsRequest::instanceInterruptionBehaviorAsString))
            .setter(setter(Builder::instanceInterruptionBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInterruptionBehavior")
                    .unmarshallLocationName("InstanceInterruptionBehavior").build()).build();

    private static final SdkField<Integer> INSTANCE_POOLS_TO_USE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SpotOptionsRequest::instancePoolsToUseCount))
            .setter(setter(Builder::instancePoolsToUseCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePoolsToUseCount")
                    .unmarshallLocationName("InstancePoolsToUseCount").build()).build();

    private static final SdkField<Boolean> SINGLE_INSTANCE_TYPE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(SpotOptionsRequest::singleInstanceType))
            .setter(setter(Builder::singleInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleInstanceType")
                    .unmarshallLocationName("SingleInstanceType").build()).build();

    private static final SdkField<Integer> MIN_TARGET_CAPACITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SpotOptionsRequest::minTargetCapacity))
            .setter(setter(Builder::minTargetCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinTargetCapacity")
                    .unmarshallLocationName("MinTargetCapacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_STRATEGY_FIELD,
            INSTANCE_INTERRUPTION_BEHAVIOR_FIELD, INSTANCE_POOLS_TO_USE_COUNT_FIELD, SINGLE_INSTANCE_TYPE_FIELD,
            MIN_TARGET_CAPACITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String allocationStrategy;

    private final String instanceInterruptionBehavior;

    private final Integer instancePoolsToUseCount;

    private final Boolean singleInstanceType;

    private final Integer minTargetCapacity;

    private SpotOptionsRequest(BuilderImpl builder) {
        this.allocationStrategy = builder.allocationStrategy;
        this.instanceInterruptionBehavior = builder.instanceInterruptionBehavior;
        this.instancePoolsToUseCount = builder.instancePoolsToUseCount;
        this.singleInstanceType = builder.singleInstanceType;
        this.minTargetCapacity = builder.minTargetCapacity;
    }

    /**
     * <p>
     * Indicates how to allocate the target capacity across the Spot pools specified by the Spot Fleet request. The
     * default is <code>lowestPrice</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allocationStrategy} will return {@link SpotAllocationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #allocationStrategyAsString}.
     * </p>
     * 
     * @return Indicates how to allocate the target capacity across the Spot pools specified by the Spot Fleet request.
     *         The default is <code>lowestPrice</code>.
     * @see SpotAllocationStrategy
     */
    public SpotAllocationStrategy allocationStrategy() {
        return SpotAllocationStrategy.fromValue(allocationStrategy);
    }

    /**
     * <p>
     * Indicates how to allocate the target capacity across the Spot pools specified by the Spot Fleet request. The
     * default is <code>lowestPrice</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #allocationStrategy} will return {@link SpotAllocationStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #allocationStrategyAsString}.
     * </p>
     * 
     * @return Indicates how to allocate the target capacity across the Spot pools specified by the Spot Fleet request.
     *         The default is <code>lowestPrice</code>.
     * @see SpotAllocationStrategy
     */
    public String allocationStrategyAsString() {
        return allocationStrategy;
    }

    /**
     * <p>
     * The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceInterruptionBehavior} will return {@link SpotInstanceInterruptionBehavior#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #instanceInterruptionBehaviorAsString}.
     * </p>
     * 
     * @return The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
     * @see SpotInstanceInterruptionBehavior
     */
    public SpotInstanceInterruptionBehavior instanceInterruptionBehavior() {
        return SpotInstanceInterruptionBehavior.fromValue(instanceInterruptionBehavior);
    }

    /**
     * <p>
     * The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceInterruptionBehavior} will return {@link SpotInstanceInterruptionBehavior#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #instanceInterruptionBehaviorAsString}.
     * </p>
     * 
     * @return The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
     * @see SpotInstanceInterruptionBehavior
     */
    public String instanceInterruptionBehaviorAsString() {
        return instanceInterruptionBehavior;
    }

    /**
     * <p>
     * The number of Spot pools across which to allocate your target Spot capacity. Valid only when Spot
     * <b>AllocationStrategy</b> is set to <code>lowest-price</code>. EC2 Fleet selects the cheapest Spot pools and
     * evenly allocates your target Spot capacity across the number of Spot pools that you specify.
     * </p>
     * 
     * @return The number of Spot pools across which to allocate your target Spot capacity. Valid only when Spot
     *         <b>AllocationStrategy</b> is set to <code>lowest-price</code>. EC2 Fleet selects the cheapest Spot pools
     *         and evenly allocates your target Spot capacity across the number of Spot pools that you specify.
     */
    public Integer instancePoolsToUseCount() {
        return instancePoolsToUseCount;
    }

    /**
     * <p>
     * Indicates that the fleet uses a single instance type to launch all Spot Instances in the fleet.
     * </p>
     * 
     * @return Indicates that the fleet uses a single instance type to launch all Spot Instances in the fleet.
     */
    public Boolean singleInstanceType() {
        return singleInstanceType;
    }

    /**
     * <p>
     * The minimum target capacity for Spot Instances in the fleet. If the minimum target capacity is not reached, the
     * fleet launches no instances.
     * </p>
     * 
     * @return The minimum target capacity for Spot Instances in the fleet. If the minimum target capacity is not
     *         reached, the fleet launches no instances.
     */
    public Integer minTargetCapacity() {
        return minTargetCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allocationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceInterruptionBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instancePoolsToUseCount());
        hashCode = 31 * hashCode + Objects.hashCode(singleInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(minTargetCapacity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotOptionsRequest)) {
            return false;
        }
        SpotOptionsRequest other = (SpotOptionsRequest) obj;
        return Objects.equals(allocationStrategyAsString(), other.allocationStrategyAsString())
                && Objects.equals(instanceInterruptionBehaviorAsString(), other.instanceInterruptionBehaviorAsString())
                && Objects.equals(instancePoolsToUseCount(), other.instancePoolsToUseCount())
                && Objects.equals(singleInstanceType(), other.singleInstanceType())
                && Objects.equals(minTargetCapacity(), other.minTargetCapacity());
    }

    @Override
    public String toString() {
        return ToString.builder("SpotOptionsRequest").add("AllocationStrategy", allocationStrategyAsString())
                .add("InstanceInterruptionBehavior", instanceInterruptionBehaviorAsString())
                .add("InstancePoolsToUseCount", instancePoolsToUseCount()).add("SingleInstanceType", singleInstanceType())
                .add("MinTargetCapacity", minTargetCapacity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllocationStrategy":
            return Optional.ofNullable(clazz.cast(allocationStrategyAsString()));
        case "InstanceInterruptionBehavior":
            return Optional.ofNullable(clazz.cast(instanceInterruptionBehaviorAsString()));
        case "InstancePoolsToUseCount":
            return Optional.ofNullable(clazz.cast(instancePoolsToUseCount()));
        case "SingleInstanceType":
            return Optional.ofNullable(clazz.cast(singleInstanceType()));
        case "MinTargetCapacity":
            return Optional.ofNullable(clazz.cast(minTargetCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpotOptionsRequest, T> g) {
        return obj -> g.apply((SpotOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpotOptionsRequest> {
        /**
         * <p>
         * Indicates how to allocate the target capacity across the Spot pools specified by the Spot Fleet request. The
         * default is <code>lowestPrice</code>.
         * </p>
         * 
         * @param allocationStrategy
         *        Indicates how to allocate the target capacity across the Spot pools specified by the Spot Fleet
         *        request. The default is <code>lowestPrice</code>.
         * @see SpotAllocationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpotAllocationStrategy
         */
        Builder allocationStrategy(String allocationStrategy);

        /**
         * <p>
         * Indicates how to allocate the target capacity across the Spot pools specified by the Spot Fleet request. The
         * default is <code>lowestPrice</code>.
         * </p>
         * 
         * @param allocationStrategy
         *        Indicates how to allocate the target capacity across the Spot pools specified by the Spot Fleet
         *        request. The default is <code>lowestPrice</code>.
         * @see SpotAllocationStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpotAllocationStrategy
         */
        Builder allocationStrategy(SpotAllocationStrategy allocationStrategy);

        /**
         * <p>
         * The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
         * </p>
         * 
         * @param instanceInterruptionBehavior
         *        The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
         * @see SpotInstanceInterruptionBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpotInstanceInterruptionBehavior
         */
        Builder instanceInterruptionBehavior(String instanceInterruptionBehavior);

        /**
         * <p>
         * The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
         * </p>
         * 
         * @param instanceInterruptionBehavior
         *        The behavior when a Spot Instance is interrupted. The default is <code>terminate</code>.
         * @see SpotInstanceInterruptionBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpotInstanceInterruptionBehavior
         */
        Builder instanceInterruptionBehavior(SpotInstanceInterruptionBehavior instanceInterruptionBehavior);

        /**
         * <p>
         * The number of Spot pools across which to allocate your target Spot capacity. Valid only when Spot
         * <b>AllocationStrategy</b> is set to <code>lowest-price</code>. EC2 Fleet selects the cheapest Spot pools and
         * evenly allocates your target Spot capacity across the number of Spot pools that you specify.
         * </p>
         * 
         * @param instancePoolsToUseCount
         *        The number of Spot pools across which to allocate your target Spot capacity. Valid only when Spot
         *        <b>AllocationStrategy</b> is set to <code>lowest-price</code>. EC2 Fleet selects the cheapest Spot
         *        pools and evenly allocates your target Spot capacity across the number of Spot pools that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancePoolsToUseCount(Integer instancePoolsToUseCount);

        /**
         * <p>
         * Indicates that the fleet uses a single instance type to launch all Spot Instances in the fleet.
         * </p>
         * 
         * @param singleInstanceType
         *        Indicates that the fleet uses a single instance type to launch all Spot Instances in the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleInstanceType(Boolean singleInstanceType);

        /**
         * <p>
         * The minimum target capacity for Spot Instances in the fleet. If the minimum target capacity is not reached,
         * the fleet launches no instances.
         * </p>
         * 
         * @param minTargetCapacity
         *        The minimum target capacity for Spot Instances in the fleet. If the minimum target capacity is not
         *        reached, the fleet launches no instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minTargetCapacity(Integer minTargetCapacity);
    }

    static final class BuilderImpl implements Builder {
        private String allocationStrategy;

        private String instanceInterruptionBehavior;

        private Integer instancePoolsToUseCount;

        private Boolean singleInstanceType;

        private Integer minTargetCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotOptionsRequest model) {
            allocationStrategy(model.allocationStrategy);
            instanceInterruptionBehavior(model.instanceInterruptionBehavior);
            instancePoolsToUseCount(model.instancePoolsToUseCount);
            singleInstanceType(model.singleInstanceType);
            minTargetCapacity(model.minTargetCapacity);
        }

        public final String getAllocationStrategy() {
            return allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @Override
        public final Builder allocationStrategy(SpotAllocationStrategy allocationStrategy) {
            this.allocationStrategy(allocationStrategy.toString());
            return this;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        public final String getInstanceInterruptionBehavior() {
            return instanceInterruptionBehavior;
        }

        @Override
        public final Builder instanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
            return this;
        }

        @Override
        public final Builder instanceInterruptionBehavior(SpotInstanceInterruptionBehavior instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior(instanceInterruptionBehavior.toString());
            return this;
        }

        public final void setInstanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
        }

        public final Integer getInstancePoolsToUseCount() {
            return instancePoolsToUseCount;
        }

        @Override
        public final Builder instancePoolsToUseCount(Integer instancePoolsToUseCount) {
            this.instancePoolsToUseCount = instancePoolsToUseCount;
            return this;
        }

        public final void setInstancePoolsToUseCount(Integer instancePoolsToUseCount) {
            this.instancePoolsToUseCount = instancePoolsToUseCount;
        }

        public final Boolean getSingleInstanceType() {
            return singleInstanceType;
        }

        @Override
        public final Builder singleInstanceType(Boolean singleInstanceType) {
            this.singleInstanceType = singleInstanceType;
            return this;
        }

        public final void setSingleInstanceType(Boolean singleInstanceType) {
            this.singleInstanceType = singleInstanceType;
        }

        public final Integer getMinTargetCapacity() {
            return minTargetCapacity;
        }

        @Override
        public final Builder minTargetCapacity(Integer minTargetCapacity) {
            this.minTargetCapacity = minTargetCapacity;
            return this;
        }

        public final void setMinTargetCapacity(Integer minTargetCapacity) {
            this.minTargetCapacity = minTargetCapacity;
        }

        @Override
        public SpotOptionsRequest build() {
            return new SpotOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
