/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the options for a transit gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayOptions.Builder, TransitGatewayOptions> {
    private static final SdkField<Long> AMAZON_SIDE_ASN_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(TransitGatewayOptions::amazonSideAsn))
            .setter(setter(Builder::amazonSideAsn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonSideAsn")
                    .unmarshallLocationName("amazonSideAsn").build()).build();

    private static final SdkField<String> AUTO_ACCEPT_SHARED_ATTACHMENTS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayOptions::autoAcceptSharedAttachmentsAsString))
            .setter(setter(Builder::autoAcceptSharedAttachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAcceptSharedAttachments")
                    .unmarshallLocationName("autoAcceptSharedAttachments").build()).build();

    private static final SdkField<String> DEFAULT_ROUTE_TABLE_ASSOCIATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayOptions::defaultRouteTableAssociationAsString))
            .setter(setter(Builder::defaultRouteTableAssociation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRouteTableAssociation")
                    .unmarshallLocationName("defaultRouteTableAssociation").build()).build();

    private static final SdkField<String> ASSOCIATION_DEFAULT_ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayOptions::associationDefaultRouteTableId))
            .setter(setter(Builder::associationDefaultRouteTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationDefaultRouteTableId")
                    .unmarshallLocationName("associationDefaultRouteTableId").build()).build();

    private static final SdkField<String> DEFAULT_ROUTE_TABLE_PROPAGATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayOptions::defaultRouteTablePropagationAsString))
            .setter(setter(Builder::defaultRouteTablePropagation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRouteTablePropagation")
                    .unmarshallLocationName("defaultRouteTablePropagation").build()).build();

    private static final SdkField<String> PROPAGATION_DEFAULT_ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayOptions::propagationDefaultRouteTableId))
            .setter(setter(Builder::propagationDefaultRouteTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropagationDefaultRouteTableId")
                    .unmarshallLocationName("propagationDefaultRouteTableId").build()).build();

    private static final SdkField<String> VPN_ECMP_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayOptions::vpnEcmpSupportAsString))
            .setter(setter(Builder::vpnEcmpSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnEcmpSupport")
                    .unmarshallLocationName("vpnEcmpSupport").build()).build();

    private static final SdkField<String> DNS_SUPPORT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(TransitGatewayOptions::dnsSupportAsString))
            .setter(setter(Builder::dnsSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsSupport")
                    .unmarshallLocationName("dnsSupport").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMAZON_SIDE_ASN_FIELD,
            AUTO_ACCEPT_SHARED_ATTACHMENTS_FIELD, DEFAULT_ROUTE_TABLE_ASSOCIATION_FIELD,
            ASSOCIATION_DEFAULT_ROUTE_TABLE_ID_FIELD, DEFAULT_ROUTE_TABLE_PROPAGATION_FIELD,
            PROPAGATION_DEFAULT_ROUTE_TABLE_ID_FIELD, VPN_ECMP_SUPPORT_FIELD, DNS_SUPPORT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long amazonSideAsn;

    private final String autoAcceptSharedAttachments;

    private final String defaultRouteTableAssociation;

    private final String associationDefaultRouteTableId;

    private final String defaultRouteTablePropagation;

    private final String propagationDefaultRouteTableId;

    private final String vpnEcmpSupport;

    private final String dnsSupport;

    private TransitGatewayOptions(BuilderImpl builder) {
        this.amazonSideAsn = builder.amazonSideAsn;
        this.autoAcceptSharedAttachments = builder.autoAcceptSharedAttachments;
        this.defaultRouteTableAssociation = builder.defaultRouteTableAssociation;
        this.associationDefaultRouteTableId = builder.associationDefaultRouteTableId;
        this.defaultRouteTablePropagation = builder.defaultRouteTablePropagation;
        this.propagationDefaultRouteTableId = builder.propagationDefaultRouteTableId;
        this.vpnEcmpSupport = builder.vpnEcmpSupport;
        this.dnsSupport = builder.dnsSupport;
    }

    /**
     * <p>
     * A private Autonomous System Number (ASN) for the Amazon side of a BGP session. The range is 64512 to 65534 for
     * 16-bit ASNs and 4200000000 to 4294967294 for 32-bit ASNs.
     * </p>
     * 
     * @return A private Autonomous System Number (ASN) for the Amazon side of a BGP session. The range is 64512 to
     *         65534 for 16-bit ASNs and 4200000000 to 4294967294 for 32-bit ASNs.
     */
    public Long amazonSideAsn() {
        return amazonSideAsn;
    }

    /**
     * <p>
     * Indicates whether attachment requests are automatically accepted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoAcceptSharedAttachments} will return {@link AutoAcceptSharedAttachmentsValue#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #autoAcceptSharedAttachmentsAsString}.
     * </p>
     * 
     * @return Indicates whether attachment requests are automatically accepted.
     * @see AutoAcceptSharedAttachmentsValue
     */
    public AutoAcceptSharedAttachmentsValue autoAcceptSharedAttachments() {
        return AutoAcceptSharedAttachmentsValue.fromValue(autoAcceptSharedAttachments);
    }

    /**
     * <p>
     * Indicates whether attachment requests are automatically accepted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoAcceptSharedAttachments} will return {@link AutoAcceptSharedAttachmentsValue#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #autoAcceptSharedAttachmentsAsString}.
     * </p>
     * 
     * @return Indicates whether attachment requests are automatically accepted.
     * @see AutoAcceptSharedAttachmentsValue
     */
    public String autoAcceptSharedAttachmentsAsString() {
        return autoAcceptSharedAttachments;
    }

    /**
     * <p>
     * Indicates whether resource attachments are automatically associated with the default association route table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultRouteTableAssociation} will return
     * {@link DefaultRouteTableAssociationValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #defaultRouteTableAssociationAsString}.
     * </p>
     * 
     * @return Indicates whether resource attachments are automatically associated with the default association route
     *         table.
     * @see DefaultRouteTableAssociationValue
     */
    public DefaultRouteTableAssociationValue defaultRouteTableAssociation() {
        return DefaultRouteTableAssociationValue.fromValue(defaultRouteTableAssociation);
    }

    /**
     * <p>
     * Indicates whether resource attachments are automatically associated with the default association route table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultRouteTableAssociation} will return
     * {@link DefaultRouteTableAssociationValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #defaultRouteTableAssociationAsString}.
     * </p>
     * 
     * @return Indicates whether resource attachments are automatically associated with the default association route
     *         table.
     * @see DefaultRouteTableAssociationValue
     */
    public String defaultRouteTableAssociationAsString() {
        return defaultRouteTableAssociation;
    }

    /**
     * <p>
     * The ID of the default association route table.
     * </p>
     * 
     * @return The ID of the default association route table.
     */
    public String associationDefaultRouteTableId() {
        return associationDefaultRouteTableId;
    }

    /**
     * <p>
     * Indicates whether resource attachments automatically propagate routes to the default propagation route table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultRouteTablePropagation} will return
     * {@link DefaultRouteTablePropagationValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #defaultRouteTablePropagationAsString}.
     * </p>
     * 
     * @return Indicates whether resource attachments automatically propagate routes to the default propagation route
     *         table.
     * @see DefaultRouteTablePropagationValue
     */
    public DefaultRouteTablePropagationValue defaultRouteTablePropagation() {
        return DefaultRouteTablePropagationValue.fromValue(defaultRouteTablePropagation);
    }

    /**
     * <p>
     * Indicates whether resource attachments automatically propagate routes to the default propagation route table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultRouteTablePropagation} will return
     * {@link DefaultRouteTablePropagationValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #defaultRouteTablePropagationAsString}.
     * </p>
     * 
     * @return Indicates whether resource attachments automatically propagate routes to the default propagation route
     *         table.
     * @see DefaultRouteTablePropagationValue
     */
    public String defaultRouteTablePropagationAsString() {
        return defaultRouteTablePropagation;
    }

    /**
     * <p>
     * The ID of the default propagation route table.
     * </p>
     * 
     * @return The ID of the default propagation route table.
     */
    public String propagationDefaultRouteTableId() {
        return propagationDefaultRouteTableId;
    }

    /**
     * <p>
     * Indicates whether Equal Cost Multipath Protocol support is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vpnEcmpSupport}
     * will return {@link VpnEcmpSupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #vpnEcmpSupportAsString}.
     * </p>
     * 
     * @return Indicates whether Equal Cost Multipath Protocol support is enabled.
     * @see VpnEcmpSupportValue
     */
    public VpnEcmpSupportValue vpnEcmpSupport() {
        return VpnEcmpSupportValue.fromValue(vpnEcmpSupport);
    }

    /**
     * <p>
     * Indicates whether Equal Cost Multipath Protocol support is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vpnEcmpSupport}
     * will return {@link VpnEcmpSupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #vpnEcmpSupportAsString}.
     * </p>
     * 
     * @return Indicates whether Equal Cost Multipath Protocol support is enabled.
     * @see VpnEcmpSupportValue
     */
    public String vpnEcmpSupportAsString() {
        return vpnEcmpSupport;
    }

    /**
     * <p>
     * Indicates whether DNS support is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dnsSupport} will
     * return {@link DnsSupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dnsSupportAsString}.
     * </p>
     * 
     * @return Indicates whether DNS support is enabled.
     * @see DnsSupportValue
     */
    public DnsSupportValue dnsSupport() {
        return DnsSupportValue.fromValue(dnsSupport);
    }

    /**
     * <p>
     * Indicates whether DNS support is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dnsSupport} will
     * return {@link DnsSupportValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dnsSupportAsString}.
     * </p>
     * 
     * @return Indicates whether DNS support is enabled.
     * @see DnsSupportValue
     */
    public String dnsSupportAsString() {
        return dnsSupport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amazonSideAsn());
        hashCode = 31 * hashCode + Objects.hashCode(autoAcceptSharedAttachmentsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRouteTableAssociationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(associationDefaultRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRouteTablePropagationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(propagationDefaultRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(vpnEcmpSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dnsSupportAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayOptions)) {
            return false;
        }
        TransitGatewayOptions other = (TransitGatewayOptions) obj;
        return Objects.equals(amazonSideAsn(), other.amazonSideAsn())
                && Objects.equals(autoAcceptSharedAttachmentsAsString(), other.autoAcceptSharedAttachmentsAsString())
                && Objects.equals(defaultRouteTableAssociationAsString(), other.defaultRouteTableAssociationAsString())
                && Objects.equals(associationDefaultRouteTableId(), other.associationDefaultRouteTableId())
                && Objects.equals(defaultRouteTablePropagationAsString(), other.defaultRouteTablePropagationAsString())
                && Objects.equals(propagationDefaultRouteTableId(), other.propagationDefaultRouteTableId())
                && Objects.equals(vpnEcmpSupportAsString(), other.vpnEcmpSupportAsString())
                && Objects.equals(dnsSupportAsString(), other.dnsSupportAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("TransitGatewayOptions").add("AmazonSideAsn", amazonSideAsn())
                .add("AutoAcceptSharedAttachments", autoAcceptSharedAttachmentsAsString())
                .add("DefaultRouteTableAssociation", defaultRouteTableAssociationAsString())
                .add("AssociationDefaultRouteTableId", associationDefaultRouteTableId())
                .add("DefaultRouteTablePropagation", defaultRouteTablePropagationAsString())
                .add("PropagationDefaultRouteTableId", propagationDefaultRouteTableId())
                .add("VpnEcmpSupport", vpnEcmpSupportAsString()).add("DnsSupport", dnsSupportAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmazonSideAsn":
            return Optional.ofNullable(clazz.cast(amazonSideAsn()));
        case "AutoAcceptSharedAttachments":
            return Optional.ofNullable(clazz.cast(autoAcceptSharedAttachmentsAsString()));
        case "DefaultRouteTableAssociation":
            return Optional.ofNullable(clazz.cast(defaultRouteTableAssociationAsString()));
        case "AssociationDefaultRouteTableId":
            return Optional.ofNullable(clazz.cast(associationDefaultRouteTableId()));
        case "DefaultRouteTablePropagation":
            return Optional.ofNullable(clazz.cast(defaultRouteTablePropagationAsString()));
        case "PropagationDefaultRouteTableId":
            return Optional.ofNullable(clazz.cast(propagationDefaultRouteTableId()));
        case "VpnEcmpSupport":
            return Optional.ofNullable(clazz.cast(vpnEcmpSupportAsString()));
        case "DnsSupport":
            return Optional.ofNullable(clazz.cast(dnsSupportAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayOptions, T> g) {
        return obj -> g.apply((TransitGatewayOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayOptions> {
        /**
         * <p>
         * A private Autonomous System Number (ASN) for the Amazon side of a BGP session. The range is 64512 to 65534
         * for 16-bit ASNs and 4200000000 to 4294967294 for 32-bit ASNs.
         * </p>
         * 
         * @param amazonSideAsn
         *        A private Autonomous System Number (ASN) for the Amazon side of a BGP session. The range is 64512 to
         *        65534 for 16-bit ASNs and 4200000000 to 4294967294 for 32-bit ASNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonSideAsn(Long amazonSideAsn);

        /**
         * <p>
         * Indicates whether attachment requests are automatically accepted.
         * </p>
         * 
         * @param autoAcceptSharedAttachments
         *        Indicates whether attachment requests are automatically accepted.
         * @see AutoAcceptSharedAttachmentsValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoAcceptSharedAttachmentsValue
         */
        Builder autoAcceptSharedAttachments(String autoAcceptSharedAttachments);

        /**
         * <p>
         * Indicates whether attachment requests are automatically accepted.
         * </p>
         * 
         * @param autoAcceptSharedAttachments
         *        Indicates whether attachment requests are automatically accepted.
         * @see AutoAcceptSharedAttachmentsValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoAcceptSharedAttachmentsValue
         */
        Builder autoAcceptSharedAttachments(AutoAcceptSharedAttachmentsValue autoAcceptSharedAttachments);

        /**
         * <p>
         * Indicates whether resource attachments are automatically associated with the default association route table.
         * </p>
         * 
         * @param defaultRouteTableAssociation
         *        Indicates whether resource attachments are automatically associated with the default association route
         *        table.
         * @see DefaultRouteTableAssociationValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultRouteTableAssociationValue
         */
        Builder defaultRouteTableAssociation(String defaultRouteTableAssociation);

        /**
         * <p>
         * Indicates whether resource attachments are automatically associated with the default association route table.
         * </p>
         * 
         * @param defaultRouteTableAssociation
         *        Indicates whether resource attachments are automatically associated with the default association route
         *        table.
         * @see DefaultRouteTableAssociationValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultRouteTableAssociationValue
         */
        Builder defaultRouteTableAssociation(DefaultRouteTableAssociationValue defaultRouteTableAssociation);

        /**
         * <p>
         * The ID of the default association route table.
         * </p>
         * 
         * @param associationDefaultRouteTableId
         *        The ID of the default association route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationDefaultRouteTableId(String associationDefaultRouteTableId);

        /**
         * <p>
         * Indicates whether resource attachments automatically propagate routes to the default propagation route table.
         * </p>
         * 
         * @param defaultRouteTablePropagation
         *        Indicates whether resource attachments automatically propagate routes to the default propagation route
         *        table.
         * @see DefaultRouteTablePropagationValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultRouteTablePropagationValue
         */
        Builder defaultRouteTablePropagation(String defaultRouteTablePropagation);

        /**
         * <p>
         * Indicates whether resource attachments automatically propagate routes to the default propagation route table.
         * </p>
         * 
         * @param defaultRouteTablePropagation
         *        Indicates whether resource attachments automatically propagate routes to the default propagation route
         *        table.
         * @see DefaultRouteTablePropagationValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DefaultRouteTablePropagationValue
         */
        Builder defaultRouteTablePropagation(DefaultRouteTablePropagationValue defaultRouteTablePropagation);

        /**
         * <p>
         * The ID of the default propagation route table.
         * </p>
         * 
         * @param propagationDefaultRouteTableId
         *        The ID of the default propagation route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propagationDefaultRouteTableId(String propagationDefaultRouteTableId);

        /**
         * <p>
         * Indicates whether Equal Cost Multipath Protocol support is enabled.
         * </p>
         * 
         * @param vpnEcmpSupport
         *        Indicates whether Equal Cost Multipath Protocol support is enabled.
         * @see VpnEcmpSupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpnEcmpSupportValue
         */
        Builder vpnEcmpSupport(String vpnEcmpSupport);

        /**
         * <p>
         * Indicates whether Equal Cost Multipath Protocol support is enabled.
         * </p>
         * 
         * @param vpnEcmpSupport
         *        Indicates whether Equal Cost Multipath Protocol support is enabled.
         * @see VpnEcmpSupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpnEcmpSupportValue
         */
        Builder vpnEcmpSupport(VpnEcmpSupportValue vpnEcmpSupport);

        /**
         * <p>
         * Indicates whether DNS support is enabled.
         * </p>
         * 
         * @param dnsSupport
         *        Indicates whether DNS support is enabled.
         * @see DnsSupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsSupportValue
         */
        Builder dnsSupport(String dnsSupport);

        /**
         * <p>
         * Indicates whether DNS support is enabled.
         * </p>
         * 
         * @param dnsSupport
         *        Indicates whether DNS support is enabled.
         * @see DnsSupportValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsSupportValue
         */
        Builder dnsSupport(DnsSupportValue dnsSupport);
    }

    static final class BuilderImpl implements Builder {
        private Long amazonSideAsn;

        private String autoAcceptSharedAttachments;

        private String defaultRouteTableAssociation;

        private String associationDefaultRouteTableId;

        private String defaultRouteTablePropagation;

        private String propagationDefaultRouteTableId;

        private String vpnEcmpSupport;

        private String dnsSupport;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayOptions model) {
            amazonSideAsn(model.amazonSideAsn);
            autoAcceptSharedAttachments(model.autoAcceptSharedAttachments);
            defaultRouteTableAssociation(model.defaultRouteTableAssociation);
            associationDefaultRouteTableId(model.associationDefaultRouteTableId);
            defaultRouteTablePropagation(model.defaultRouteTablePropagation);
            propagationDefaultRouteTableId(model.propagationDefaultRouteTableId);
            vpnEcmpSupport(model.vpnEcmpSupport);
            dnsSupport(model.dnsSupport);
        }

        public final Long getAmazonSideAsn() {
            return amazonSideAsn;
        }

        @Override
        public final Builder amazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
            return this;
        }

        public final void setAmazonSideAsn(Long amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
        }

        public final String getAutoAcceptSharedAttachments() {
            return autoAcceptSharedAttachments;
        }

        @Override
        public final Builder autoAcceptSharedAttachments(String autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments = autoAcceptSharedAttachments;
            return this;
        }

        @Override
        public final Builder autoAcceptSharedAttachments(AutoAcceptSharedAttachmentsValue autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments(autoAcceptSharedAttachments.toString());
            return this;
        }

        public final void setAutoAcceptSharedAttachments(String autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments = autoAcceptSharedAttachments;
        }

        public final String getDefaultRouteTableAssociation() {
            return defaultRouteTableAssociation;
        }

        @Override
        public final Builder defaultRouteTableAssociation(String defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation = defaultRouteTableAssociation;
            return this;
        }

        @Override
        public final Builder defaultRouteTableAssociation(DefaultRouteTableAssociationValue defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation(defaultRouteTableAssociation.toString());
            return this;
        }

        public final void setDefaultRouteTableAssociation(String defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation = defaultRouteTableAssociation;
        }

        public final String getAssociationDefaultRouteTableId() {
            return associationDefaultRouteTableId;
        }

        @Override
        public final Builder associationDefaultRouteTableId(String associationDefaultRouteTableId) {
            this.associationDefaultRouteTableId = associationDefaultRouteTableId;
            return this;
        }

        public final void setAssociationDefaultRouteTableId(String associationDefaultRouteTableId) {
            this.associationDefaultRouteTableId = associationDefaultRouteTableId;
        }

        public final String getDefaultRouteTablePropagation() {
            return defaultRouteTablePropagation;
        }

        @Override
        public final Builder defaultRouteTablePropagation(String defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation = defaultRouteTablePropagation;
            return this;
        }

        @Override
        public final Builder defaultRouteTablePropagation(DefaultRouteTablePropagationValue defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation(defaultRouteTablePropagation.toString());
            return this;
        }

        public final void setDefaultRouteTablePropagation(String defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation = defaultRouteTablePropagation;
        }

        public final String getPropagationDefaultRouteTableId() {
            return propagationDefaultRouteTableId;
        }

        @Override
        public final Builder propagationDefaultRouteTableId(String propagationDefaultRouteTableId) {
            this.propagationDefaultRouteTableId = propagationDefaultRouteTableId;
            return this;
        }

        public final void setPropagationDefaultRouteTableId(String propagationDefaultRouteTableId) {
            this.propagationDefaultRouteTableId = propagationDefaultRouteTableId;
        }

        public final String getVpnEcmpSupport() {
            return vpnEcmpSupport;
        }

        @Override
        public final Builder vpnEcmpSupport(String vpnEcmpSupport) {
            this.vpnEcmpSupport = vpnEcmpSupport;
            return this;
        }

        @Override
        public final Builder vpnEcmpSupport(VpnEcmpSupportValue vpnEcmpSupport) {
            this.vpnEcmpSupport(vpnEcmpSupport.toString());
            return this;
        }

        public final void setVpnEcmpSupport(String vpnEcmpSupport) {
            this.vpnEcmpSupport = vpnEcmpSupport;
        }

        public final String getDnsSupport() {
            return dnsSupport;
        }

        @Override
        public final Builder dnsSupport(String dnsSupport) {
            this.dnsSupport = dnsSupport;
            return this;
        }

        @Override
        public final Builder dnsSupport(DnsSupportValue dnsSupport) {
            this.dnsSupport(dnsSupport.toString());
            return this;
        }

        public final void setDnsSupport(String dnsSupport) {
            this.dnsSupport = dnsSupport;
        }

        @Override
        public TransitGatewayOptions build() {
            return new TransitGatewayOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
