/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of AllocateHosts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AllocateHostsResponse extends Ec2Response implements
        ToCopyableBuilder<AllocateHostsResponse.Builder, AllocateHostsResponse> {
    private static final SdkField<List<String>> HOST_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(AllocateHostsResponse::hostIds))
            .setter(setter(Builder::hostIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostIdSet")
                    .unmarshallLocationName("hostIdSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_IDS_FIELD));

    private final List<String> hostIds;

    private AllocateHostsResponse(BuilderImpl builder) {
        super(builder);
        this.hostIds = builder.hostIds;
    }

    /**
     * <p>
     * The ID of the allocated Dedicated Host. This is used to launch an instance onto a specific host.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The ID of the allocated Dedicated Host. This is used to launch an instance onto a specific host.
     */
    public List<String> hostIds() {
        return hostIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hostIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateHostsResponse)) {
            return false;
        }
        AllocateHostsResponse other = (AllocateHostsResponse) obj;
        return Objects.equals(hostIds(), other.hostIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AllocateHostsResponse").add("HostIds", hostIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostIds":
            return Optional.ofNullable(clazz.cast(hostIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AllocateHostsResponse, T> g) {
        return obj -> g.apply((AllocateHostsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, AllocateHostsResponse> {
        /**
         * <p>
         * The ID of the allocated Dedicated Host. This is used to launch an instance onto a specific host.
         * </p>
         * 
         * @param hostIds
         *        The ID of the allocated Dedicated Host. This is used to launch an instance onto a specific host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIds(Collection<String> hostIds);

        /**
         * <p>
         * The ID of the allocated Dedicated Host. This is used to launch an instance onto a specific host.
         * </p>
         * 
         * @param hostIds
         *        The ID of the allocated Dedicated Host. This is used to launch an instance onto a specific host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIds(String... hostIds);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<String> hostIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateHostsResponse model) {
            super(model);
            hostIds(model.hostIds);
        }

        public final Collection<String> getHostIds() {
            return hostIds;
        }

        @Override
        public final Builder hostIds(Collection<String> hostIds) {
            this.hostIds = ResponseHostIdListCopier.copy(hostIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIds(String... hostIds) {
            hostIds(Arrays.asList(hostIds));
            return this;
        }

        public final void setHostIds(Collection<String> hostIds) {
            this.hostIds = ResponseHostIdListCopier.copy(hostIds);
        }

        @Override
        public AllocateHostsResponse build() {
            return new AllocateHostsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
